C$Procedure      DR2STR ( Converts Duration to DDDAYS:HR:MN:SC.###### )

      SUBROUTINE DR2STR ( DURATN, STRING )

C$ Abstract
C
C     Converts input duration in seconds to DDDAYS:HR:MN:SC.######
C     string.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     None.
C
C$ Declarations

      IMPLICIT NONE

      DOUBLE PRECISION      DURATN
      CHARACTER*(*)         STRING

C$ Brief_I/O
C
C     Variable  I/O  Description
C     --------  ---  --------------------------------------------------
C     DURATN     I   Interval length, seconds
C     STRING     O   Output string, DAYS:HR:MN:SC.######
C
C$ Detailed_Input
C
C     TBD.
C
C$ Detailed_Output
C
C     TBD.
C
C$ Parameters
C
C     None
C
C$ Exceptions
C
C     None.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     TBD.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     B.V. Semenov   (JPL)
C
C$ Version
C
C-    Version 1.0.0, 30-AUG-2008 (BVS)
C
C        Initial version.
C
C-&

C
C     SPICELIB functions
C
      DOUBLE PRECISION      SPD

C
C     Local variables
C
      DOUBLE PRECISION      HDP1
      DOUBLE PRECISION      HDP2
      DOUBLE PRECISION      HDP3


C
C     Make output string.
C
      STRING = '0ddddd:0h:0m:0s.0msecs'

      CALL RMAIND( DURATN, SPD(), HDP1, HDP2 )
      CALL DPFMT ( HDP1, 'dddddd', STRING(1:6) )

      CALL RMAIND( HDP2, 3600.D0, HDP1, HDP3 )
      CALL DPFMT ( HDP1, '0h', STRING(8:9) )

      CALL RMAIND( HDP3,   60.D0, HDP1, HDP2 )
      CALL DPFMT ( HDP1, '0m', STRING(11:12) )

      CALL RMAIND( HDP2,    1.D0, HDP1, HDP3 )
      CALL DPFMT ( HDP1, '0s', STRING(14:15) )

      HDP1 = HDP3 * 1000000.D0
      IF ( HDP1 .GT. 999999.D0 ) THEN
         HDP1 = 999999.D0
      END IF
      CALL DPFMT ( HDP1, '0msecs', STRING(17:22) )

C
C     All done.
C
      RETURN

      END
