C$Procedure      SETUP (Set up the program prediCkt )
 
      SUBROUTINE SETUP ()
 
C$ Abstract
C
C     This routine performs the initialization functions for
C     the program prediCkt.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
 
C$ Brief_I/O
C
C     None.
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine performs various initializations needed by
C     the program prediCkt.  These tasks include:
C
C        1.  Setting up the default units used by the program.
C
C        2.  Control of the way errors are signalled by the program
C
C        3.  Performing preliminary examination of the command line.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 23-MAR-2000 (WLT)
C
C
C-&
C
C     Supporting Functions
C
      LOGICAL               SETBAT
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 32 )
 
      CHARACTER*(WDSIZE)    ANGLE
      CHARACTER*(WDSIZE)    LENGTH
      CHARACTER*(WDSIZE)    TIME
      CHARACTER*(WDSIZE)    MASS
      CHARACTER*(WDSIZE)    CHARGE
      CHARACTER*(WDSIZE)    DUMMY
 
      LOGICAL               INIT
 
 
      ANGLE  = 'DEGREES'
      LENGTH = 'KM'
      TIME   = 'SECONDS'
      MASS   = 'KG'
      CHARGE = 'COULOMBS'
 
      CALL OUNITS ( ANGLE, LENGTH, TIME, MASS, CHARGE, DUMMY )
      CALL ERRPRT ( 'SET', 'SHORT, LONG, TRACEBACK' )
C
C     Make sure that the use of Meta/2 doesn't cause a menu
C     to be displayed offering suggestions on corrections to the
C     command line.
C
      INIT = SETBAT()
 
 
      RETURN
      END
