C$Procedure      NSPIO
 
      SUBROUTINE NSPIO ( LINE, NAME, PORT, OK, STATUS )
C     IMPLICIT NONE
 
C$ Abstract
C
C     IO Manager.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C     Inspekt Version 1.3.0, 21-JUN-1999 (WLT)
C
C        Placed a RETURN before the first entry point.
C
C     Inspekt Version 1.2.0, 15-APR-1996 (WLT)
C
C        This routine is now portable as SPICELIB supplies
C        functionality needed that was previously handled
C        via format statements.
C
C-    Inspekt Version 1.1.0, 16-JUN-1995 (WLT) (HAN)
C
C        Master file for all platforms. Copyright notice added
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
      CHARACTER*(*)         LINE
      CHARACTER*(*)         NAME
      CHARACTER*(*)         PORT
      LOGICAL               OK
      LOGICAL               STATUS ( 3 )
 
C
C     Below are the various types of output files that
C     might be open.
C
      INTEGER               NPORTS
      PARAMETER           ( NPORTS = 4 )
 
      INTEGER               SCREEN
      PARAMETER           ( SCREEN = 6 )
 
      INTEGER               FILSIZ
      PARAMETER           ( FILSIZ = 127 )
 
      INTEGER               LOG
      PARAMETER           ( LOG    = 1 )
 
      INTEGER               STDOUT
      PARAMETER           ( STDOUT = 2 )
 
      INTEGER               SPOOL
      PARAMETER           ( SPOOL  = 3 )
 
C
C     SPICELIB functions
C
      LOGICAL               FAILED
      INTEGER               ISRCHC
      INTEGER               RTRIM
 
      INTEGER               ID
      INTEGER               IOSTAT
      INTEGER               R
      INTEGER               TO
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE  = 32 )
 
      INTEGER               MSGSIZ
      PARAMETER           ( MSGSIZ = 400 )
 
      CHARACTER*(MSGSIZ)    MESSGE
      CHARACTER*(WDSIZE)    PORTS  ( NPORTS )
      CHARACTER*(FILSIZ)    FILES  ( NPORTS )
      INTEGER               UNITS  ( NPORTS )
      LOGICAL               ACTIVE ( NPORTS )
      LOGICAL               OPEN   ( NPORTS )
      LOGICAL               SUSPND ( NPORTS )
 
      SAVE
 
      DATA PORTS   / 'LOG',   'SCREEN', 'SAVE',  'UTILITY'     /
      DATA FILES   / ' ',     ' ',      ' ',     ' '           /
      DATA UNITS   /  0,       SCREEN,   0,       0            /
      DATA ACTIVE  / .FALSE., .TRUE.,   .FALSE., .FALSE.       /
      DATA OPEN    / .FALSE., .TRUE.,   .FALSE., .FALSE.       /
      DATA SUSPND  / .FALSE., .FALSE.,  .FALSE., .FALSE.       /
 
      RETURN
 
C$Procedure NSPOPN
 
      ENTRY NSPOPN ( PORT, NAME )
 
C$ Abstract
C
C     Open a new port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
         R = RTRIM(NAME)
 
         CALL TXTOPN ( NAME(1:R), UNITS(ID) )
 
         IF ( FAILED() ) THEN
            OPEN  (ID) = .FALSE.
            ACTIVE(ID) = .FALSE.
            SUSPND(ID) = .FALSE.
            FILES (ID) =  ' '
            RETURN
         END IF
 
         OPEN  (ID) = .TRUE.
         ACTIVE(ID) = .TRUE.
         SUSPND(ID) = .FALSE.
         FILES (ID) =  NAME
 
         RETURN
 
C$Procedure NSPIOH
 
      ENTRY NSPIOH ( PORT )
 
C$ Abstract
C
C     Inhibit outout to a port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
         ACTIVE(ID) = .FALSE.
         RETURN
C$Procedure NSPIOA
 
      ENTRY NSPIOA ( PORT )
 
C$ Abstract
C
C     Activate a port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-     Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C         This is the configured version of the Command Loop
C         software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
         ACTIVE(ID) = .TRUE.
 
         RETURN
C$Procedure NSPGST
 
      ENTRY NSPGST ( PORT, STATUS )
 
C$ Abstract
C
C     Get the current status of a port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
 
         STATUS(1) = ACTIVE(ID)
         STATUS(2) = OPEN  (ID)
         STATUS(3) = SUSPND(ID)
 
         RETURN
 
C$Procedure NSPPST
 
      ENTRY NSPPST ( PORT, STATUS )
 
C$ Abstract
C
C     Put the status of a port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
 
         ACTIVE(ID) = STATUS(1)
         OPEN  (ID) = STATUS(2)
         SUSPND(ID) = STATUS(3)
 
         RETURN
 
C$Procedure NSPIOC
 
      ENTRY NSPIOC ( PORT )
 
C$ Abstract
C
C     Close a port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
         CLOSE ( UNITS(ID) )
 
         ACTIVE(ID) = .FALSE.
         OPEN  (ID) = .FALSE.
         FILES (ID) = ' '
         SUSPND(ID) = .FALSE.
         RETURN
 
C$Procedure NSPIOS
 
      ENTRY NSPIOS ( PORT )
 
C$ Abstract
C
C     Suspend a port (possibly to be reopened later).
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
C
C        close ( units(id) )
C
         OPEN  ( ID ) = .FALSE.
         SUSPND( ID ) = .TRUE.
 
         RETURN
 
C$Procedure NSPIOR
 
      ENTRY NSPIOR ( PORT, OK )
 
C$ Abstract
C
C     Reopen a suspended port.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            WRITE (6,*) 'Unrecognized port: '
            WRITE (6,*)  PORT
            RETURN
         END IF
 
 
         IF ( .NOT. SUSPND(ID) ) THEN
            OK = .FALSE.
            RETURN
         END IF
 
         OPEN  (ID) = .TRUE.
         SUSPND(ID) = .FALSE.
         OK         = .TRUE.
 
         RETURN
 
C$Procedure NSPWLN
 
      ENTRY NSPWLN ( LINE )
 
C$ Abstract
C
C     Write a line to all open and active ports.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         DO ID = 1, NPORTS
 
            IF ( ACTIVE(ID) .AND. OPEN(ID) ) THEN
 
               TO  =   UNITS(ID)
 
               CALL WRITLN ( LINE, TO )
 
               IF (     ID     .NE. STDOUT
     .             .AND.FAILED()           ) THEN
 
                   R =  RTRIM   ( FILES(ID) )
 
                   CALL TRNLAT  ('UNABLETOWRITETOFILE',        MESSGE )
                   CALL REPMC   ( MESSGE, '#', FILES(ID)(1:R), MESSGE )
                   CALL REPMI   ( MESSGE, '#', IOSTAT,         MESSGE )
 
                   WRITE (6,*)
                   CALL NICEIO_3( MESSGE,  6,
     .                           'LEFT 1 RIGHT 78 NEWLINE /cr' )
                   WRITE (6,*)
 
                  CLOSE ( UNITS(ID) )
 
                  ACTIVE( ID )  = .FALSE.
                  OPEN  ( ID )  = .FALSE.
                  SUSPND( ID )  = .FALSE.
                  FILES ( ID )  = ' '
 
               END IF
 
            END IF
 
         END DO
 
         RETURN
 
C$Procedure FINISH
 
      ENTRY FINISH
 
C$ Abstract
C
C     The final entry point handles closing files and informing the
C     user of the location of these files.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Version
C
C-    Command Loop Configured Version 1.0.0, 3-MAY-1994 (WLT)
C
C        This is the configured version of the Command Loop
C        software as of May 4, 1994
C
C-&
 
         IF ( OPEN(LOG) ) THEN
            CALL TRNLAT ( 'LOGFILWRITTENTO', MESSGE )
            WRITE (6,*)  MESSGE(1:RTRIM(MESSGE))
            WRITE (6,*)  FILES(LOG)(1:RTRIM(FILES(LOG)))
            WRITE (6,*)
            CLOSE ( UNITS(LOG)   )
         END IF
 
         IF ( OPEN(SPOOL) ) THEN
            CALL TRNLAT ( 'SAVFILWRITTENTO', MESSGE )
            WRITE (6,*)  MESSGE(1:RTRIM(MESSGE))
            WRITE (6,*)  FILES(SPOOL)(1:RTRIM(FILES(SPOOL)))
            WRITE (6,*)
            CLOSE ( UNITS(SPOOL) )
         END IF
 
 
         RETURN
 
C$Procedure NSPPFL
 
      ENTRY NSPPFL ( PORT, NAME )
 
C$ Abstract
C
C     Get the name of the file associated with a port.
C$ Version
C
C     Command Loop 1.0.0 16-NOV-1995 (WLT)
C-&
 
         ID = ISRCHC ( PORT, NPORTS, PORTS )
 
         IF ( ID .EQ. 0 ) THEN
            NAME = ' '
            RETURN
         ELSE IF ( ACTIVE(ID) .AND. OPEN(ID) ) THEN
            NAME = FILES(ID)
         ELSE
            NAME = ' '
         END IF
 
         RETURN
 
 
      END
