C$Procedure      NOTES ( Notes about furnished files )
 
      SUBROUTINE NOTES ( TEXT )
 
C$ Abstract
C
C     Construct a set of notes about the files used to support the
C     creation of a predict C-kernel.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     DOCUMENTATION
C
C$ Declarations
 
      IMPLICIT NONE
 
      INTEGER               LBCELL
      PARAMETER           ( LBCELL = -5 )
 
      CHARACTER*(*)         TEXT ( LBCELL : * )
 
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     TEXT      I/O  A cell containing notes about the environment
C
C$ Detailed_Input
C
C     TEXT      An initialized cell of character strings.
C
C$ Detailed_Output
C
C     TEXT      The input cell with text describing the files that
C               have been furnished to the program prediCkt.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine queries the routine "keeper" to determine what files
C     have been furnished to the program predict and creates a block
C     of text suitable for documenting the c-kernel produced by
C     prediCkt.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 23-MAR-2000 (WLT)
C
C
C-&
 
      INTEGER               TXTSIZ
      PARAMETER           ( TXTSIZ = 8 )
 
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 32 )
 
      CHARACTER*(LNSIZE)    MYTEXT ( TXTSIZ )
      CHARACTER*(LNSIZE)    LINE
      CHARACTER*(4)         KIND   ( 4 )
      CHARACTER*(5)         FLAG
      CHARACTER*(LNSIZE)    FILE
      CHARACTER*(LNSIZE)    STYLE
      CHARACTER*(WDSIZE)    FILTYP
      CHARACTER*(WDSIZE)    TIME
      CHARACTER*(LNSIZE)    SOURCE
      INTEGER               HANDLE
      LOGICAL               FOUND
 
 
      INTEGER               I
      INTEGER               WHICH
 
      CALL CURTIM ( TIME )
 
      MYTEXT(  1 ) = ' '
      MYTEXT(  2 ) = '   This C-kernels was produced using th'
     .//             'e SPICE program "prediCkt" on'
      MYTEXT(  3 ) = '   YYYY-MON-DD/HH:MN:SC.  The following'
     .//             ' files were provided in support'
      MYTEXT(  4 ) = '   of the construction of the attitude '
     .//             'given in this kernel.'
      MYTEXT(  5 ) = ' '
      MYTEXT(  6 ) = 'File'
      MYTEXT(  7 ) = 'Type  Name'
      MYTEXT(  8 ) = '----  ------------------------------------------'
 
      CALL REPMC ( MYTEXT(3), 'YYYY-MON-DD/HH:MN:SC', TIME, MYTEXT(3) )
 
      DO I = 1, TXTSIZ
         CALL APPNDC ( MYTEXT(I), TEXT )
      END DO
 
      KIND(1) = 'SPK'
      KIND(2) = 'PCK'
      KIND(3) = 'CK'
      KIND(4) = 'TEXT'
 
 
      DO I = 1, 4
 
         WHICH = 1
         CALL KDATA ( WHICH, KIND(I), FILE, FILTYP, SOURCE, HANDLE,
     .                FOUND )
 
         DO WHILE ( FOUND )
            
            WHICH = WHICH + 1
            FLAG  = KIND(I)
            CALL SUFFIX ( '***', 0, FLAG )
            STYLE = 'LEFT 1 RIGHT 80 HARDSPACE * FLAG ' // FLAG
            
            CALL NICEBT_1 ( FILE, STYLE, TEXT )
            
            CALL KDATA ( WHICH,  KIND(I), FILE, FILTYP, SOURCE,
     .                   HANDLE, FOUND )
 
         END DO
      END DO

      LINE = ' '
      CALL APPNDC ( LINE, TEXT )
      RETURN
      END
