      SUBROUTINE NOTEPD ( TEXT, SIZE, WHICH )

      IMPLICIT NONE
      CHARACTER*(*)         TEXT
      INTEGER               SIZE
      INTEGER               WHICH
       

C
C     Spicelib Functions
C
      INTEGER               CARDC
 
      INTEGER               BSIZE
      PARAMETER           ( BSIZE = 4000 )
 
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      INTEGER               LBCELL
      PARAMETER           ( LBCELL = -5 )
      
      CHARACTER*(LNSIZE)    CMMNTS ( LBCELL : BSIZE )
      SAVE                  CMMNTS
 
      LOGICAL               FIRST
      SAVE                  FIRST
 
      DATA                  FIRST / .TRUE. /
      RETURN
 
CProcedure      REMARK ( Remarks about the fitting process )
 
      ENTRY REMARK ( TEXT )
 
C$ Abstract
C
C     Leave a remark regarding a C-kernel to be constructed by prediCkt.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     KEYWORD
C
C$ Declarations
 

C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     TEXT       I   A line of text remarking about the C-kernel
C
C$ Detailed_Input
C
C     TEXT       is a line of text that should be included in the
C                comments of a C-kernel when the kernel is finished.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine captures output from a prediCkt session that should
C     be included in the comments of the constructed C-kernel.
C
C     Use the companion routine clear to remove all text.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 03-AUG-2000 (WLT)
C
C
C-& 
      IF ( FIRST ) THEN
         FIRST = .FALSE.
         CALL SSIZEC ( BSIZE, CMMNTS )
      END IF
 
      IF ( CARDC(CMMNTS) .LT. BSIZE ) THEN
         CALL APPNDC ( TEXT, CMMNTS )
      END IF
 
      RETURN
 
 
      ENTRY REMCLR

      FIRST = .FALSE.
      CALL SSIZEC ( BSIZE, CMMNTS )
      RETURN
 

      ENTRY REMSIZ ( SIZE )

      SIZE = CARDC( CMMNTS )
      RETURN

      ENTRY REMLIN ( WHICH, TEXT )

      IF ( WHICH .LT. CARDC(CMMNTS ) ) THEN
         TEXT = CMMNTS(WHICH)
      ELSE
         TEXT = ' '
      END IF
      RETURN

      END
