C$Procedure      MKSLEW (Make Slew)
 
      SUBROUTINE MKSLEW ( HANDLE, PLTFRM,
     .                    EPOCH1, EPOCH2,
     .                    FRAME1, FRAME2, REF )
 
C$ Abstract
C
C     Create a C-kernel segment that slews between two dynamic
C     frames.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C      None.
C
C$ Keywords
C
C      C-KERNEL
C
C$ Declarations
 
      IMPLICIT NONE
      INTEGER               HANDLE
      INTEGER               PLTFRM
      DOUBLE PRECISION      EPOCH1
      DOUBLE PRECISION      EPOCH2
      CHARACTER*(*)         FRAME1
      CHARACTER*(*)         FRAME2
      CHARACTER*(*)         REF
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     HANDLE     I   Handle of a DAF open for write
C     PLTFRM     I   C-kernel ID-code
C     EPOCH1     I   Epoch associated with the first frame
C     EPOCH2     I   Epoch associated with the second frame
C     FRAME1     I   First Dynamic Frame
C     FRAME2     I   Second dynamic frame.
C     REF        O   Frame that FRAME2 is defined relative to.
C
C$ Detailed_Input
C
C     HANDLE     is the handle of a DAF open for write access into which
C                the next C-kernel segment will be written.
C
C     PLTFRM     is the C-kernel ID code of the object whose
C                orientation will be modelled as a slew between two
C                frames.
C
C     EPOCH1     Epoch at the beginning of the slew.
C
C     EPOCH2     Epoch at the end of the slew.
C
C     FRAME1     Frame which PLTFRM is aligned at the beginning
C                of the slew.
C
C     FRAME2     Frame which PLTFRM is aligned at the end of the slew.
C
C$ Detailed_Output
C
C     REF        Frame that FRAME2 is defined relative to.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     None.
C
C$ Particulars
C
C     This routine writes a type 3 c-kernel segment that represents
C     the slew between two frames at a constant angular rate from
C     a beginning epoch to an ending epoch.
C
C$ Examples
C
C     See prediCkt.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 3-APR-2000 (WLT)
C
C
C-&
 
C$ Index_Entries
C
C     Create a C-kernel segment that slews between frames
C
C-&
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 40 )
 
      CHARACTER*(WDSIZE)    SEGID
      CHARACTER*(WDSIZE)    FSTFRM
      CHARACTER*(WDSIZE)    BEGINF
      CHARACTER*(WDSIZE)    ENDF
      CHARACTER*(WDSIZE)    REST
 
 
      DOUBLE PRECISION      AV     (   3, 2 )
      DOUBLE PRECISION      Q      ( 0:3, 2 )
      DOUBLE PRECISION      CMAT   (   3, 3 )
      DOUBLE PRECISION      TICK   (      2 )
      DOUBLE PRECISION      FST2RF (   6, 6 )
      DOUBLE PRECISION      REF2CM (   6, 6 )
      DOUBLE PRECISION      FST2CM (   6, 6 )
 
      INTEGER               SCID
 
 
      CALL CKMETA ( PLTFRM, 'SCLK',  SCID )
      CALL SCE2T  ( SCID,    EPOCH1, TICK(1) )
      CALL SCE2T  ( SCID,    EPOCH2, TICK(2) )
C
C     Fetch the orientation at EPOCH1 and construct the appropriate
C     quaternion and angular velocity.
C
      CALL SETFRM ( FRAME1, PLTFRM, FSTFRM )
      CALL DYNMCK ( EPOCH1, CMAT,   AV(1,1) )
      CALL M2Q    ( CMAT,   Q(0,1)          )
 
      CALL SETFRM ( FRAME2, PLTFRM, REF    )
      CALL DYNMCK ( EPOCH2, CMAT, AV(1,2)   )
 
      CALL SXFORM ( FSTFRM, REF,    EPOCH2,  FST2RF  )
      CALL RAV2XF ( CMAT,   AV(1,2),         REF2CM  )
      CALL MXMG   ( REF2CM, FST2RF, 6, 6, 6, FST2CM  )
      CALL XF2RAV ( FST2CM, CMAT,            AV(1,2) )
 
      CALL M2Q    ( CMAT, Q(0,2) )
 
 
      SEGID = 'Slew # to #'
 
      CALL NEXTWD ( FRAME1, BEGINF,  REST )
      CALL NEXTWD ( FRAME2, ENDF,    REST )
 
      CALL REPMC ( SEGID, '#', BEGINF, SEGID )
      CALL REPMC ( SEGID, '#', ENDF,   SEGID )
 
      CALL CKW03 ( HANDLE, TICK(1), TICK(2), PLTFRM,   FSTFRM,  .TRUE.,
     .             SEGID,  2,       TICK,    Q,  AV,   1,        TICK )
 
 
      CALL SETFRM ( FRAME2, PLTFRM, REF  )
 
      RETURN
      END
