C$Procedure      MKCLCK ( Make an SCLK kernel )
 
      SUBROUTINE MKCLCK ( SCLK  )
 
C$ Abstract
C
C     This routine creates a simple SCLK kernel for those times
C     when you don't have a real clock available or you
C     just need something quick and dirty.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C      None.
C
C$ Keywords
C
C      UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
 
      CHARACTER*(*)         SCLK
 
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     SCLK     I   Name of the SCLK File to create
C
C$ Detailed_Input
C
C     SCLK     Name of the SCLK File to create.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     This routine creates an SCLK kernel that simply models
C     TDB seconds past the input epoch SCLKBG.  The granularity
C     of this clock is 0.1 milliseconds.
C
C     This clock ticks once every 0.1 milliseconds of ET for all
C     time.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine allows anyone creating C-kernels to have a
C     readily available SCLK kernel for the construction of that
C     C-kernel that simply follows ET.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.1.0, 02-NOV-2006 (BVS)
C
C        Replaced LDPOOL with FURNSH in the comments of the output SCLK
C        file.
C
C-    SPICELIB Version 1.0.0, 31-MAR-2000 (WLT)
C
C
C-&
 
C$ Index_Entries
C
C     Create an SCLK kernel that follows ET precisely
C
C-&
C
C
C     SPICELIB Functions
C
      INTEGER               RTRIM
      DOUBLE PRECISION      SPD
C
C     Local Variables
C
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      CHARACTER*(LNSIZE)    TEXT  ( 100 )
      CHARACTER*(LNSIZE)    START
 
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 32 )
 
      CHARACTER*(WDSIZE)    BEGTXT
      CHARACTER*(WDSIZE)    BEGDAT
      CHARACTER*(WDSIZE)    CKSTRT
      CHARACTER*(WDSIZE)    TYPE
 
      INTEGER               SCLKID
      DOUBLE PRECISION      SCLKBG
      DOUBLE PRECISION      WHEN
      INTEGER               SCID
      INTEGER               CKID
      INTEGER               COUNT
      INTEGER               N
      LOGICAL               FOUND
 
      INTEGER               I
      INTEGER               IDCODE
      INTEGER               R
      INTEGER               UNIT
      INTEGER               WHICH
 
 
      INTEGER               STDOUT
      PARAMETER           ( STDOUT = 6 )
 
 
      TEXT(  1 ) = ' '
      TEXT(  2 ) = 'TEST SPICE SCLK Kernel'
      TEXT(  3 ) = '-----------------------------------------'
     .//           '---------------'
      TEXT(  4 ) = ' '
      TEXT(  5 ) = 'This file contains the data necessary for'
     .//           ' converting from ET to'
      TEXT(  6 ) = 'ticks for the fictional spacecraft clock '
     .//           'having id code #.  It is'
      TEXT(  7 ) = 'produced by the utility program prediCkt.'
      TEXT(  8 ) = ' '
      TEXT(  9 ) = 'This SCLK kernel is intended to be used w'
     .//           'ith the test CK file with'
      TEXT( 10 ) = 'structure IDs listed below on board the '
     .//           'spacecraft %.'
      TEXT( 11 ) = ' '
      TEXT( 12 ) = 'This fictional clock begins at ! ET and c'
     .//           'ontinues'
      TEXT( 13 ) = 'for 1 billion seconds.  The clock has a g'
     .//           'ranularity of 0.1'
      TEXT( 14 ) = 'milliseconds.'
      TEXT( 15 ) = ' '
      TEXT( 16 ) = 'This is intended for study purposes or fo'
     .//           'r those situations in'
      TEXT( 17 ) = 'which a clock is not available for the st'
     .//           'ructure whose orientation'
      TEXT( 18 ) = 'will be modelled by a C-kernel.'
      TEXT( 19 ) = ' '
      TEXT( 20 ) = 'If you have any questions about this file'
     .//           ' that these comments don''t'
      TEXT( 21 ) = 'answer, contact Bill Taber at NAIF.'
      TEXT( 22 ) = ' '
      TEXT( 23 ) = '(818) 354-4279'
      TEXT( 24 ) = 'btaber@spice.jpl.nasa.gov'
      TEXT( 25 ) = ' '
      TEXT( 26 ) = ' '
      TEXT( 27 ) = ' '
      TEXT( 28 ) = 'Implementation notes'
      TEXT( 29 ) = '-----------------------------------------'
     .//           '---------------'
      TEXT( 30 ) = ' '
      TEXT( 31 ) = 'This SCLK file is constructed so that the'
     .//           ' valid SCLK strings'
      TEXT( 32 ) = 'are simply the number of TDB seconds that'
     .//           ' have passed'
      TEXT( 33 ) = 'since the Ephemeris epoch !.'
      TEXT( 34 ) = 'Thus 1/ 288929292.8201  simply repres'
     .//           'ents the epoch that occurs'
      TEXT( 35 ) = '288929292.8201 TDB seconds past the ET e'
     .//           'poch !.'
      TEXT( 36 ) = ' '
      TEXT( 37 ) = ' '
      TEXT( 38 ) = 'For all time, the clock runs at the same '
     .//           'rate as TDB. There is only'
      TEXT( 39 ) = 'one partition for this clock.'
      TEXT( 40 ) = ' '
      TEXT( 41 ) = 'You must load this file into the kernel p'
     .//           'ool before using any of the'
      TEXT( 42 ) = 'SPICELIB SCLK routines. The code fragment'
      TEXT( 43 ) = ' '
      TEXT( 44 ) = 'CALL FURNSH ( < name of this file > )'
      TEXT( 45 ) = ' '
      TEXT( 46 ) = 'performs this task. To convert between ET'
     .//           ' and UTC, you will also need'
      TEXT( 47 ) = 'to load a leapseconds kernel. The additio'
     .//           'nal call to FURNSH,'
      TEXT( 48 ) = ' '
      TEXT( 49 ) = 'CALL FURNSH ( < name of your leapsecond f'
     .//           'ile > )'
      TEXT( 50 ) = ' '
      TEXT( 51 ) = 'will accomplish this. Note that you must '
     .//           'supply the actual names of'
      TEXT( 52 ) = 'the files used on your system as argument'
     .//           's to FURNSH. Because the file'
      TEXT( 53 ) = 'names are system dependent, we do not lis'
     .//           't them here.'
      TEXT( 54 ) = ' '
      TEXT( 55 ) = 'For more information, consult your SPICEL'
     .//           'IB required reading files.'
      TEXT( 56 ) = 'The following areas are covered:'
      TEXT( 57 ) = ' '
      TEXT( 58 ) = 'SCLK system                     SCLK requ'
     .//           'ired reading'
      TEXT( 59 ) = 'Time systems and conversion     TIME requ'
     .//           'ired reading'
      TEXT( 60 ) = 'Kernel pool                     KERNEL re'
     .//           'quired reading'
      TEXT( 61 ) = ' '
      TEXT( 62 ) = ' '
      TEXT( 63 ) = 'Kernel data'
      TEXT( 64 ) = '-----------------------------------------'
     .//           '---------------'
      TEXT( 65 ) = ' '
      TEXT( 66 ) = ' '
      TEXT( 67 ) = BEGDAT()
      TEXT( 68 ) = ' '
      TEXT( 69 ) = ' '
      TEXT( 70 ) = 'SCLK_KERNEL_ID             = ( @28-OCT-19'
     .//           '94        )'
      TEXT( 71 ) = ' '
      TEXT( 72 ) = 'SCLK_DATA_TYPE_#           = ( 1 )'
      TEXT( 73 ) = ' '
      TEXT( 74 ) = 'SCLK01_TIME_SYSTEM_#       = ( 1 )'
      TEXT( 75 ) = 'SCLK01_N_FIELDS_#          = ( 2 )'
      TEXT( 76 ) = 'SCLK01_MODULI_#            = ( 1000000000'
     .//           '     10000 )'
      TEXT( 77 ) = 'SCLK01_OFFSETS_#           = ( 0         '
     .//           '0 )'
      TEXT( 78 ) = 'SCLK01_OUTPUT_DELIM_#      = ( 1 )'
      TEXT( 79 ) = ' '
      TEXT( 80 ) = 'SCLK_PARTITION_START_#     = ( 0.00000000'
     .//           '00000E+00 )'
      TEXT( 81 ) = 'SCLK_PARTITION_END_#       = ( 1.00000000'
     .//           'E+14      )'
      TEXT( 82 ) = 'SCLK01_COEFFICIENTS_#      = ( 0.00000000'
     .//           'E+00'
      TEXT( 83 ) = '                               @!'
      TEXT( 84 ) = '                               1  )'
      TEXT( 85 ) = ' '
      TEXT( 86 ) = ' '
      TEXT( 87 ) = 'DELTET/DELTA_T_A    =   32.184'
      TEXT( 88 ) = 'DELTET/K            =    1.657D-3'
      TEXT( 89 ) = 'DELTET/EB           =    1.671D-2'
      TEXT( 90 ) = 'DELTET/M            = (  6.239996D0 1.990'
     .//           '96871D-7 )'
      TEXT( 91 ) = ' '
 
 
 
C
C     Get the ID-codes for the various CK frames
C
      CALL DTPOOL ( 'CK-FRAMES', FOUND, COUNT, TYPE )
 
      DO I = 1, COUNT
 
         CALL GIPOOL ( 'CK-FRAMES', I, 1, N, IDCODE, FOUND )
C
C        And for each such ID, compute the start time for the ID.
C
         CKSTRT = 'CK#START'
         WHICH  = 1
         CALL REPMI ( CKSTRT, '#', IDCODE, CKSTRT )
         CALL GDPOOL( CKSTRT, WHICH, 1, N, WHEN, FOUND )
         SCLKBG = WHEN
 
         DO WHILE ( N .GT. 0 )
            SCLKBG = MIN ( WHEN, SCLKBG )
            WHICH = WHICH + 1
            CALL GDPOOL( CKSTRT, WHICH, 1, N, WHEN, FOUND )
         END DO
 
      END DO
 
      SCLKBG = SCLKBG - SPD()
 
 
      CALL ETCAL  ( SCLKBG,        START )
      CALL CMPRSS ( ' ', 1, START, START )
      R = RTRIM   ( START )
      CALL REPLCH ( START(1:R), ' ', '-', START(1:R) )
 
C
C     Look up the SCLK and Spacecraft ID codes.
C
      CALL GIPOOL ( 'CK-SCLK', 1, 1, N, SCLKID, FOUND )
      CALL GIPOOL ( 'CK-SPK',  1, 1, N, SCID,   FOUND )
 
 
      DO I = 1, 91
         CALL REPMI ( TEXT(I), '#',  SCLKID, TEXT(I) )
         CALL REPMI ( TEXT(I), '%',  SCID,   TEXT(I) )
         CALL REPMC ( TEXT(I), '!',  START,  TEXT(I) )
      END DO
 
 
 
      CALL TXTOPN ( SCLK, UNIT )
 
      DO I = 1, 91
         CALL WRITLN ( TEXT(I), UNIT )
      END DO
 
 
      CALL DTPOOL ( 'CK-FRAMES', FOUND, COUNT, TYPE )
 
      DO I = 1, COUNT
 
         CALL GIPOOL ( 'CK-FRAMES', I, 1, N, CKID, FOUND )
 
         TEXT( 1 ) = 'CK_&_SCLK       =   ^'
         TEXT( 2 ) = 'CK_&_SPK        =   %'
 
         CALL REPMI ( TEXT(1), '^', -SCLKID, TEXT(1) )
         CALL REPMI ( TEXT(1), '&',  CKID,   TEXT(1) )
 
         CALL REPMI ( TEXT(2), '%',  SCID,   TEXT(2) )
         CALL REPMI ( TEXT(2), '&',  CKID,   TEXT(2) )
 
         CALL WRITLN ( TEXT(1), UNIT )
         CALL WRITLN ( TEXT(2), UNIT )
         CALL WRITLN ( ' ',     UNIT )
 
      END DO
 
      TEXT(1) = BEGTXT()
 
      CALL WRITLN ( TEXT(1), UNIT )
      CALL WRITLN ( ' ',     UNIT )
 
 
      CLOSE ( UNIT = UNIT )
 
      END
