C$Procedure      LDDIRS ( Load the direction specifications )
 
      SUBROUTINE LDDIRS ( )
 
C$ Abstract
C
C     This routine reads the specifications of the various directions
C     from the kernel pool and loades them into the direction buffer
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
 
 
C$ Brief_I/O
C
C     None.
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     1) If the direction information in the kernel pool is incomplete
C        or of the wrong format this routine will signal an
C        appropriate error.
C
C$ Particulars
C
C     This routine is simply a gathering in one place of the code
C     necessary to load the direction information from the kernel
C     pool into the direction buffer contained in dyndir.  It
C     allows programs that make use of such directions to be
C     a bit more compact.
C
C$ Examples
C
C     See prediCkt.pgm
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.2.0, 20-JUL-2001 (WLT)
C
C        Added better diagnostics for the case when a direction spec
C        is not correct.
C
C-    SPICELIB Version 1.0.0, 08-AUG-2000 (WLT)
C
C
C-&
C
C     SPICELIB Functions
C
      LOGICAL               RETURN
      LOGICAL               FAILED

      LOGICAL               HAVE
      LOGICAL               M2NAME

      INTEGER               CPOS
      INTEGER               NCPOS
      INTEGER               RTRIM
 
C
C     Parameters
C
      INTEGER               STRSIZ
      PARAMETER           ( STRSIZ = 800 )
 
      INTEGER               SYNSIZ
      PARAMETER           ( SYNSIZ = 80 )
 
      INTEGER               NSYN
      PARAMETER           ( NSYN   = 1 )
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 33 )
 
C
C     Local Variables
C
 
      CHARACTER*(1)         DTYPE
      CHARACTER*(STRSIZ)    DESCRP
      CHARACTER*(SYNSIZ)    ERROR  ( 2 )
      CHARACTER*(STRSIZ)    SPEC
      CHARACTER*(STRSIZ)    REST
      
      CHARACTER*(SYNSIZ)    SYNTAX ( NSYN )
      CHARACTER*(SYNSIZ)    WORK
      CHARACTER*(WDSIZE)    NAME
      CHARACTER*(WDSIZE)    WORD
      CHARACTER*(WDSIZE)    EQW
      CHARACTER*(WDSIZE)    WHICH
      
      INTEGER               BEST
      INTEGER               L1
      INTEGER               L2
      INTEGER               N
      INTEGER               SIZE
      LOGICAL               FOUND
 
C
C     Standard SPICE error handling.
C
      IF ( RETURN() ) THEN
         RETURN
      END IF
 
      CALL CHKIN ( 'LDDIRS')
 
      SYNTAX(1) = '@name[name] = (1:)@word[definition] '
 
      CALL DTPOOL ( 'DIRECTION_SPECS', FOUND, N, DTYPE )
 
      IF ( FOUND .AND. DTYPE .NE. 'C' ) THEN
         CALL SETMSG ( 'The direction specifications must be '
     .   //            'strings. ' )
         CALL SIGERR ( 'PREDICKT(BADDIRECTIONSPEC)' )
         CALL CHKOUT ( 'LDDIRS' )
         RETURN
      ELSE IF ( .NOT. FOUND ) THEN
         CALL CHKOUT ( 'LDDIRS' )
         RETURN
      END IF
C
C     We have some definitions specified, initialize the direction
C     tables in DYNDIR
C
      CALL INITDR ()
 
 
      N = 1
      CALL STPOOL ( 'DIRECTION_SPECS', N, '-', SPEC, SIZE, FOUND )
 
      DO WHILE ( FOUND )
C
C        Check the latest spec against the rudimentary syntax
C        specification.
C
 
         ERROR(1) = ' '
         ERROR(2) = ' '
         
         CALL META_2 ( SPEC, SYNTAX, NSYN, WORK, BEST, ERROR )
         

         IF ( HAVE(ERROR) ) THEN
C
C           If we got an error, the diagnostic returned probably
C           isn't a very good one.  Try to offer better help.
C
            CALL NEXTWD ( SPEC, WORD, REST )
            CALL NEXTWD ( REST, EQW,  REST )
 
            IF ( .NOT. M2NAME( WORD ) ) THEN
               CALL SETMSG ( 'The name of a direction must begin '
     .         //            'with a letter, contain only '
     .         //            'letters, digits and underscores, '
     .         //            'and be 32 or fewer characters in '
     .         //            'length.  The direction name ''#'' '
     .         //            'doesn''t obey these rules. # ' )
 
               CALL ERRCH  ( '#', WORD )
 
               L1 = MIN(CPOS(NAME, 'abcdefghijklmnopqrstuvwxyz', 1),
     .                  CPOS(NAME, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 1) )
 
               L2 = NCPOS ( NAME,
     .                      'abcdefghijklmnopqrstuvwxyz'
     .         //           'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
     .         //           '0123456789_', 1 )
 
               IF ( L1 .NE. 1 ) THEN
                  CALL ERRCH ( '#',
     .                         'The first character is not a letter.')
               ELSE IF ( L2 .LT. RTRIM (WORD) ) THEN
                  CALL INTORD ( L1, WHICH )
                  CALL ERRCH ( '#', 'The # character, ''#'', of '
     .            //                '"#" is not an allowed character.' )
                  CALL ERRCH ( '#', WHICH )
                  CALL ERRCH ( '#', WORD(L1:L1) )
                  CALL ERRCH ( '#', WORD )
               ELSE
                  CALL ERRCH ( '#', ' ' )
               END IF
 
            ELSE IF ( EQW .NE. '=' ) THEN
               CALL SETMSG ( 'Direction specifications must have '
     .         //            'the form <name> = <description>. '
     .         //            'The specification "#" doesn''t. ' )
               CALL ERRCH ( '#', SPEC )
            ELSE
               CALL SETMSG ( ERROR(2) )
            END IF
 
            CALL SIGERR ( 'SPICE(BADDIRECTIONSPEC)' )
            CALL CHKOUT ( 'LDDIRS' )
            RETURN
         END IF
C
C        Extract the basic components from the specification
C
         CALL M2GETA ( 'name',       SPEC, FOUND, NAME   )
         CALL M2GETA ( 'definition', SPEC, FOUND, DESCRP )
C
C        Load the specification.
C
         CALL DYNMPR ( NAME, DESCRP )
 

         IF ( FAILED() ) THEN
            CALL CHKOUT ( 'LDDIRS' )
            RETURN
         END IF
 
         N = N + 1
         CALL STPOOL ( 'DIRECTION_SPECS', N, '-', SPEC, SIZE, FOUND )
         
       END DO
 
      CALL CHKOUT ( 'LDDIRS' )
      RETURN
 
      END
