C$Procedure      FDPOOL ( First value of a kernel pool variable )
 
      SUBROUTINE FDPOOL ( NAME, FIRST, WHICH, FOUND )
 
C$ Abstract
C
C     Retrieve the first value (in the sense of ordering d.p. values)
C     associated with a kernel pool variable.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C      None.
C
C$ Keywords
C
C      POOL
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         NAME
      DOUBLE PRECISION      FIRST
      INTEGER               WHICH
      LOGICAL               FOUND
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     NAME       I   Name of a kernel pool variable
C     FIRST      O   First value for NAME.
C     WHICH      O   Index of FIRST in array of values for NAME
C     FOUND      O   TRUE if NAME is in the kernel pool. Otherwise FALSE
C
C$ Detailed_Input
C
C     NAME       Name of a kernel pool variable
C
C$ Detailed_Output
C
C     FIRST      Value of the smallest d.p. associated with NAME
C
C     WHICH      is the index of FIRST in the set of values for NAME.
C                If a NAME  is not present, WHICH is returned
C                with the value 0.
C
C     FOUND      is returned TRUE if NAME is in the kernel pool.
C                Otherwise it is returned FALSE.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine helps with the task of retrieving the value
C     associated with a kernel pool variable in numeric order.
C
C$ Examples
C
C     To fetch the values in ascending order for a kernel pool variable
C     use this routine together with NDPOOL as shown here.
C
C     Get the first value.
C
C        CALL FDPOOL ( NAME, THIS, WHICH, FOUND )
C
C        DO WHILE ( WHICH .GT. 0 )
C
C           Do something with THIS.  Then fetch
C           the NEXT value.
C
C           LAST = THIS
C           CALL NDPOOL ( NAME, LAST, THIS, WHICH, FOUND )
C
C        END DO
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 31-MAR-2000 (WLT)
C
C
C-&
 
C$ Index_Entries
C
C     smallest value of a kernel pool variable
C
C-&
 
      INTEGER               ROOM
      PARAMETER           ( ROOM = 32 )
 
 
      INTEGER               CASE
      INTEGER               I
      INTEGER               N
 
      DOUBLE PRECISION      VALUES ( ROOM )
 
      WHICH = 0
      CASE  = 1
      N     = 0
 
      CALL GDPOOL ( NAME, CASE, ROOM, N, VALUES, FOUND )
      
      IF ( .NOT. FOUND ) THEN
         RETURN
      END IF
         
      
      DO WHILE ( N .GT. 0 )
 
         DO I = 1, N
 
            IF ( WHICH .EQ. 0 ) THEN
               FIRST  = VALUES(I)
               WHICH = CASE + I - 1
            ELSE IF ( VALUES(I) .LT. FIRST ) THEN
               FIRST  = VALUES(I)
               WHICH = CASE + I - 1
            END IF
 
         END DO
 
         IF ( N .EQ. ROOM ) THEN
            CASE = CASE + ROOM
            CALL GDPOOL ( NAME, CASE, ROOM, N, VALUES, FOUND )
         ELSE
            N = 0
         END IF
 
      END DO
 
      RETURN
      END
