C$Procedure KWPI ( Return and integer value from the command line )

      FUNCTION KWPI( CID, POSNT, DFAULT )

C$ Abstract
C
C     Function to return an integer value associated with a key word
C     parameter and a position designator on the command line.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C  KEY WORD PARAMETER
C  COMMAND LINE
C
C$ Declarations

      INTEGER               KWPI
      INTEGER               POSNT
      INTEGER               DFAULT

      CHARACTER*(*)         CID

C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     KWPI       O   Integer value returned by routine.
C     CID        I   Character key word parameter identifier
C     POSNT      I   Position in the key word parameter list to return
C     DFAULT     I   Default value for parameter.
C
C$ Detailed_Input
C
C     CID        The character string which defines a key word
C                parameter.  This string must be letters only.
C
C     POSNT      The integer location after the key word parameter to
C                parse for a value.
C
C     DFAULT     The default value for a key word parameter position.
C                This value is returned if there is a parse error or
C                if the designated parameter position was not defined
C                on the command line.
C
C$ Detailed_Output
C
C     KWPI       The integer value corresponding to the command line
C                key word parameter at the designated position or the
C                default value corresponding to the same position.
C
C$ Parameters
C
C      None.
C
C$ Exceptions
C
C      Error free.
C
C$ Files
C
C      None.
C
C$ Particulars
C
C      1)  The routine GETCML is required for linking.
C
C      2)  A key word parameter may be any combination of letters.
C          Indicating a parameter on the command line is accomplished by
C          using the designated character with '-' as a prefix.
C
C      3)  Key word parameters are not case sensitive.
C
C$ Examples
C
C      Given a command line of
C
C      prog_name -t 1234 5678
C
C      The command calls
C
C      NUM1 = KWPI( 't', 1, 666 )
C      NUM2 = KWPI( 't', 2, 666 )
C      NUM3 = KWPI( 't', 3, 666 )
C      NUM4 = KWPI( 's', 1, 666 )
C      NUM5 = KWPI( 's', 2, 666 )
C
C      will result in NUM1 = 1234, NUM2 = 5678, NUM3 = 666, NUM4 = 666
C      NUM5 = 666.  There wasn't a -s key word parameter nor was there
C      a third positional entry for the t- key word.
C
C      The calls may be anywhere in a program or subroutine.
C
C$ Restrictions
C
C      1).  A key word parameter may not have a number as the first
C           character.
C
C$ Literature_References
C
C      None.
C
C$ Author_and_Institution
C
C      Ed Wright (JPL)
C
C$ Version
C
C-    Beta SPICELIB Version 1.0.0,  JUL-10-1996 (EDW)
C
C-&

C$ Index_Entries
C
C   None.
C
C-&

C
C     SPICELIB routines
C
      LOGICAL               EQSTR
      INTEGER               LASTNB

C
C     Locals.
C
      CHARACTER*(255)       LINE
      CHARACTER*(255)       ERRMSG

      INTEGER               NITEMS
      INTEGER               PNTER
      INTEGER               NOBLNK
      INTEGER               I
      INTEGER               J

C
C     Maximum number of space delimited items on the command line.
C
      INTEGER               NUMITM
      PARAMETER           ( NUMITM = 30 )


      CHARACTER*(32)        ITEMS  ( NUMITM )
      CHARACTER*(32)        CHTEMP

      LOGICAL               KWFND


C
C     Set the function value to the default value.
C
      KWPI  = DFAULT
      KWFND = .TRUE.

C
C     Get the command line arguments.
C
      CALL GETCML ( LINE )

C
C     Parse for the character identifier.
C
      CALL LPARSE ( LINE, ' ', NUMITM, NITEMS, ITEMS )

C
C     Make the identified with the delimiter character.
C
      NOBLNK = LASTNB( CID )
      CHTEMP = '-'//CID( 1 : NOBLNK )


C
C     Loop over non zero number of items on the command line.
C
      IF ( NITEMS. NE. 0 ) THEN

         DO I = 1, NITEMS

C
C           Is the current item the key word parameter identifier?
C
            IF ( EQSTR( ITEMS( I ), CHTEMP ) ) THEN

C
C              Is there a value at the I + POSNT entry?  If not
C              do nothing.
C
               IF ( ( I + POSNT ) . LE. NITEMS ) THEN

C
C                 Is any item in the ITEMS list from I to I + POSNT
C                 another keyword?  If it is a keyword the first
C                 character will be a '-' and the second will not be
C                 a number.  If so, prepare to jettison the warp core,
C                 a warp core breach is imminent!
C
                  DO J = 1, POSNT

                     CHTEMP = ITEMS( I + J )

C
C                    Test for the key word marker.  If its there, flag
C                    a false.
C
                     IF ( CHTEMP(1:1). EQ. '-' .AND.
     .                    CHTEMP(2:2). NE. '0' .AND.
     .                    CHTEMP(2:2). NE. '1' .AND.
     .                    CHTEMP(2:2). NE. '2' .AND.
     .                    CHTEMP(2:2). NE. '3' .AND.
     .                    CHTEMP(2:2). NE. '4' .AND.
     .                    CHTEMP(2:2). NE. '5' .AND.
     .                    CHTEMP(2:2). NE. '6' .AND.
     .                    CHTEMP(2:2). NE. '7' .AND.
     .                    CHTEMP(2:2). NE. '8' .AND.
     .                    CHTEMP(2:2). NE. '9'      ) THEN

                       KWFND = .FALSE.

                     END IF

                  END DO


C
C                 Is it okay to parse the line for the key word
C                 position parameter?
C
                  IF ( KWFND ) THEN

C
C                    Parse the key word at the indicated parameter
C                    position.
C
                     CALL NPARSI ( ITEMS(I + POSNT), KWPI, ERRMSG,
     .                                                     PNTER )

C
C                    If PNTER does not return a zero, alert the user to
C                    a non fatal error and reset to default.
C

                     IF ( PNTER. NE. 0 ) THEN

                        NOBLNK = LASTNB( ERRMSG )
                        CALL ERRACT ( 'SET' , 'REPORT'         )
                        CALL SETMSG ( ERRMSG                   )
                        CALL SIGERR
     .                      ( 'Error parsing argument' )

                        KWPI = DFAULT

C
C                       Reset error handling to default mode.
C
                        CALL ERRACT ( 'SET' , 'DEFAULT'        )

                     END IF


                  END IF

C
C                    We either have a value or an error, so return now.
C
                  RETURN

               END IF


            END IF


         END DO


      END IF


C
C     If we are here then there was no value returned from the command
C     line, so we will use the default and return.
C

      RETURN
      END
