C$Procedure GETNCL ( Get non-comment, non-blank line from OEM file )
 
      SUBROUTINE GETNCL ( INPUT, LINE, LNUM, TYPE, EOF )
 
C$ Abstract
C
C     Get a non-comment, non-blank line from an OEM file.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     SPK
C     TIME
C
C$ Keywords
C
C     EPHEMERIS
C     FILES
C
C$ Declarations
 
      IMPLICIT NONE 

      CHARACTER*(*)         INPUT
      CHARACTER*(*)         LINE
      INTEGER               LNUM
      CHARACTER*(*)         TYPE
      LOGICAL               EOF
 
C$ Brief_I/O
C
C     Variable  I/O  Description
C     --------  ---  --------------------------------------------------
C     INPUT      I   Name of input OEM file.
C     LINE       O   Non-comment, non-blank output line.
C     LNUM       O   Number of line in OEM file.
C     TYPE       O   Classification of line.
C     EOF        O   Logical flag indicating end-of-file.
C
C$ Detailed_Input
C
C     INPUT          is the name of an OEM file from which a line
C                    of text is to be read.
C
C$ Detailed_Output
C
C     LINE           is the next non-comment, non-blank line obtained
C                    by sequentially reading the input OEM file.
C
C                    LINE contains no more than 255 characters.
C
C     LNUM           is the ordinal position of LINE in the file.
C                    Line numbers start at 1.
C
C     TYPE           is a string indicating the classification of the
C                    output line.  Possible values are:
C
C                       'COMMENT'                
C                       'CREATION_DATE_LINE'     
C                       'DATA_LINE'    
C                       'METADATA_LINE'    
C                       'METADATA_START_LINE'    
C                       'METADATA_STOP_LINE'      
C                       'COVARIANCE_START_LINE'    
C                       'COVARIANCE_STOP_LINE'      
C                       'VERSION_LINE'            
C                       
C     EOF            is a logical flag indicating the end of the input
C                    file has been reached.  When EOF is .TRUE., the 
C                    other output arguments are undefined.  Subsequent
C                    read attempts will continue to return EOF = .TRUE.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If an error occurs while reading the input file, the
C        problem will be diagnosed by a routine called by this
C        routine.
C
C$ Files
C
C     See the description of the argument INPUT.
C
C$ Particulars
C
C     This routine simplifies the logic required in OEM2SPK to 
C     parse an OEM file. 
C
C     This routine relies on the lower-level reader RDOEM.  In
C     particular, the ability to push lines back onto the virtual 
C     input stream is supported by the RDOEM entry point PUSHLN.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     See RDOEM.
C
C$ Literature_References
C
C     [1]  CCSDS Orbit Data Messages Blue Book, version CCSDS 502.0-B-1,
C          September, 2004.
C
C     [2]  CCSDS Orbit Data Messages Blue Book, version CCSDS 502.0-B-2,
C          November, 2009.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C     M.C. Kim        (JPL)
C
C$ Version
C
C-    OEM2SPK Version 2.0.0, 30-AUG-2013 (MCK)
C
C        Updated header.
C
C-    OEM2SPK Version 1.0.0, 25-FEB-2005 (NJB)
C
C-&


C
C     Fetch the next non-comment line, if one is available.
C 
      CALL CHKIN ( 'GETNCL' )

      CALL RDLIN ( INPUT, LINE, LNUM, TYPE, EOF )


      DO WHILE ( TYPE .EQ. 'COMMENT' ) 

         CALL RDLIN ( INPUT, LINE, LNUM, TYPE, EOF )

      END DO

      CALL CHKOUT ( 'GETNCL' )
      RETURN
      END
