C$Procedure CVT01 ( Convert type 1 MEX/Rosetta Orbit/Attitude file )
 
      SUBROUTINE CVT01 ( SETUP, INPUT, OUTPUT, APPEND, CMTFIL )
 
C$ Abstract
C
C     Convert format version 1 MEX/Rosetta ASCII Orbit or Attitude file 
C     to SPK or CK format.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     MEX2KER
C
C$ Declarations
 
      IMPLICIT NONE
 
      CHARACTER*(*)         SETUP
      CHARACTER*(*)         INPUT
      CHARACTER*(*)         OUTPUT
      LOGICAL               APPEND
      CHARACTER*(*)         CMTFIL
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     SETUP      I   Name of setup file.
C     INPUT      I   Name of input MEX/Rosetta file.
C     OUTPUT     I   Name of output SPK or CK file.
C     APPEND     I   Append flag.
C     CMTFIL     I   Name of comment file.
C
C$ Detailed_Input
C
C     SETUP          is the name of an MEX2KER setup file.
C
C     INPUT          is the name of an MEX/Rosetta file to be converted
C                    to SPK or CK format.  This file conforms to the 
C                    format specification given by the 
C                    draft CCSDS Orbit Data Messages Red Book
C                    Acton 502-H.
C
C     OUTPUT         is the name of an SPK or CK file to be written.
C                    OUTPUT may be a new or existing file.
C
C     APPEND         is a logical flag indicating whether to 
C                    append data to an existing output file.
C                    If APPEND is .TRUE., the file designated 
C                    by OUTPUT must exist.  If APPEND is .FALSE.,
C                    the file designated by OUTPUT must not exist.
C
C
C     CMTFIL         is the name of a comment file whose contents
C                    are to be added to the comment area of
C                    the SPK file created by this program.  The
C                    comment file contents precede the default
C                    comments added by MEX2KER.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) Errors detected while reading the MEX file will be 
C        diagnosed by routines called by this routine.
C
C     2) Errors detected while parsing the MEX file will be
C        diagnosed by routines called by this routine.
C
C     3) Errors detected while opening the output SPK or CK file will be
C        diagnosed by routines called by this routine.
C
C     4) Errors detected while writing the output SPK or CK file will be
C        diagnosed by routines called by this routine.
C
C$ Files
C
C     See the descriptions of INPUT and OUTPUT above.
C
C$ Particulars
C
C     None.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C     J. Diaz del Rio (ESA)
C
C$ Version
C
C-    MEX2KER Version 2.0.0, 15-JUL-2014 (NJB) (JDR) (BVS)
C
C        Integrated updates by Jorge Diaz del Rio. These updates
C        enable inclusion of the input file creation time in the
C        comments created by this routine.
C
C-    MEX2KER Version 2.1.0, 26-JUN-2012 (NJB)
C
C        Removed argument RATE from MKSKSG call.
C        Header format was updated.
C
C-    MEX2KER Version 2.0.0, 09-JUL-2003 (NJB)
C
C        Updated to support user-supplied time bounds in setup file.
C     
C-    MEX2KER Version 1.0.0, 13-MAY-2002 (NJB)
C
C-&


C
C     SPICELIB functions
C
      LOGICAL               EQSTR
      LOGICAL               EXISTS
      LOGICAL               FAILED

C
C     Local parameters
C
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )

C
C     Local variables
C
      CHARACTER*(LNSIZE)    CRTTIM
      CHARACTER*(LNSIZE)    FILTYP
      CHARACTER*(LNSIZE)    FRAME
      CHARACTER*(LNSIZE)    LINE
      CHARACTER*(LNSIZE)    METHOD
      CHARACTER*(LNSIZE)    TIMSYS
      CHARACTER*(LNSIZE)    TYPE

      DOUBLE PRECISION      TBEG
      DOUBLE PRECISION      TEND
      DOUBLE PRECISION      RATE
      DOUBLE PRECISION      SPCLIM
      DOUBLE PRECISION      QUOLIM
      DOUBLE PRECISION      KBEG
      DOUBLE PRECISION      KEND

      INTEGER               BODY
      INTEGER               CENTER
      INTEGER               DEGREE
      INTEGER               HANDLE
      INTEGER               LNUM
      INTEGER               N
      INTEGER               SUBTYP

      LOGICAL               LOCAPP
      LOGICAL               EOF
      LOGICAL               FND
      LOGICAL               PASS1

C
C     Saved variables
C
      SAVE                  PASS1

C
C     Initial values
C
      DATA                  PASS1 / .TRUE. /



      CALL CHKIN ( 'CVT01' )
C
C     Capture a local copy of the append flag, since we 
C     update the flag if appending to a non-existent file
C     is requested.
C
      LOCAPP = APPEND

C
C     Read the input file and process each line.
C
      CALL RDLIN ( INPUT, LINE, LNUM, TYPE, EOF ) 

      DO WHILE ( ( .NOT. EOF ) .AND. ( .NOT. FAILED() )  )
         
         IF ( TYPE .EQ. 'METADATA_START_LINE' ) THEN
C
C           Parse the following metadata block.
C
            CALL PRSMET ( INPUT, FILTYP, SUBTYP, BODY,   CENTER, 
     .                    FRAME, TBEG,   TEND,   TIMSYS, CRTTIM )

            IF ( FAILED() ) THEN
               CALL CHKOUT ( 'CVT01' )
               RETURN
            END IF


            IF ( PASS1 ) THEN
C
C              After reading the first metadata block, we know
C              what type of data---ephemeris or attitude---we're
C              going to write.  Open the output file accordingly.
C
               IF (  EQSTR(FILTYP, 'ORBIT FILE')  ) THEN
C
C                 Open the output file for appending or as a new file.
C
                  IF ( LOCAPP .AND. EXISTS(OUTPUT) ) THEN

                     CALL SPKOPA ( OUTPUT, HANDLE )

                  ELSE

                     LOCAPP = .FALSE.
                     CALL SPKOPN ( OUTPUT, OUTPUT, 0, HANDLE )

                  END IF

                  IF ( FAILED() ) THEN
                     CALL CHKOUT ( 'CVT01' )
                     RETURN
                  END IF


               ELSE IF (  EQSTR(FILTYP, 'ATTITUDE FILE')  ) THEN

                  IF ( LOCAPP .AND. EXISTS(OUTPUT) ) THEN

                     CALL DAFOPW ( OUTPUT, HANDLE )

                  ELSE

                     LOCAPP = .FALSE.
                     CALL CKOPN ( OUTPUT, OUTPUT, 0, HANDLE )

                  END IF


                  IF ( FAILED() ) THEN
                     CALL CHKOUT ( 'CVT01' )
                     RETURN
                  END IF

                  CALL GDPOOL ( 'NOMINAL_SCLK_RATE', 
     .                           1, 1, N, RATE, FND )

                  IF ( .NOT. FND ) THEN

                     CALL SETMSG ( 'SCLK rate was not specified  ' //
     .                             'in the setup file.'            )
                     CALL SIGERR ( 'SPICE(KERNELVARNOTFOUND)'      )
                     CALL CHKOUT ( 'CVT01'                         )
                     RETURN

                  END IF

               ELSE 

                  CALL SETMSG ( 'Unrecognized file type <*> ' //
     .                          'returned by PRSMET.'          )
                  CALL ERRCH  ( '*', FILTYP                    )
                  CALL SIGERR ( 'SPICE(BUG)'                   )
                  CALL CHKOUT ( 'CVT01'                        )
                  RETURN

               END IF


C
C              Add comments to the output file.
C   
               CALL ADDCOM ( HANDLE, SETUP, INPUT, OUTPUT, CRTTIM,
     .                       CMTFIL, LOCAPP                       )

               IF ( FAILED() ) THEN
                  CALL CHKOUT ( 'CVT01' )
                  RETURN
               END IF

               PASS1 = .FALSE.

            END IF

C
C
C           The metadata stop line will have been read at this point.
C           The data lines following the metadata block may be
C           processed.  We'll create one or more segments from these
C           data lines.  But first, get the interpolation degree from 
C           the setup file.
C
            CALL GETINT ( METHOD, DEGREE, SPCLIM, QUOLIM, KBEG, KEND )

            IF (  EQSTR(FILTYP, 'ORBIT FILE')  ) THEN

               CALL MKSKSG ( INPUT,   HANDLE,  SUBTYP, 
     .                       DEGREE,  BODY,    CENTER,  FRAME,  
     .                       KBEG,    KEND,    TIMSYS          )
C
C              MAKSEG stops processing when it encounters a new 
C              metadata start line or the end of the input file.
C              In the former case, MAKSEG pushes the line back on
C              the input stream, so the line can be picked up in
C              this routine.
C
            ELSE
C
C              MKCKSG operates differently from MKSKSG:  it 
C              accumulates data from adjacent but non-contiguous 
C              data blocks into interpolation intervals of the same 
C              segment.  Segment breaks occur when internal buffers 
C              are full, or when input data blocks share a common
C              time boundary.
C              
               CALL MKCKSG ( INPUT,   HANDLE,  SUBTYP, 
     .                       DEGREE,  BODY,    FRAME,  
     .                       KBEG,    KEND,    TIMSYS,  RATE   ) 
C
C              When MKCKSG returns, the CK is complete.
C              
               CALL CHKOUT ( 'CVT01' )
               RETURN
               
            END IF


         END IF

         CALL RDLIN ( INPUT, LINE, LNUM, TYPE, EOF ) 

      END DO

      CALL CHKOUT ( 'CVT01' )
      RETURN
      END

      
