C$Procedure STDIO ( Standard input, output )
 
      SUBROUTINE STDIO ( STDIN, STDOUT )
 
C$ Abstract
C
C     Return the logical units to which the standard input and
C     output units are connected.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     VMS
C
C$ Declarations
 
      INTEGER               STDIN
      INTEGER               STDOUT
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     STDIN      O   Standard input unit.
C     STDOUT     O   Standard output unit.
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     STDIN,
C     STDOUT      are the logical units connected to the standard
C                 input and standard output files. If input has not
C                 been redirected, reading from standard input is
C                 identical to reading from the keyboard. If output
C                 has not been redirected, writing to standard
C                 output is identical to writing to the screen.
C                 Reading or writing redirected input or output
C                 is identical to reading or writing from text files.
C
C$ Parameters
C
C     TBD.
C
C$ Exceptions
C
C     TBD.
C
C$ Files
C
C     See arguments STDIN, STDOUT.
C
C$ Particulars
C
C     If you have used (or read about) UNIX, you will know that one
C     of the outstanding features of that system is the ability to
C     redirect input and output from the command line. For example,
C     consider a program ECHO, which echoes lines from standard input
C     to standard output. By default, standard input is the keyboard,
C     standard output is the screen.
C
C        $ echo
C        Each line should appear twice
C        Each line should appear twice
C        once when I type it, and
C        once when I type it, and
C        again when it is echoed.
C        again when it is echoed.
C        ^Z
C        $
C
C     (VMS recognizes the control-Z character as the end of input,
C     UNIX control-D.)
C
C     However, you may redirect standard output to a file,
C
C        $ echo >echo.out
C        Now each line should appear only once,
C        as I type it,
C        because it is being echoed to a file.
C        ^Z
C        $
C
C     Similarly, you may redirect standard input to come from a file
C     instead of from the keyboard,
C
C        $ echo >echo.in
C        Now each line should appear only once,
C        as I type it,
C        because it is being echoed to a file.
C        ^Z
C        $ echo <echo.in
C        Now each line should appear only once,
C        as I type it,
C        because it is being echoed to a file.
C        $
C
C     Or you may eliminate the middleman entirely,
C
C        \literal
C        $ echo <echo.in  >echo.out
C        |endliteral
C
C     It is also possible to append output to an existing file.
C     For example, to concatenate several input files,
C
C        $ echo <first.input   >new.output
C        $ echo <second.input >>new.output
C           .
C           .
C        $ echo <final.input  >>new.output
C        |endliteral
C
C     This routine, which is not portable, is designed to mimic the
C     redirection capability provided by the UNIX and MS-DOS operating
C     systems. In order to determine the files involved in the
C     redirection, STDIO must read the command line used to execute
C     the calling program. Therefore, the program must be executed
C     as a VMS foreign command.
C
C     On the first call, STDIO determines the opens whatever files
C     are to be used as standard input and output. If none are
C     supplied, these default to SYS$INPUT and SYS$OUTPUT respectively.
C     The unit numbers for these files are then returned.
C
C     On subsequent calls, the unit numbers are simply returned,
C     without re-opening the files. This allows low-level subprograms
C     to read from and write to the standard units without forcing
C     the calling program to maintain them in common or to pass them
C     down as arguments.
C
C$ Examples
C
C     In the first example, a program that echos lines from standard
C     input to standard output illustrates the simplest use of STDIO.
C
C        PROGRAM ECHO
C
C        INTEGER       LASTNB
C
C        INTEGER       STDIN
C        INTEGER       STDOUT
C        INTEGER       IOSTAT
C        CHARACTER*80  LINE
C
C        CALL STDIO ( STDIN, STDOUT )
C
C        READ (STDIN,FMT='(A)',IOSTAT=IOSTAT) LINE
C
C        DO WHILE ( IOSTAT .EQ. 0 )
C           WRITE (STDOUT,FMT='(A)') LINE ( 1 : MAX ( 1,LASTNB(LINE) ) )
C           READ  (STDIN,FMT='(A)',IOSTAT=IOSTAT) LINE
C        END DO
C
C        END
C
C     Note that standard output is always treated as a list file,
C     so no carriage control is required.
C
C     In the second (somewhat contrived) example, one subroutine reads
C     each line, another writes the line out. Each time through, the
C     standard input and output units must be identified. Note that
C     each new call does not re-open the input and output files (only
C     the first call does that), but merely reveals the units to which
C     they are connected.
C
C        PROGRAM ECHO
C
C        INTEGER       LASTNB
C
C        CHARACTER*80  LINE
C        LOGICAL       FOUND
C
C        CALL GETLN ( LINE, FOUND )
C
C        DO WHILE ( FOUND )
C           CALL PUTLN ( LINE )
C           CALL GETLN ( LINE, FOUND )
C        END DO
C
C        END
C
C
C        SUBROUTINE GETLN ( LINE, FOUND )
C
C        CHARACTER*(*)      LINE
C        LOGICAL            FOUND
C
C        INTEGER            STDIN
C        INTEGER            STDOUT
C
C        CALL STDIO ( STDIN, STDOUT )
C        READ (STDIN,FMT='(A)',IOSTAT=IOSTAT) LINE
C        FOUND = ( IOSTAT .EQ. 0 )
C
C        RETURN
C        END
C
C
C        SUBROUTINE PUTLN ( LINE )
C
C        CHARACTER*(*)      LINE
C
C        INTEGER            LASTNB
C        INTEGER            STDIN
C        INTEGER            STDOUT
C
C        CALL STDIO ( STDIN, STDOUT )
C        WRITE (STDOUT,FMT='(A)') LINE ( 1 : MAX ( 1, LASTNB ( LINE )) )
C
C        RETURN
C        END
C
C$ Restrictions
C
C     The calling program must be executed as a foreign command,
C
C        $ progx :== $disk:[directory]progx
C           .
C           .
C        $ progx <x.in >x.out
C
C
C$ Literature_References
C
C     [1] I.M. Underwood, ``Redirecting Input and Output,'' JPL IOM
C         314.8-722, 18 Nov 1988.
C
C$ Author_and_Institution
C
C     H.V. Caulfield (JPL)
C
C$ Version
C
C-    Beta Version 1.15.0, 10-MAR-2014 (BVS)
C
C        Updated for SUN-SOLARIS-64BIT-INTEL.
C
C-    Beta Version 1.14.0, 10-MAR-2014 (BVS)
C
C        Updated for PC-LINUX-64BIT-IFORT.
C
C-    Beta Version 1.13.0, 10-MAR-2014 (BVS)
C
C        Updated for PC-CYGWIN-GFORTRAN.
C
C-    Beta Version 1.12.0, 10-MAR-2014 (BVS)
C
C        Updated for PC-CYGWIN-64BIT-GFORTRAN.
C
C-    Beta Version 1.11.0, 13-MAY-2010 (BVS)
C
C        Updated for SUN-SOLARIS-INTEL.
C
C-    Beta Version 1.10.0, 13-MAY-2010 (BVS)
C
C        Updated for PC-WINDOWS-64BIT-IFORT.
C
C-    Beta Version 1.9.0, 13-MAY-2010 (BVS)
C
C        Updated for PC-LINUX-64BIT-GFORTRAN.
C
C-    Beta Version 1.8.0, 13-MAY-2010 (BVS)
C
C        Updated for MAC-OSX-64BIT-IFORT.
C
C-    Beta Version 1.7.0, 13-MAY-2010 (BVS)
C
C        Updated for MAC-OSX-64BIT-GFORTRAN.
C
C-    Beta Version 1.6.0, 18-MAR-2009 (BVS)
C
C        Updated for PC-LINUX-GFORTRAN.
C
C-    Beta Version 1.5.0, 18-MAR-2009 (BVS)
C
C        Updated for MAC-OSX-GFORTRAN.
C
C-    Beta Version 1.4.0, 19-FEB-2008 (BVS)
C
C        Updated for PC-LINUX-IFORT.
C
C-    Beta Version 1.3.0, 14-NOV-2006 (BVS)
C
C        Updated for MAC-OSX-IFORT.
C
C-    Beta Version 1.2.0, 14-NOV-2006 (BVS)
C
C        Updated for PC-WINDOWS-IFORT.
C
C-    Beta Version 1.1.0, 03-JAN-2005 (BVS)
C
C        Updated for PC-CYGWIN.
C
C-    Beta Version 1.0.5, 17-JUL-2002 (BVS)
C
C        Added MAC-OSX environments.
C
C-    Beta Version 1.0.4, 16-AUG-2000 (WLT)
C
C        Added the PC-LINUX environment
C
C-    Beta Version 1.0.3, 08-OCT-1999 (WLT)
C
C        The environment lines were expanded so that the supported
C        environments are now explicitely given.  New
C        environments are WIN-NT
C
C-    Beta Version 1.0.2, 28-JUL-1999 (WLT)
C
C        The environment lines were expanded so that the supported
C        environments are now explicitely given.  New
C        environments are PC-DIGITAL, SGI-O32 and SGI-N32.
C
C-    Beta Version 1.0.1, 18-MAR-1999 (WLT)
C
C        The environment lines were expanded so that the supported
C        environments are now explicitely given.  Previously,
C        environments such as SUN-SUNOS and SUN-SOLARIS were implied
C        by the environment label SUN.
C
C-    Beta Version 1.0.0, 2-JUL-1988 (HVC)
C
C-&
 
      STDIN  = 5
      STDOUT = 6
 
 
      RETURN
      END
