C$Procedure      DAFCPA ( DAF, copy array )

      SUBROUTINE DAFCPA ( FROM, TO )

C$ Abstract
C
C     This subroutine copies an entire array from one DAF
C     file to another. 
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading 
C
C     DAF
C
C$ Keywords
C
C     FILES
C
C$ Declarations

      INTEGER               FROM
      INTEGER               TO
 
C$ Brief_I/O 
C
C     Variable  I/O  Description
C     --------  ---  ---------------------------------------------------
C     FROM       I   The handle of a DAF file array will be copied from.
C     TO         I   The handle of a DAF file array will be copied to.
C     BUFSZ      P   Size of a buffer. 
C     SUMSZ      P   Size of a segment summary array.
C
C$ Detailed_Input
C
C     FROM       The handle of a DAF file array will be copied from.
C
C     TO         The handle of a DAF file array will be copied to
C
C$ Detailed_Output
C
C     NONE 
C
C$ Exceptions
C
C     1) If source and destination files have different number of
C        integer components in their descriptors, then 
C        SPICE(INCOMPATIBLEFILES) is signalled.
C      
C     2) If source and destination files have different number of
C        double precision components in their descriptors, then 
C        SPICE(INCOMPATIBLEFILES) is signalled.      
C
C$ Files 
C
C     See arguments FROM and TO.
C
C$ Particulars 
C
C     It is assumed that the destination file is already opened for
C     writing and a search (forward or backward) for a segment in a
C     source files is in progress. 
C     
C$ Examples 
C
C     In the following fragment of code DAFCPA is used to copy 
C     all segments from one DAF file to another.
C
C
C           CALL DAFOPR ( SOURCE, FROM  )
C           CALL DAFOPW ( TARGET, TO )
C 
C           CALL DAFBFS ( FROM  )
C           CALL DAFFNA ( FOUND )
C 
C           DO WHILE ( FOUND )
C 
C              CALL DAFCPA ( FROM, TO )
C 
C              CALL DAFFNA ( FOUND )
C 
C           END DO
C
C$ Restrictions
C
C     The source file must be opened for read access.  The destination
C     file must be opened for write access.
C 
C     Both files - source and destination - must have the same number
C     of integer and double precision components in descriptors.
C
C$ Literature_References
C
C     NONE.
C
C$ Author_and_Institution
C
C     B.V. Semenov (JPL)
C
C$ Version
C
C-    Beta Version 1.1.0, 20-JAN-2004 (BVS) 
C
C        Replaced DAFRDA with DAFGDA to hook in run-time translation.
C
C-    Beta Version 1.0.0, 19-DEC-1995 (BVS) 
C
C-&

C$ Revisions
C
C-    Beta Version 1.0.0, 19-DEC-1995 (BVS) 
C
C-&   

C
C     Local parameters
C

       INTEGER               BUFSZ
       PARAMETER           ( BUFSZ = 1000 )
       
       INTEGER               SUMSZ
       PARAMETER           ( SUMSZ = 125 )

C
C     SPICELIB functions
C

       LOGICAL               RETURN
      
C
C     Local variables
C

       INTEGER               FA
       INTEGER               FIRST
       INTEGER               IA
       INTEGER               LAST
  
       DOUBLE PRECISION      SUM     ( SUMSZ * 2 )
       CHARACTER*(1000)      NAME
       INTEGER               ND
       INTEGER               NI
       INTEGER               ND1
       INTEGER               NI1
       DOUBLE PRECISION      DC      ( SUMSZ     )
       INTEGER               IC      ( SUMSZ * 2 )
 
       DOUBLE PRECISION      DATA    ( BUFSZ )

C
C     Standard SPICE error handling.
C
      IF ( RETURN () ) THEN
         RETURN
      ELSE
         CALL CHKIN ( 'DAFCPA' )
      END IF
 
C
C     Get  values of
C     ND and NI for source file.

      CALL DAFHSF ( FROM, ND,  NI )
      CALL DAFHSF ( TO,   ND1, NI1 )
      
      IF ( NI .NE. NI1 ) THEN
         CALL SETMSG ( 'Source and destination files have'       //
     .                 ' different number of integers components'//
     .                 ' in their descriptors. '                 )
         CALL SIGERR ( 'SPICE(INCOMPATIBLEFILES)'                )
         CALL CHKOUT ( 'DAFCPA'                                  )
         RETURN
      END IF

      IF ( ND .NE. ND1 ) THEN
         CALL SETMSG ( 'Source and destination files have'      //
     .                 ' different number of double precision'  //
     .                 ' components in their descriptors. '      )
         CALL SIGERR ( 'SPICE(INCOMPATIBLEFILES)'                )
         CALL CHKOUT ( 'DAFCPA'                                  )
         RETURN
      END IF

C
C     Get the summary and name for the array to be copied.
C     Start the new array in destination file.
C
      CALL DAFGS ( SUM  )
      CALL DAFGN ( NAME )
 
      CALL DAFBNA ( TO, SUM, NAME )

C 
C     Unpack the summary to get the initial and final addresses
C     of the original array.
C
      CALL DAFUS ( SUM, ND, NI, DC, IC )
      IA = IC(NI-1)
      FA = IC(NI  )
 
C
C     Copy the elements in groups of buffer size.
C
       FIRST = IA
 
       DO WHILE ( FIRST .LE. FA )
 
         LAST  = MIN ( FA, FIRST + BUFSZ - 1   )
         CALL DAFGDA ( FROM, FIRST, LAST, DATA )
         CALL DAFADA ( DATA, LAST - FIRST + 1  )
         FIRST = FIRST + BUFSZ
 
       END DO
 
C
C     Close array in destination file to make the addition permanent
C
      CALL DAFENA

      CALL CHKOUT ( 'DAFCPA' )
 
      RETURN
      END
 
 
