C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
 
C
C     Get an objects values from an object list.
C
      SUBROUTINE OBJGET ( OBJ, OBJLIS, OBJECT )
 
      IMPLICIT NONE
      INCLUDE              'object.inc'
 
      INTEGER               OBJ    ( 2 )
      INTEGER               OBJLIS ( LBCELL: * )
      INTEGER               OBJECT ( * )
C
C     Local Variables
C
      INTEGER               I
      INTEGER               J
      INTEGER               OBJSIZ
      LOGICAL               OK
 
      CALL OBJCHK ( 'OBJGET', OBJ, OBJLIS, OK )
 
      IF ( .NOT. OK ) THEN
         RETURN
      END IF
 
      IF ( OBJ(2) .EQ. NULL ) THEN
         CALL CHKIN ( 'OBJGET' )
         CALL SETMSG( 'You are attempting to get the values '
     .   //           'associated with an inactive object.  Only '
     .   //           'the values of active objects can be '
     .   //           'retrieved with OBJGET. The value of the '
     .   //           'pointer component of the object was #. ')
         CALL ERRINT( '#', OBJ(1) )
         CALL SIGERR( 'SPICE(INACTIVEOBJECT)' )
         CALL CHKOUT( 'OBJGET' )
      END IF
 
      OBJSIZ = OBJLIS(RMPOBJ) - 1
      I      = OBJ(1) + 1
 
      DO J = 1, OBJSIZ
         OBJECT(J) = OBJLIS(I)
         I         = I + 1
      END DO
 
      RETURN
      END
