C$Procedure PRCINF ( Process an information request )

      SUBROUTINE PRCINF ( INFTYP )

C$ Abstract
C
C     Process an information request:  display "help," "usage," 
C     "template, or program version information.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     AEM2CK
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         INFTYP
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     INFTYP     I   Type of information to display.
C
C$ Detailed_Input
C
C     INFTYP         is a character string indicating the type
C                    of information to display.  The options are:
C
C                       'HELP'        Dump the introduction from
C                                     the user's guide.
C
C                       'TEMPLATE'    Display a setup file template.
C
C                       'USAGE'       Display a terse description
C                                     of the program's invocation
C                                     syntax.
C
C                       'VERSION'     Display the program version
C                                     and creation date.  
C                     
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If the value of INFTYP is not recognized, the error
C        SPICE(NOTSUPPORTED) is signaled.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     This routine centralizes message display functions for 
C     AEM2CK.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     [1]  CCSDS Attitude Data Messages Blue Book, version CCSDS 
C          504.0-B-1, May, 2008.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C     M.C. Kim        (JPL)
C     B.V. Semenov    (JPL)
C
C$ Version
C
C-    AEM2CK Version 1.0.0, 03-MAR-2017 (NJB)
C
C-&

      
C
C     SPICELIB functions
C
      INTEGER               RTRIM

      LOGICAL               EQSTR      
      LOGICAL               RETURN

C
C     Local parameters
C
      CHARACTER*(*)         VER
      PARAMETER           ( VER = '1.1.0, 02-MAR-2017' )

      INTEGER               HSIZE
      PARAMETER           ( HSIZE  = 18 )

      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )

      INTEGER               TSIZE
      PARAMETER           ( TSIZE  = 51 )

      INTEGER               USIZE
      PARAMETER           ( USIZE  = 20 )

      INTEGER               VSTRLN
      PARAMETER           ( VSTRLN = 80 )

C
C     Local variables
C
      CHARACTER*(LNSIZE)    BEGMRK
      CHARACTER*(LNSIZE)    ENDMRK
      CHARACTER*(LNSIZE)    HLPTXT ( HSIZE )
      CHARACTER*(LNSIZE)    TMPTXT ( TSIZE )
      CHARACTER*(LNSIZE)    USGTXT ( USIZE )
      CHARACTER*(VSTRLN)    VERSTR     

      INTEGER               I

      LOGICAL               FIRST

C
C     Saved variables
C
      SAVE                  FIRST
      SAVE                  HLPTXT
      SAVE                  TMPTXT
      SAVE                  USGTXT
      SAVE                  VERSTR

C
C     Initial values
C
      DATA                  FIRST / .TRUE. /



      IF ( RETURN() ) THEN
         RETURN
      END IF

      CALL CHKIN ( 'PRCINF' )


      IF ( FIRST ) THEN
C
C        This lovely mess was created using Bill Taber's ImportText
C        pipe.
C
         HLPTXT(  1 ) = '   AEM2CK is a SPICE-based utility p'
     .   //             'rogram that converts a CCSDS'
         HLPTXT(  2 ) = '   ``Attitude Ephemeris Message'''' '
     .   //             'text file (referred to as an ``AEM'''
     .   //             ''''
         HLPTXT(  3 ) = '   or ``AEM file'''') to a binary SP'
     .   //             'ICE CK file containing type 6'
         HLPTXT(  4 ) = '   segments. This CK file is a binar'
     .   //             'y file constructed according to the'
         HLPTXT(  5 ) = '   DAF (Double precision Array File)'
     .   //             ' architecture.'
         HLPTXT(  6 ) = ' '
         HLPTXT(  7 ) = '   AEM2CK requires as inputs an AEM '
     .   //             'file, a SPICE leapseconds kernel, a'
         HLPTXT(  8 ) = '   spacecraft clock kernel, and a se'
     .   //             'tup file containing commands and'
         HLPTXT(  9 ) = '   data that control AEM2CK''s opera'
     .   //             'tion.'
         HLPTXT( 10 ) = ' '
         HLPTXT( 11 ) = '   The user may optionally specify a'
     .   //             ' text file containing descriptive te'
     .   //             'xt to'
         HLPTXT( 12 ) = '   be placed in the comment area of '
     .   //             'the CK file. (Doing this is highly'
         HLPTXT( 13 ) = '   recommended.)'
         HLPTXT( 14 ) = ' '
         HLPTXT( 15 ) = '   For documentation purposes the co'
     .   //             'ntent of the AEM2CK setup file is'
         HLPTXT( 16 ) = '   automatically placed at the end o'
     .   //             'f the comment area of the CK file.'
         HLPTXT( 17 ) = ' '
         HLPTXT( 18 ) = '   Run the program with -usage comma'
     .   //             'nd line flag to see usage informatio'
     .   //             'n.'
 


         USGTXT(  1 ) = '     Program usage:'
         USGTXT(  2 ) = ' '
         USGTXT(  3 ) = '              > aem2ck  [-setup <setup '
     .   //             'file name>]'
         USGTXT(  4 ) = '                        [-input <input '
     .   //             'data file name>]'
         USGTXT(  5 ) = '                        [-output <outpu'
     .   //             't CK file name>]'
         USGTXT(  6 ) = '                        [-append]'
         USGTXT(  7 ) = '                        [-h|-help]'
         USGTXT(  8 ) = '                        [-t|-template]'
         USGTXT(  9 ) = '                        [-u|-usage]'
         USGTXT( 10 ) = '                        [-v|-version]'
         USGTXT( 11 ) = ' '
         USGTXT( 12 ) = '     If a setup file name isn''t provid'
     .   //             'ed on the command line, the'
         USGTXT( 13 ) = '     program will prompt for it. It wil'
     .   //             'l not prompt for the input'
         USGTXT( 14 ) = '     or output file names; these file n'
     .   //             'ames must be provided on'
         USGTXT( 15 ) = '     the command line or in the setup f'
     .   //             'ile. If input and output'
         USGTXT( 16 ) = '     file names are provided on the com'
     .   //             'mand line, any file names'
         USGTXT( 17 ) = '     assigned using setup keywords are '
     .   //             'ignored. The input file'
         USGTXT( 18 ) = '     must already exist and, if the -ap'
     .   //             'pend key or corresponding'
         USGTXT( 19 ) = '     setup file keyword is not specifie'
     .   //             'd, the output file must be'
         USGTXT( 20 ) = '     a new file.'


         BEGMRK(1:1)  =  CHAR( 92 )
         BEGMRK(2: )  =  'begindata'
         ENDMRK(1:1)  =  BEGMRK(1:1)
         ENDMRK(2: )  =  'begintext'

         
         TMPTXT(  1 ) = 'Complete AEM2CK Setup File Template:'
         TMPTXT(  2 ) = ' '
         TMPTXT(  3 ) = BEGMRK
         TMPTXT(  4 ) = ' '
         TMPTXT(  5 ) = '   KERNELS_TO_LOAD      = ( ''kernel'
     .   //             ' 1'', ''kernel 2'', ... )'
         TMPTXT(  6 ) = '                          Must inclu'
     .   //             'de leapseconds kernel, SCLK kernel,'
         TMPTXT(  7 ) = '                          and frame '
     .   //             'kernel for CK frame.'
         TMPTXT(  8 ) = ' '
         TMPTXT(  9 ) = '   INPUT_AEM_FILE       = ''AEM file'
     .   //             ' name'''
         TMPTXT( 10 ) = '   OUTPUT_CK_FILE       = ''CK file '
     .   //             'name'''
         TMPTXT( 11 ) = ' '
         TMPTXT( 12 ) = '   INTERPOLATION_METHOD = ''HERMITE'''
     .   //             ' or ''LAGRANGE'''
         TMPTXT( 13 ) = '                          This value'
     .   //             ' is a default; it is used when'
         TMPTXT( 14 ) = '                          a meta-dat'
     .   //             'a block does not specify a method.'
         TMPTXT( 15 ) = ' '
         TMPTXT( 16 ) = '   INTERPOLATION_DEGREE = positive i'
     .   //             'nteger. For SPICE compatibility,'
         TMPTXT( 17 ) = '                          should be '
     .   //             'in range 1-23. Should be odd for'
         TMPTXT( 18 ) = '                          Lagrange i'
     .   //             'nterpolation; should be equivalent'
         TMPTXT( 19 ) = '                          to 3 mod 4'
     .   //             ' for Hermite interpolation.'
         TMPTXT( 20 ) = '                          This value'
     .   //             ' is a default; it is used when'
         TMPTXT( 21 ) = '                          a meta-dat'
     .   //             'a block does not specify a method.'
         TMPTXT( 22 ) = '                          (If a meta'
     .   //             '-data block specifies a degree but'
         TMPTXT( 23 ) = '                          not a meth'
     .   //             'od, the default degree from the'
         TMPTXT( 24 ) = '                          setup file'
     .   //             ' is used.)'
         TMPTXT( 25 ) = ' '
         TMPTXT( 26 ) = '   STRING_MAPPING       = ( ''first '
     .   //             'input value'',   ''first mapped valu'
     .   //             'e'','
         TMPTXT( 27 ) = '                            ''second'
     .   //             ' input value'',  ''second mapped val'
     .   //             'ue'','
         TMPTXT( 28 ) = '                             ...  )'
         TMPTXT( 29 ) = ' '
         TMPTXT( 30 ) = '   COMMENT_FILE         = ''comment '
     .   //             'file name'''
         TMPTXT( 31 ) = '   MINIMUM_SPACING      = minimum va'
     .   //             'lid time tag spacing in seconds'
         TMPTXT( 32 ) = ' '
         TMPTXT( 33 ) = '   MAXIMUM_SEP_QUOTIENT = maximum al'
     .   //             'lowed value of'
         TMPTXT( 34 ) = '                          (t3-t2)/(t'
     .   //             '2-t1) and (t2-t1)/(t3-t2) for'
         TMPTXT( 35 ) = '                          consecutiv'
     .   //             'e time tags t1, t2, t3'
         TMPTXT( 36 ) = ' '
         TMPTXT( 37 ) = '   START_TIME           = ''start ti'
     .   //             'me''  This must be a string'
         TMPTXT( 38 ) = '                          allowed by'
     .   //             ' the SPICELIB routine STR2ET.'
         TMPTXT( 39 ) = ' '
         TMPTXT( 40 ) = '   STOP_TIME            = ''stop tim'
     .   //             'e''  This must be a string'
         TMPTXT( 41 ) = '                          allowed by'
     .   //             ' the SPICELIB routine STR2ET.'
         TMPTXT( 42 ) = ' '
         TMPTXT( 43 ) = '   SELECT_LAST          = ''YES'' or'
     .   //             ' ''NO''  This optional flag controls'
     .   //             ' the'
         TMPTXT( 44 ) = '                          policy for'
     .   //             ' mini-segment selection when a'
         TMPTXT( 45 ) = '                          CK data re'
     .   //             'quest time lies on shared AEM block '
     .   //             'time'
         TMPTXT( 46 ) = '                          boundaries'
     .   //             '. A value of ''YES'' indicates that'
         TMPTXT( 47 ) = '                          data from '
     .   //             'the later block are to be used; a'
         TMPTXT( 48 ) = '                          value of '''
     .   //             'NO'' indicates that the data from th'
     .   //             'e'
         TMPTXT( 49 ) = '                          earlier bl'
     .   //             'ock are to be used. The default valu'
     .   //             'e'
         TMPTXT( 50 ) = '                          is ''YES'''
     .   //             '.'
         TMPTXT( 51 ) = ENDMRK

 

         FIRST = .FALSE.

      END IF

 
      IF ( EQSTR(INFTYP, 'TEMPLATE') ) THEN
C
C        Display the template text.
C
         DO I = 1, TSIZE
            CALL TOSTDO ( TMPTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )


      ELSE IF ( EQSTR(INFTYP, 'USAGE') ) THEN
C
C        Display the usage text.
C
         DO I = 1, USIZE
            CALL TOSTDO ( USGTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )


      ELSE IF ( EQSTR(INFTYP, 'VERSION') ) THEN
C
C        Create and display "version" message.
C
         CALL TKVRSN ( 'TOOLKIT', VERSTR )

         CALL TOSTDO ( ' '                                           )
         CALL TOSTDO ( 'AEM2CK Program; Ver. ' // VER // 
     .                 '; Toolkit Ver. ' // VERSTR(:RTRIM(VERSTR))   )
         CALL TOSTDO ( ' '                                           )


      ELSE IF ( EQSTR(INFTYP, 'HELP') ) THEN

         DO I = 1, HSIZE
            CALL TOSTDO ( HLPTXT(I) )
         END DO

         CALL TOSTDO ( ' ' )

      ELSE
C
C        We shouldn't arrive here.
C
         CALL SETMSG ( 'Informational message type # is not '   //
     .                 'supported.'                             )
         CALL ERRCH  ( '#', INFTYP                              )
         CALL SIGERR ( 'SPICE(NOTSUPPORTED)'                    )
         CALL CHKOUT ( 'PRCINF'                                 )
         RETURN

      END IF

      CALL CHKOUT ( 'PRCINF' )
      RETURN
      END
