C$Procedure FNDTAG ( Find time tag )
 
      SUBROUTINE FNDTAG ( LINE, TAG, ELOC, FOUND )
 
C$ Abstract
C
C     Find a time tag, possibly having embedded blanks, located
C     at the front of an AEM data line.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     AEM2CK
C
C$ Declarations
 
      IMPLICIT NONE

      INCLUDE 'errhnd.inc'

      CHARACTER*(*)         LINE
      CHARACTER*(*)         TAG
      INTEGER               ELOC
      LOGICAL               FOUND
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     LINE       I   Input line to be scanned for time tag.
C     TAG        O   Time tag, if found.
C     ELOC       O   Position of last character of tag.
C     FOUND      O   Flag indicating whether tag was found.
C
C$ Detailed_Input
C                    
C     LINE           is a line of text from an AEM file.  The
C                    line is to be scanned left to right until
C                    a non-blank token is found.  If such a token
C                    is found, it is parsed to determine whether
C                    it is a valid time tag.
C
C$ Detailed_Output
C
C     TAG            is the initial time tag found in the input
C                    line, if any.  The time tag must be recognized
C                    by the SPICELIB routine TPARTV to be considered
C                    valid.
C
C     ELOC           is the character position of the last non-blank
C                    character of the time tag, if one was found.
C                    If the time tag was terminated by a comma, 
C                    ELOC is the position of the comma.  However,
C                    the comma is presumed to be a (spurious)
C                    delimiter and is not included in TAG.
C
C     FOUND          is a logical flag indicating whether the 
C                    first word of LINE was a recognized time tag.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If the input line does not start with a time tag, the
C        FOUND flag is returned .FALSE.  This is not considered
C        to be an error.
C
C$ Files
C
C     The input file is an AEM file; see reference [1].
C
C$ Particulars
C
C     None.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     1) This routine assumes that any time tag used in an AEM file
C        can be parsed by the SPICE routine TPARTV.
C
C$ Literature_References
C
C     [1]  CCSDS Attitude Data Messages Blue Book, version CCSDS 
C          504.0-B-1, May, 2008.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C
C$ Version
C
C-    AEM2CK Version 1.0.0, 19-AUG-2005 (NJB)
C
C-&

C
C     Scan a time tag from an initial subsequence of tokens in
C     a line. 
C     
      LOGICAL               RETURN


      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )

      INTEGER               MAXVEC
      PARAMETER           ( MAXVEC = 6 )

      INTEGER               TYPLEN
      PARAMETER           ( TYPLEN = 10 )

      INTEGER               MAXLIN
      PARAMETER           ( MAXLIN = 255 )

      INTEGER               MAXMOD
      PARAMETER           ( MAXMOD = 20 )


      CHARACTER*(LMSGLN)    ERRMSG
      CHARACTER*(MAXLIN)    LOCLIN
      CHARACTER*(LNSIZE)    MODIFY ( MAXMOD )
      CHARACTER*(LNSIZE)    PICTUR
      CHARACTER*(TYPLEN)    TTYPE

      DOUBLE PRECISION      TVEC   ( MAXVEC )
      
      INTEGER               B
      INTEGER               NTVEC

      LOGICAL               MODS
      LOGICAL               YABBRV
     


      IF ( RETURN() ) THEN
         RETURN
      END IF

      CALL CHKIN ( 'FNDTAG' )

C
C     No tag found yet.
C
      FOUND = .FALSE.

C
C     The time tag is supposed to have no embedded blanks.  So,
C     find the first word of the input line.
C
      CALL FNDNWD ( LINE, 1, B, ELOC )

      IF (  ( B .GE. ELOC ) .OR. ( ELOC .LT. 1 )  ) THEN

         CALL CHKOUT ( 'FNDTAG' )
         RETURN

      END IF

C
C     Replace any commas with blanks.
C
      CALL REPLCH ( LINE(B:ELOC), ',',  ' ', LOCLIN )

C
C     Basic idea:  TPARTV is a non-error-signaling routine that can
C     recognize a time tag. See whether TPARTV understands the time
C     string. TPARTV has the convenient property of not signaling an
C     error if it doesn't recognize the time string.

      CALL TPARTV ( LOCLIN(:ELOC),  
     .              TVEC,    NTVEC,   TTYPE,  MODIFY,
     .              MODS,    YABBRV,  FOUND,  PICTUR,  ERRMSG  )


      IF ( FOUND ) THEN
         TAG  = LOCLIN(:ELOC)
      ELSE
         TAG  = ' '
         ELOC = 0
      END IF

    
      CALL CHKOUT ( 'FNDTAG' )
      RETURN
      END


