C$Procedure      CKOPA ( CK open for addition )
 
      SUBROUTINE CKOPA ( FILE, HANDLE )
 
C$ Abstract
C
C    Open an existing CK file for subsequent write.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     CK
C
C$ Keywords
C
C     CK
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         FILE
      INTEGER               HANDLE
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     FILE       I   The name of an existing CK file.
C     HANDLE     O   A handle attached to the CK file opened for write.
C
C$ Detailed_Input
C
C     FILE       is the name of an existing CK file to which
C                you wish to append additional CK segments.
C
C$ Detailed_Output
C
C     HANDLE     is the DAF handle attached to the file required
C                by any of the CK writing routines. If any exceptions
C                arise that prevent opening of the specified file for
C                writing, HANDLE will be returned with the value 0.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1)  If the file specified does not exist the error
C         'SPICE(FILENOTFOUND)' will be signaled.
C
C     2)  If the file specified is not a CK file, the error
C         'SPICE(FILEISNOTCK)' will be signaled.
C
C     All other exceptions are determined by routines in the
C     call tree of this routine.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     This file provides an interface for opening existing CK
C     files for the addition of CK segments.  If you need
C     to open an new CK file for writing, call the routine CKOPN.
C
C$ Examples
C 
C     1) Append a type 3 CK segment to an existing CK file.
C     
C
C     Begin by opening the file.
C
C     CALL CKOPA ( FILE, HANDLE )
C
C       [ collect segment data... ]
C
C     Now add the collected data as a new segment.
C
C     CALL CKW03 ( HANDLE, BEGTIM, ENDTIM, INST,  REF,  AVFLAG,
C    .             SEGID,  NREC,   SCLKDP, QUATS, AVVS, NINTS,
C    .             STARTS                                       )
C
C     Finally, close the file.
C
C     CALL CKCLS ( HANDLE )
C
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C     W.L. Taber      (JPL)
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 23-JUL-2015 (NJB)(WLT)
C
C-&
 
C$ Index_Entries
C
C     Open an existing CK file for adding segments
C
C-&

C
C     SPICELIB Functions
C
 
      LOGICAL               EXISTS
      LOGICAL               FAILED
      LOGICAL               RETURN
 
 
      INTEGER               SMWDSZ
      PARAMETER           ( SMWDSZ = 8 )
 
      CHARACTER*(SMWDSZ)    ARCH
      CHARACTER*(SMWDSZ)    TYPE
C
C     Standard SPICE error handling.
C
      IF ( RETURN() ) THEN
         RETURN
      END IF
 
      CALL CHKIN ( 'CKOPA')
 
C
C     Until we get a legitimate handle we set HANDLE to zero.
C
      HANDLE = 0
 
C
C     First make sure the file exists.
C
      IF ( .NOT. EXISTS(FILE) ) THEN
 
         CALL SETMSG ( 'The file ''#'' is not recognized as an '
     .   //            'existing file. ' )
         CALL ERRCH  ( '#', FILE )
         CALL SIGERR ( 'SPICE(FILENOTFOUND)'  )
         CALL CHKOUT ( 'CKOPA' )
 
         RETURN
      END IF
 
C
C     Next make sure it is a CK file.
C
      CALL GETFAT ( FILE, ARCH, TYPE )
 
      IF ( FAILED() )THEN
         CALL CHKOUT ( 'CKOPA' )
         RETURN
      END IF
 
      IF (  ( ARCH .NE. 'DAF' ) .OR. ( TYPE .NE. 'CK' )  ) THEN
 
         CALL SETMSG ( 'The file ''#'' was not a CK file. The '
     .   //            'architecture and type of the file were '
     .   //            'found to be ''#'' and ''#'' respectively. ' )
 
         CALL ERRCH  ( '#', FILE )
         CALL ERRCH  ( '#', ARCH )
         CALL ERRCH  ( '#', TYPE )
         CALL SIGERR ( 'SPICE(FILEISNOTCK)'  )
         CALL CHKOUT ( 'CKOPA' )
         RETURN
      END IF
 
C
C     That's the limit of the checks performed here.  We let DAFOPW
C     handle the remaining checks.
C
      CALL DAFOPW ( FILE, HANDLE )
 
      IF ( FAILED() ) THEN
         HANDLE = 0
      END IF
 
      CALL CHKOUT ( 'CKOPA' )
      RETURN
      END
