import logging
import os
import subprocess
from datetime import datetime, timedelta

def quaternions_filter(append_bool, line, row, row_prev, index, tm_list,
                       filter_flag, sclk_fraction_prev, sclk_fraction_pprev,
                       sclk_fraction_ppprev, sclk_fraction_pppprev,sclk_initial,
                       info_quaternions):

    #
    # We add a tolerance in the SCLK fraction for it to be considered spureous.
    #
    sclk_fraction = line.split(':')[-1].split(' ')[0]

    if not sclk_fraction_pppprev:
        sclk_fraction_ppprev = 0
    if not sclk_fraction_ppprev:
        sclk_fraction_ppprev = 0
    if not sclk_fraction_pprev:
        sclk_fraction_pprev = 0
    if not sclk_fraction_prev:
        sclk_fraction_prev = 0
    if not sclk_initial:
        sclk_initial = 0

    prev = False

    tolerance = 5  # Tolerance is manually set no need for it to be a configuration item.
    threshold_prev  = abs(int(sclk_fraction) - int(sclk_fraction_prev))
    threshold_init  = abs(int(sclk_fraction) - int(sclk_initial))

    if filter_flag:

        if threshold_prev < tolerance:
            row_prev.append(row)
        elif len(row_prev) <= 5 and  threshold_init < tolerance:

            #logging.warning(f'   EM16 Quaternions Filter: Coarse quaternion: Spurious SCLK fractions before input line {index}:')
            info_quaternions += 1
            for element in row_prev:
                #logging.warning('   ' + str(element).split('\n')[0])
                tm_list.remove(element)

            filter_flag = False
            row_prev = []

            sclk_fraction_prev = sclk_fraction
            prev = True


        #
        # This is the extra filtering we add to remove single SCLK fraction differences
        #
        elif len(row_prev) == 1 and threshold_init > tolerance:
            #logging.warning(f'   EM16 Quaternions Filter: Coarse quaternion: Spurious SCLK fractions before input line {index}:')
            info_quaternions += 1
            #logging.warning('   ' + str(row_prev[0]).split('\n')[0])

            append_bool = False

            filter_flag = False
            row_prev = []

            sclk_fraction_prev = sclk_fraction
            prev = True

        else:
            row_prev = []
            filter_flag = False

    if sclk_fraction_prev and threshold_prev > tolerance and not filter_flag:
        filter_flag = True
        row_prev.append(row)

        sclk_initial = sclk_fraction_prev

    sclk_fraction_pppprev = sclk_fraction_ppprev
    sclk_fraction_ppprev = sclk_fraction_pprev
    sclk_fraction_pprev = sclk_fraction_prev
    if not prev:
        sclk_fraction_prev = sclk_fraction


    threshold_ppprev = abs(int(sclk_fraction) - int(sclk_fraction_pppprev))
    if threshold_ppprev < tolerance:
        append_bool = True


    return append_bool, line, row, row_prev, index, tm_list, filter_flag, sclk_fraction_prev, \
           sclk_fraction_pprev, sclk_fraction_ppprev, sclk_fraction_ppprev, sclk_initial, info_quaternions



def oem_to_cog(source):

    #
    # We need to negate the incoming data and convert it to KM (it is in M)
    #
    cog_list = []
    with open(source, 'r') as t:
        data_record = False
        for line in t:
            if 'META_START' in line:
                data_record = False
            if data_record:
                line_list = line.split()
                if line_list:
                    utc_time = line_list[0].split('.')[0]
                    try:
                        utc_milisec = line_list[0].split('.')[-1][0:3]
                    except:
                        utc_milisec = line_list[0].split('.')[-1]
                    utc = utc_time + '.' + f'{utc_milisec}'
                    cog_list.append(f'{utc} '
                                    f'{-0.001*float(line_list[1].replace("D","E"))} '
                                    f'{-0.001*float(line_list[2].replace("D","E"))} '
                                    f'{-0.001*float(line_list[3].replace("D","E"))} '
                                    f'0.0 0.0 0.0\n')
            if 'META_STOP' in line:
                data_record = True

    previous_time = ''
    cog_list_processed = []


    for cog in cog_list:
        if previous_time:
            current_time = cog.split()[0]
            if cog.split()[0] not in previous_time:

                #
                # We need to generate a 'zero degree interpolation' as if in a step
                # function.
                previous_dt = datetime.strptime(previous_time,"%Y-%m-%dT%H:%M:%S.%f")
                current_dt = datetime.strptime(current_time,"%Y-%m-%dT%H:%M:%S.%f")

                delta_dt = current_dt - previous_dt
                if delta_dt.seconds >= 1:
                    step_dt = current_dt - timedelta(seconds=+1)
                    step_time = step_dt.strftime("%Y-%m-%dT%H:%M:%S.%f")
                    cog_list_processed.append(f'{step_time[:-3]} '
                                              f'{previous_cog.split()[1]} '
                                              f'{previous_cog.split()[2]} '
                                              f'{previous_cog.split()[3]} '
                                              f'0.0 0.0 0.0')
                cog_list_processed.append(cog)
        previous_time = cog.split()[0]
        previous_cog = cog

    #
    # We remove duplicates, preventing duplication of variables in the loop.
    #
    previous_tim = ''
    cog_list_processed_copy = cog_list_processed.copy()
    for cog in cog_list_processed_copy:
        time = cog.split()[0]
        if previous_tim:
            if time == previous_tim:
                cog_list_processed.remove(cog)
        previous_tim = time

    return cog_list_processed



def correct_aem_timestamp(kernel):
    #
    # correct segment starts from events times
    #
    events_et = [511176921.1855533, 511522521.1855895, 512300121.1856428, 514546521.1855752, 515410521.18546474, 522149721.18360835, 528024921.1823683, 533760968.1830692, 556569429.1828111, 578309721.1854967, 586353669.1832768, 595632800.1827579, 611458869.1852041, 670105454.1856433, 779708121.1824327, 1456997721.185419]

    m_list = [-4.089506172839506e-11, 2.3283130787037037e-10, -9.313226851851852e-10, -9.313220164609054e-10, 3.7252904040404044e-09, 3.7252902155887225e-09, -1.49011612654321e-08, -1.4901161192085621e-08, -1.4901161203703705e-08, 5.960464468837116e-08, 7.052358250349405e-08, 5.9604644764957264e-08, 5.9588100073512616e-08, 0.0, 0.0]
    b_list = [0.02090461175388426, -0.11908979765758924, 0.47721956066245524, 0.47915985085270335, -1.9207241984309253, -1.9450187151218412, 7.888893409620684, 7.95366387580066, 8.293535698594551, -34.79211275456662, -41.19531988483442, -34.79211279870326, -36.43569145295643, 0.0, 0.0]


    file = open(kernel.source, 'r')
    data = []
    block = []
    metaflag = False
    offset_list, times = [], []
    firstflag = True
    for line in file.readlines():
        if 'META_START' in line:
            metaflag = True
            block = []
        if metaflag and line[:2] == '20':
            utc = line.split(' ')[0]
            if firstflag:
                cmd = [kernel.directories.executables + os.sep + 'utc2tdb ' + utc
                       + ' ' + kernel.directories.kernels + os.sep + kernel.config['lsk']]
                command_line_process = subprocess.Popen(cmd, shell=True,
                                                        stdout=subprocess.PIPE,
                                                        stderr=subprocess.STDOUT)
                command_line_process.wait()
                process_output = command_line_process.communicate()[0]
                etaem_0 = float(str(process_output.decode('utf-8')).split('\n')[0].strip())
                date_0 = datetime.strptime(utc[:-2], "%Y-%m-%dT%H:%M:%S.%f")
                firstflag = False
            date_i = datetime.strptime(utc[:-2], "%Y-%m-%dT%H:%M:%S.%f")
            etaem = etaem_0 + (date_i - date_0).total_seconds()
            for k in range(0, len(events_et), 1):
                if etaem >= events_et[k] and etaem < events_et[k + 1]:
                    offset = etaem * m_list[k] + b_list[k]
                    offset_list.append(offset)
                    times.append(etaem)
                    tdb = (date_i + timedelta(seconds=offset)).strftime("%Y-%m-%dT%H:%M:%S.%f")
                    line = tdb + ' ' + line.split(' ', 1)[1]
            block.append(line)
        elif metaflag and line[:2] != '20':
            block.append(line)
        if 'DATA_STOP' in line:
            metaflag = False
            block[7] = block[7].split('=')[0] + '= ' + block[16].split(' ')[0] + '\n'
            block[8] = block[8].split('=')[0] + '= ' + block[-2].split(' ')[0] + '\n'
            block.append('\n')
            data.extend(block)

    file.close()

    file = open(kernel.source, 'w+')
    file.write('CCSDS_AEM_VERS = 1.0\n')
    file.write('CREATION_DATE = 2021-06-15T10:56:02\n')
    file.write('ORIGINATOR = ESOC\n')
    file.write('\n')
    for line in data:
        file.write(line)
    file.close()

    return
