adcsng
======

ADCSng covers the conversion of auxiliary data files to SPICE Kernels. 
Auxiliary data comes in shape of orbital, attitude and spacecraft (S/C) and 
Payload elements position and orientation data from the given mission Science 
Ground Segment (SGS) uplink and downlink systems as provided by FDy in the shape of 
Orbit Ephemeris Messages (OEM), Attitute Ephemeris Messages (AEM) -or another 
Orbit and Attitude information container files- and Raw Housekeeping Telemetry 
data processed following the NASA Planetary Data System Standard (PDS4).

Each data product generated by ADCSng contains, in the comment area, the 
product documentation which follows a predefined template. The data conversion 
process is documented in a log file.

SPICE is an essential tool for scientists and engineers alike in the 
planetary science field for Solar System Geometry. Please visit the NAIF 
website for more details about SPICE.
 

Function and Purpose
--------------------

Auxiliary data are those that help scientists and engineers to determine the 
location and orientation of the spacecraft, when and how an instrument was 
acquiring scientific data. These data also help to determine what other 
relevant events were occurring on the spacecraft or ground that might affect 
the interpretation of the scientific observation or the S/C systems performance. 
Software applications are required to know what were the location, size, shape 
and orientation of the observed target in addition to these auxiliary data. 
Almost all NASA and ESA planetary missions have embraced the use of the SPICE 
system for ancillary data archiving and for science data analysis. Although the 
Flight Dynamics Division provides software to read the position and orientation 
files of the orbiters, most of the Principal Investigators (PI) have pointed out 
their interest in having all the auxiliary data distributed in SPICE format.

The ESA SPICE Service (ESS) of the Cross Mission Support Office is responsible 
for supporting the ESOC auxiliary data transformation into SPICE kernels and 
the distribution of these files to the instrument teams using the public network. 
NASA’s Planetary Data System discipline node NAIF (Navigational Ancillary 
Information Facility) is responsible for designing a transformation software 
tool to generate spacecraft orbit and attitude SPICE kernels. The ESS, helped 
by the individual instrument and FDy teams, the SGSs, and, in some missions, 
supported by NAIF, design and support all the necessary instrument, spacecraft 
and timing kernels.

adcsng is developed and maintained by the [ESA SPICE Service (ESS)](https://spice.esac.esa.int).


Environmental Considerations
----------------------------

ADCSng is a Python 3.5.x package that uses FORTRAN-77 applications and a set of 
standard Python libraries. ADCSng interacts with principal nodes: SGS Uplink and 
Downlink sub-systems, the ESA SPICE FTP Server and the NAIF FTP Server.

The SGS Uplink system is responsible for receiving periodically via ESOC the 
OEM and AEM files and to provide them to ADCSng whereas the SGS Downlink system 
is responsible for processing the Housekeeping Telemetry Data and to provide 
them to ADCSng. The output provided by ADCSng is distributed to the users at 
least via the ESA SPICE FTP server and is mirrored on the NAIF FTP Server. 
Newly available kernels are notified via e-mail by ADCSng to the interested clients.


Environmental Considerations
----------------------------

ADCSng can either be provided as a Service by ESS or it can be provided as a 
piece of sofware to be integrated in the given project SGS system. Configuration 
management and distribution of the software is discussed in the appropiate 
section of this document. Depending on the taken approach the relationships 
with other systems might change. What is described here assuma service providing 

approach for ADCSng.
ADCSng takes inputs from a given mission-dependent system that places the data 
to be processed in the input directory. For some missions this system is 
controlled by the ADCSng developer, and in others it is responsability of 
the given mission SGS. Upon successful conversion of the data, aDCSng places 
the generated kenrels into the corresponding directory of the given mission 
operational FTP as defined by the ADCSng configuration.


Constraints
-----------

ADCSng is asynchronous with respect to any other software and therefore any 
required time synchronization shall be enfored externally to the software. 
This is particularly crucial if there are time constraints for the generation 
of kernels and shall be considered when deploying the software on the given 
operational environment.

In addition, ADCSng requires of the latest version of the given mission 
SPICE Kernels Dataset to be placed in the directory specified by the configuration.


Intended Users
--------------
ADCSng requires a Unix environment to be run and can either be provided as a 
service by ESS (Mars-Express, ExoMars 2016, BepiColombo and JUICE) or distributed 
to a given mission to be executed within their operational environment (Solar 
Orbiter and ExoMars RSP).

ADCSng does not have a graphical interface and runs on a Unix environment as a 
background process, based on the Solaris Crontab utility, although it can be 
executed from the comand line if required. ESS is responsible for software 
development, test, maintenance and distribution. ESS is also responsible of 
ensuring that input file from ESOC has been successfuly converted and distributed. 


Installation
------------

Then run ``pip install adcsng`` to install from pypi.

If you wish to install adscsng from source first download or clone the project. Then run ``python setup.py install``.
To uninstall run ``pip uninstall adcsng``.

Documentation
-------------

The adcs docs are available [here](ftp://spiftp.esac.esa.int/adcsng/html/index.html).


How to Help
-----------

Feedback and new functionalities are always welcome, if you discover that a 
function is not 
working as expected or if you have a function that you believe can be of 
interest to other people please open an issue or contact [me](marc.costa@esa.int).


Known Working Environments:
---------------------------

adcsng is compatible with modern 64 bits versions of Linux and Mac. 
If you run into issues with your system please submit an issue with details. 

- OS: OS X, Linux
- CPU: 64bit
- Python 3.5