KPL/MK

   This meta-kernel lists the CASSINI SPICE kernels providing coverage
   for 2004. All of the kernels listed below are archived in the CAS
   SPICE data set (DATA_SET_ID = "CO-S/J/E/V-SPICE-6-V1.0"). This set
   of files and the order in which they are listed were picked to
   provide the best available data and the most complete coverage for
   the specified year based on the information about the kernels
   available at the time this meta-kernel was made. For detailed
   information about the kernels listed below refer to the internal
   comments included in the kernels and the documentation accompanying
   the CASSINI SPICE data set.

   WARNING: the list of kernels in this meta-kernel does not include
   any PCK files, preventing this data collection from being usable for
   computing derived parameters that require knowledge of the natural
   body orientations, rotations and shapes. The reason for this
   omission is that the multitude of PCK files produced by the CASSINI
   project and archived in the CASSINI SPICE data set did not allow
   NAIF to make a reasonable pick for this kernel type. It is the
   user's responsibility to identify the PCK(s) most suitable for
   his/her application and to load this(these) PCK(s) in addition to
   this meta-kernel.

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the CAS SPICE data set's ``data'' directory on their
   system. Replacing ``/'' with ``\'' and converting line terminators
   to the format native to the user's system may also be required if
   this meta-kernel is to be used on a non-UNIX workstation.

   This file was created on March 12, 2007 by Boris Semenov,
   NAIF/JPL. The original name of this file was cas_2004_v01.tm.

   \begindata

      PATH_VALUES     = ( './data' )

      PATH_SYMBOLS    = ( 'KERNELS' )

      KERNELS_TO_LOAD = (

                          '$KERNELS/lsk/naif0008.tls'

                          '$KERNELS/fk/cas_rocks_v09.tf'

                          '$KERNELS/fk/cas_v39.tf'

                          '$KERNELS/ik/cas_caps_v03.ti'
                          '$KERNELS/ik/cas_cda_v01.ti'
                          '$KERNELS/ik/cas_cirs_v09.ti'
                          '$KERNELS/ik/cas_inms_v02.ti'
                          '$KERNELS/ik/cas_iss_v10.ti'
                          '$KERNELS/ik/cas_mag_v01.ti'
                          '$KERNELS/ik/cas_mimi_v11.ti'
                          '$KERNELS/ik/cas_radar_v11.ti'
                          '$KERNELS/ik/cas_rpws_v01.ti'
                          '$KERNELS/ik/cas_rss_v03.ti'
                          '$KERNELS/ik/cas_sru_v02.ti'
                          '$KERNELS/ik/cas_uvis_v05.ti'
                          '$KERNELS/ik/cas_vims_v06.ti'

                          '$KERNELS/sclk/cas00105.tsc'

                          '$KERNELS/spk/051212AP_RE_90165_14363.bsp'
                          '$KERNELS/spk/060222AP_IRRE_00256_14363.bsp'

                          '$KERNELS/spk/041014R_SCPSE_01066_04199.bsp'
                          '$KERNELS/spk/041219R_SCPSE_04199_04247.bsp'
                          '$KERNELS/spk/050105R_SCPSE_04247_04336.bsp'
                          '$KERNELS/spk/050214R_SCPSE_04336_05015.bsp'

                          '$KERNELS/ck/03292_04009pd.bc'
                          '$KERNELS/ck/04009_04051px.bc'
                          '$KERNELS/ck/04051_04092ph_psiv2.bc'
                          '$KERNELS/ck/04092_04135ph_fsiv.bc'
                          '$KERNELS/ck/04135_04171pd_fsiv.bc'
                          '$KERNELS/ck/04171_04212pi_fsiv.bc'
                          '$KERNELS/ck/04212_04256pd_psiv2.bc'
                          '$KERNELS/ck/04256_04292pe_S04.bc'
                          '$KERNELS/ck/04292_04320pf_fsiv.bc'
                          '$KERNELS/ck/04320_04351pe_fsiv.bc'
                          '$KERNELS/ck/04351_05022ph_fsiv.bc'

                          '$KERNELS/ck/03236_04002ra.bc'
                          '$KERNELS/ck/04002_04009ra.bc'
                          '$KERNELS/ck/04009_04019ra.bc'
                          '$KERNELS/ck/04019_04026ra.bc'
                          '$KERNELS/ck/04026_04033ra.bc'
                          '$KERNELS/ck/04033_04040ra.bc'
                          '$KERNELS/ck/04040_04047ra.bc'
                          '$KERNELS/ck/04047_04052ra.bc'
                          '$KERNELS/ck/04052_04059ra.bc'
                          '$KERNELS/ck/04059_04066rb.bc'
                          '$KERNELS/ck/04066_04073ra.bc'
                          '$KERNELS/ck/04073_04080rb.bc'
                          '$KERNELS/ck/04080_04087ra.bc'
                          '$KERNELS/ck/04087_04094ra.bc'
                          '$KERNELS/ck/04094_04101ra.bc'
                          '$KERNELS/ck/04101_04108ra.bc'
                          '$KERNELS/ck/04108_04115ra.bc'
                          '$KERNELS/ck/04115_04122ra.bc'
                          '$KERNELS/ck/04122_04129ra.bc'
                          '$KERNELS/ck/04129_04136ra.bc'
                          '$KERNELS/ck/04136_04142ra.bc'
                          '$KERNELS/ck/04143_04149ra.bc'
                          '$KERNELS/ck/04150_04157ra.bc'
                          '$KERNELS/ck/04157_04161ra.bc'
                          '$KERNELS/ck/04161_04164ra.bc'
                          '$KERNELS/ck/04164_04168ra.bc'
                          '$KERNELS/ck/04168_04171ra.bc'
                          '$KERNELS/ck/04171_04179ra.bc'
                          '$KERNELS/ck/04179_04183ra.bc'
                          '$KERNELS/ck/04183_04185ra.bc'
                          '$KERNELS/ck/04185_04191ra.bc'
                          '$KERNELS/ck/04191_04196ra.bc'
                          '$KERNELS/ck/04196_04201ra.bc'
                          '$KERNELS/ck/04201_04206ra.bc'
                          '$KERNELS/ck/04206_04207ra.bc'
                          '$KERNELS/ck/04207_04208ra.bc'
                          '$KERNELS/ck/04208_04213ra.bc'
                          '$KERNELS/ck/04211_04216ra.bc'
                          '$KERNELS/ck/04215_04220ra.bc'
                          '$KERNELS/ck/04220_04225ra.bc'
                          '$KERNELS/ck/04225_04230ra.bc'
                          '$KERNELS/ck/04231_04236ra.bc'
                          '$KERNELS/ck/04236_04241ra.bc'
                          '$KERNELS/ck/04241_04246ra.bc'
                          '$KERNELS/ck/04246_04251ra.bc'
                          '$KERNELS/ck/04251_04256ra.bc'
                          '$KERNELS/ck/04256_04261ra.bc'
                          '$KERNELS/ck/04261_04266ra.bc'
                          '$KERNELS/ck/04266_04271ra.bc'
                          '$KERNELS/ck/04271_04276ra.bc'
                          '$KERNELS/ck/04276_04281ra.bc'
                          '$KERNELS/ck/04281_04286ra.bc'
                          '$KERNELS/ck/04286_04291ra.bc'
                          '$KERNELS/ck/04291_04296ra.bc'
                          '$KERNELS/ck/04296_04301ra.bc'
                          '$KERNELS/ck/04301_04306ra.bc'
                          '$KERNELS/ck/04306_04311ra.bc'
                          '$KERNELS/ck/04311_04316ra.bc'
                          '$KERNELS/ck/04316_04321ra.bc'
                          '$KERNELS/ck/04321_04326ra.bc'
                          '$KERNELS/ck/04326_04331ra.bc'
                          '$KERNELS/ck/04331_04336ra.bc'
                          '$KERNELS/ck/04336_04341ra.bc'
                          '$KERNELS/ck/04341_04346ra.bc'
                          '$KERNELS/ck/04346_04348ra.bc'
                          '$KERNELS/ck/04348_04350ra.bc'
                          '$KERNELS/ck/04351_04356ra.bc'
                          '$KERNELS/ck/04356_04361ra.bc'
                          '$KERNELS/ck/04361_05002ra.bc'

                          '$KERNELS/ck/cas_cda_20070309.bc'

                        )

   \begintext
