"""
Created on Dec 2, 2020
@author: Ricardo Valles
"""
import os
import unittest
import HtmlTestRunner
from .test_exomars2016 import TestEM16
# from .test_rosetta import TestROSETTA
from .test_vex import TestVEX

try:
    f = open(os.path.dirname(__file__) + '/../config/version', 'r')
except:
    f = open('../config/version', 'r')
with f:
    for line in f:
        version = line

html_report_dir = '../reports'


class TestRegression(unittest.TestCase):

    # This method will be executed only once for this test case class.
    # It will execute before all test methods. Must decorated with
    # @classmethod.
    @classmethod
    def setUpClass(cls):

        #####################################
        #####   E X O M A R S 2 0 1 6   #####
        #####################################
        TestEM16()

        #####################################
        #####          ROSETTA          #####
        #####################################
        #TestROSETTA()

        #####################################
        #####            VEX            #####
        #####################################
        TestVEX()

if __name__ == '__main__':

    unittest.main(testRunner=HtmlTestRunner.HTMLTestRunner(output=html_report_dir,
                                                           report_title=f'ARCGEN v{version} Regression Tests',
                                                           report_name=f'arcgen_v{version}'))
