KPL/MK

Meta-kernel for INTERNATIONAL ROSETTA MISSION Archived Kernels
==========================================================================

   This meta-kernel lists the INTERNATIONAL ROSETTA MISSION Archived SPICE kernels
   providing information for the full mission. All of the kernels listed
   below are archived in the PSA INTERNATIONAL ROSETTA MISSION SPICE kernel archive.

   This set of files and the order in which they are listed were picked to
   provide the best available data and the most complete coverage for the
   specified year based on the information about the kernels available at
   the time this meta-kernel was made. For detailed information about the
   kernels listed below refer to the internal comments included in the
   kernels and the documentation accompanying the INTERNATIONAL ROSETTA MISSION
   SPICE kernel archive.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".
   The SPICELIB routine FURNSH loads a kernel into the pool.


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the INTERNATIONAL ROSETTA MISSION SPICE data set's ``data'' directory
   on their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on 2020-12-09 by Ricardo Valles Blanco ESA/ESAC.
   The original name of this file was ROS_V01.TM.


   \begindata

     PATH_VALUES       = ( './DATA' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

'$KERNELS/CK/LATT_CFF2LDR_FSS_V2_0.BC'
'$KERNELS/CK/LATT_EME2LDR_SDL_V1_0.BC'
'$KERNELS/CK/LATT_ROS2LDR_PRESEP_V1_0.BC'
'$KERNELS/CK/ROS_HGA_2005_V0001.BC'
'$KERNELS/CK/ROS_HGA_2006_V0001.BC'
'$KERNELS/CK/ROS_HGA_2011_V0018.BC'
'$KERNELS/CK/ROS_LBOOM_V0.BC'
'$KERNELS/CK/ROS_ORBITER_EXTENSION_V2.BC'
'$KERNELS/CK/ROS_SC_DLR_S4S_1408_1409_V1.BC'
'$KERNELS/CK/ROS_VIRTIS_ZERO_V1.BC'

'$KERNELS/FK/EARTH_TOPO_050714.TF'
'$KERNELS/FK/EARTHFIXEDIAU.TF'
'$KERNELS/FK/EARTHFIXEDITRF93.TF'
'$KERNELS/FK/ESTRACK_V01.TF'
'$KERNELS/FK/NEW_NORCIA_TOPO.TF'
'$KERNELS/FK/ROS_DSK_SURFACES_V02.TF'
'$KERNELS/FK/ROS_LUTETIA_RSOC_V03.TF'
'$KERNELS/FK/ROS_V34.TF'
'$KERNELS/FK/RSSD0001.TF'
'$KERNELS/FK/RSSD0002.TF'

'$KERNELS/IK/ROS_ALICE_V17.TI'
'$KERNELS/IK/ROS_CIVA_V10.TI'
'$KERNELS/IK/ROS_CONSERT_V11.TI'
'$KERNELS/IK/ROS_COSIMA_V15.TI'
'$KERNELS/IK/ROS_DIM_V11.TI'
'$KERNELS/IK/ROS_GIADA_V12.TI'
'$KERNELS/IK/ROS_MIDAS_V11.TI'
'$KERNELS/IK/ROS_MIRO_V11.TI'
'$KERNELS/IK/ROS_NAVCAM_V03.TI'
'$KERNELS/IK/ROS_OSIRIS_V15.TI'
'$KERNELS/IK/ROS_ROSINA_V12.TI'
'$KERNELS/IK/ROS_RPC_V19.TI'
'$KERNELS/IK/ROS_SREM_V01.TI'
'$KERNELS/IK/ROS_STR_V12.TI'
'$KERNELS/IK/ROS_VIRTIS_V14.TI'

'$KERNELS/LSK/NAIF0008.TLS'
'$KERNELS/LSK/NAIF0009.TLS'
'$KERNELS/LSK/NAIF0011.TLS'

'$KERNELS/PCK/DE403_MASSES.TPC'
'$KERNELS/PCK/PCK00008.TPC'
'$KERNELS/PCK/PCK00010.TPC'
'$KERNELS/PCK/ROS_CG_RAD_V10.TPC'
'$KERNELS/PCK/ROS_CG_ROT_1408_1409_V10.TPC'
'$KERNELS/PCK/ROS_CGS_RSOC_V01.TPC'
'$KERNELS/PCK/ROS_LUTETIA_LC1_V02.TPC'
'$KERNELS/PCK/ROS_LUTETIA_LC2_V02.TPC'
'$KERNELS/PCK/ROS_LUTETIA_R1_V02.TPC'
'$KERNELS/PCK/ROS_LUTETIA_R2_V02.TPC'
'$KERNELS/PCK/ROS_LUTETIA_RSOC_V03.TPC'
'$KERNELS/PCK/ROS_STEINS_V05.TPC'

'$KERNELS/SCLK/LANDER_170904_STEP.TSC'
'$KERNELS/SCLK/ROS_061208_STEP.TSC'
'$KERNELS/SCLK/ROS_091210_STEP.TSC'
'$KERNELS/SCLK/ROS_100617_STEP.TSC'
'$KERNELS/SCLK/ROS_110405_STEP.TSC'
'$KERNELS/SCLK/ROS_150908_STEP.TSC'
'$KERNELS/SCLK/ROS_160929_STEP.TSC'

'$KERNELS/SPK/21_LUTETIA_2004_2016.BSP'
'$KERNELS/SPK/67P_CHURY_GERAS_2004_2016.BSP'
'$KERNELS/SPK/2867_STEINS_2004_2016.BSP'
'$KERNELS/SPK/C2002_T7_LINEAR_HOR_V01.BSP'
'$KERNELS/SPK/C2010_A2_LINEAR_HOR_V01.BSP'
'$KERNELS/SPK/CORB_DV_145_01___T19_00216.BSP'
'$KERNELS/SPK/CORB_DV_145_01_______00216.BSP'
'$KERNELS/SPK/CORB_DV_223_01___T19_00302.BSP'
'$KERNELS/SPK/CORB_DV_223_01_______00302.BSP'
'$KERNELS/SPK/CORB_DV_257_02___T19_00344.BSP'
'$KERNELS/SPK/CORB_DV_257_02_______00344.BSP'
'$KERNELS/SPK/CORB_DV_257_03___T19_00345.BSP'
'$KERNELS/SPK/EARTHSTNS_FX_050714.BSP'
'$KERNELS/SPK/EARTHSTNS_ITRF93_050714.BSP'
'$KERNELS/SPK/ESTRACK_V01.BSP'
'$KERNELS/SPK/LORB_C_G_FIXED_RBD_7_V2_0.BSP'
'$KERNELS/SPK/LORB_ROS_SC_PRESEP_V1_0.BSP'
'$KERNELS/SPK/LORB_SUN_J2000_RBD_1_V1_2.BSP'
'$KERNELS/SPK/LORB_SUN_J2000_RBD_2_V1_2.BSP'
'$KERNELS/SPK/LORB_SUN_J2000_RBD_3_V1_2.BSP'
'$KERNELS/SPK/LORB_SUN_J2000_RBD_4_V1_2.BSP'
'$KERNELS/SPK/LORB_SUN_J2000_RBD_5_V1_2.BSP'
'$KERNELS/SPK/LORB_SUN_J2000_RBD_6_V1_2.BSP'
'$KERNELS/SPK/NEW_NORCIA.BSP'
'$KERNELS/SPK/ORER_______________00031.BSP'
'$KERNELS/SPK/ORHO_______________00077.BSP'
'$KERNELS/SPK/ORHS_______________00109.BSP'
'$KERNELS/SPK/ORHW_______________00016.BSP'
'$KERNELS/SPK/ORHW_______________00122.BSP'
'$KERNELS/SPK/ROS_DLR_S4S_1408_1409_V1.BSP'
'$KERNELS/SPK/SPICE_PHILAE_CFF_CN_V1_1.BSP'
'$KERNELS/SPK/SPICE_PHILAE_CFF_SONC_V1_1.BSP'
'$KERNELS/SPK/SPICE_PHILAE_CFF_SONC_V2_0.BSP'
'$KERNELS/SPK/SPICE_PHILAE_CFF_SR_V1_1.BSP'
'$KERNELS/SPK/VESTA_HOR_V01.BSP'

'$KERNELS/DSK/DEIMOS_K005_THO_V01.BDS'
'$KERNELS/DSK/ROS_CG_K006_OSPCLPS_N_V2.BDS'
'$KERNELS/DSK/ROS_CG_K006_OSPCLPS_U_V2.BDS'
'$KERNELS/DSK/ROS_LU_K003_OSPCLAM_N_V1.BDS'
'$KERNELS/DSK/ROS_LU_K003_OSPCLAM_U_V1.BDS'
'$KERNELS/DSK/ROS_LU_K006_OSPCLAM_N_V1.BDS'
'$KERNELS/DSK/ROS_LU_K006_OSPCLAM_U_V1.BDS'

                         )

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           marc.costa@esa.int, esa_spice@sciops.esa.int

   or NAIF at JPL:

           Boris Semenov
           +1 (818) 354-8136
           Boris.Semenov@jpl.nasa.gov


End of MK file.
