class Collection(object):

    def __init__(self, type, mission):

        self.files = []
        self.name = type
        self.mission = mission

        self.lid = self.collection_lid()
        self.vid = self.collection_vid()

        return


    def add(self, element):
        
        self.files.append(element)

    def collection_lid(self):

        collection_lid = \
            'urn:esa:psa:{}_spice:{}'.format(
                    self.mission.accronym,
                    self.type)

        return collection_lid

    def collection_vid(self):

        return '{}.0'.format(int(self.mission.version))


class SpiceKernelsCollection(Collection):

    def __init__(self, mission):

        self.type = 'spice_kernels'
        self.start_time = mission.start
        self.stop_time = mission.stop

        Collection.__init__(self, self.type, mission)

        return
    
    def add(self, kernel):

        #if kernel.type.lower() == 'mk':
        #    self.start_time = kernel.start_time
        #    self.stop_time = kernel.stop_time

        Collection.add(self, kernel)



class DocumentCollection(Collection):

    def __init__(self, mission):

        if int( str( mission.pds ) ) == 3:
            self.type = 'DOCUMENT'
        elif int( str( mission.pds ) ) == 4:
            self.type = 'document'

        Collection.__init__(self, self.type, mission)

        return