
C$Procedure KWPL ( Is a key word parameter on the command line )

      FUNCTION KWPL( CID )


C$ Abstract
C
C     A routine to determine if a particular keyword parameter is
C     part of a command line arguments list.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     KEY WORD PARAMETER
C
C$ Declarations

      LOGICAL               KWPL
      CHARACTER*(*)         CID

C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     KWPL       O   Logical value returned by routine.
C     CID        I   Character key word parameter identifier
C
C$ Detailed_Input
C
C     CID        The character string which defines a key word
C                parameter.  This string must contain only letters.
C
C$ Detailed_Output
C
C     KWPL       The logical value which indicates whether the key word
C                parameter was present of the command line.
C
C$ Parameters
C
C      None.
C
C$ Exceptions
C
C      Error free.
C
C$ Files
C
C      None.
C
C$ Particulars
C
C      This routine flags either as true or false, the existence of
C      a given keyword parameter on the command line.
C
C      Key word parameters are not case sensitive.
C
C$ Examples
C
C      Is the key word parameter '-t' on the command line?
C
C      ONLINE = KWPL( 't' )
C
C      If the command line is
C
C      prog_name -t 1234 5678 -u 556.788 757.655 or
C      prog_name -t -u 556.788 757.655           or
C      prog_name -t
C
C      KWPL will return as .TRUE.
C
C$ Restrictions
C
C      1).  The routine GETCML must be available for linking.
C
C      2).  A key word parameter may not have a number as the first
C           character.
C
C$ Literature_References
C
C      None.
C
C$ Author_and_Institution
C
C      Ed Wright (JPL)
C
C$ Version
C
C-    SPICELIB Version 1.0.0,  JUL-10-1996 (EDW)
C
C-&

C$ Index_Entries
C
C   None.
C
C-&

C
C     SPICELIB functions.
C
      LOGICAL               EQSTR
      INTEGER               LASTNB


C
C     Locals.
C
      CHARACTER*(255)       LINE

      INTEGER               NITEMS
      INTEGER               NOBLNK
      INTEGER               I

C
C     Maximum number of space delimited items on the command line.
C
      INTEGER               NUMITM
      PARAMETER           ( NUMITM = 30 )

      CHARACTER*(32)        ITEMS  ( NUMITM )
      CHARACTER*(12)        CHTEMP



C
C     Set the function value to the default value.
C
      KWPL = .FALSE.


C
C     Get the command line arguments.
C
      CALL GETCML ( LINE )


C
C     Make the identifier with the delimiter character.
C
      NOBLNK = LASTNB( CID )
      CHTEMP = '-'//CID( 1 : NOBLNK )


C
C     Parse for the character identifier.
C
      CALL LPARSE ( LINE, ' ', NUMITM, NITEMS, ITEMS )


C
C     Loop over non zero number of items on the command line.
C
      IF ( NITEMS. NE. 0 ) THEN

         DO I = 1, NITEMS

            IF ( EQSTR( ITEMS( I ), CHTEMP ) ) THEN

C
C             The indicate parameter was found on the command line.
C
              KWPL = .TRUE.

            END IF


         END DO


      END IF

C
C     Return, either the true or the false result.
C

      RETURN
      END
