C$Procedure FNDTAG ( Find time tag )
 
      SUBROUTINE FNDTAG ( LINE, TAG, ELOC, FOUND )
 
C$ Abstract
C
C     Find a time tag, possibly having embedded blanks, located
C     at the front of an EPM data line.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     EPM2SPK
C
C$ Declarations
 
      IMPLICIT NONE

      INCLUDE 'errhnd.inc'

      CHARACTER*(*)         LINE
      CHARACTER*(*)         TAG
      INTEGER               ELOC
      LOGICAL               FOUND
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     LINE       I   Input line to be scanned for time tag.
C     TAG        O   Time tag, if found.
C     ELOC       O   Position of last character of tag.
C     FOUND      O   Flag indicating whether tag was found.
C
C$ Detailed_Input
C                     
C     LINE           is a line read from a text format ESOC
C                    OASW orbit or attitude file.
C
C$ Detailed_Output
C
C     TAG            is a time tag, if FOUND is .TRUE.
C
C     ELOC           is the index in the input LINE of 
C                    the last character of the time tag.
C
C     FOUND          is a logical flag indicating whether a
C                    time tag was found.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     None.
C
C$ Files
C
C     1) The input line normally will have originated in a text 
C        format ESOC OASW orbit or attitude file.
C
C$ Particulars
C
C     None.
C
C$ Examples
C
C     See use in PRSDR.
C
C$ Restrictions
C
C     1) This routine assumes that any time tag used in an EPM file
C        can be parsed by the SPICE routine TPARTV.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C
C$ Version
C
C-    MEX2SPK Version 1.1.0, 26-JUN-2012 (NJB)
C
C        Removed duplicate argument problem in 
C        FNDNWD call. Updated header format.
C
C-    MEX2SPK Version 1.0.0, 06-MAY-2002 (NJB)
C
C-&

C
C     Scan a time tag from an initial subsequence of tokens in
C     a line. 
C     
      LOGICAL               RETURN


      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )

      INTEGER               MAXVEC
      PARAMETER           ( MAXVEC = 6 )

      INTEGER               TYPLEN
      PARAMETER           ( TYPLEN = 10 )

      INTEGER               MAXMOD
      PARAMETER           ( MAXMOD = 20 )

      INTEGER               MAXLIN
      PARAMETER           ( MAXLIN = 255 )


      CHARACTER*(LMSGLN)    ERRMSG
      CHARACTER*(LNSIZE)    MODIFY ( MAXMOD )
      CHARACTER*(LNSIZE)    PICTUR
      CHARACTER*(TYPLEN)    TTYPE
      CHARACTER*(MAXLIN)    LOCLIN

      DOUBLE PRECISION      TVEC   ( MAXVEC )
      
      INTEGER               B
      INTEGER               E
      INTEGER               NTVEC
      INTEGER               START

      LOGICAL               MODS
      LOGICAL               YABBRV
     


      IF ( RETURN() ) THEN
         RETURN
      END IF

      CALL CHKIN ( 'FNDTAG' )

C
C     No tag found yet.
C
      FOUND = .FALSE.

C
C     Get a local copy of the input line.  Replace any commas with
C     blanks.
C
      CALL REPLCH ( LINE, ',',  ' ', LOCLIN )

C
C     Basic idea:  TPARTV is a non-error-signaling routine that
C     can recognize a time tag.  We find the initial word, and
C     check that TPARTV recognizes as a valid time tag.
C
      START = 1

      CALL FNDNWD ( LOCLIN, START, B, E )

      IF ( E .LT. 1 ) THEN
C
C        No words are to be found on this line. 
C           
         ELOC = 0

         CALL CHKOUT ( 'FNDTAG' )
         RETURN

      ELSE

C
C        See whether TPARTV understands the time string.  
C        TPARTV has the convenient property of not signaling an 
C        error if it doesn't recognize the time string.
C
         CALL UCASE ( LOCLIN(:E), TAG )

         CALL TPARTV ( TAG,  
     .                 TVEC,    NTVEC,   TTYPE,  MODIFY,
     .                 MODS,    YABBRV,  FOUND,  PICTUR,  ERRMSG  )
      END IF


C
C     Adjust ELOC if the word containing the time tag ends with a 
C     comma.  This allows the caller to skip over the comma.
C      
      IF (  ( E + 1 ) .LE. MAXLIN  ) THEN

         IF ( LINE(E+1:E+1) .EQ. ',' ) THEN
            ELOC = E+1
         ELSE 
            ELOC = E
         END IF
     
      ELSE
         
         ELOC = E

      END IF
     
      CALL CHKOUT ( 'FNDTAG' )
      RETURN
      END


