C$Procedure ADDCOM ( Add comments to type 6 CK file )

      SUBROUTINE ADDCOM ( INPFN, OUTFN )
      IMPLICIT NONE 
 
C$ Abstract
C
C     Add comments to the output type 6 CK file created by CK5TO6.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     CK
C
C$ Keywords
C
C     CK
C     FILES
C
C$ Declarations

      CHARACTER*(*)         INPFN
      CHARACTER*(*)         OUTFN
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     INPFN      I   Name of input type 5 CK file.
C     OUTFN      I   Name of output type 6 CK file.
C
C$ Detailed_Input
C   
C     INPFN          is the name of the input type 5 CK file.
C
C     OUTFN          is the name of the output type 6 CK file.
C                
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     1) If an error occurs while reading the comment file, the
C        error will be diagnosed by routines in the call tree of
C        this routine.
C
C     2) If an error occurs while attempting to add comments to the
C        output DSK file, the error will be diagnosed by routines in
C        the call tree of this routine.
C
C$ Files
C
C     Normally, the mapping implemented by this routine is defined
C     by a kernel variable introduced into the kernel pool by loading
C     a SPICE text kernel.  
C
C$ Particulars
C
C     This routine adds comments to the comment area of the output
C     type 6 CK file. These are:
C
C        - A statement that the output file was created by this
C          conversion program.
C
C        - The run time and date, and the names of the input
C          and output files.
C
C        - The contents of a comment area of the input type 5 CK.
C
C$ Examples
C
C     None.
C     
C$ Restrictions
C
C     1) This routine is intended for use only within the CK5TO6
C        program.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     N.J. Bachman    (JPL)
C
C$ Version
C
C-    MKDSK Version 1.0.0, 15-APR-2010 (NJB)
C
C-&


      
C
C     SPICELIB functions
C
      INTEGER               RTRIM

      LOGICAL               RETURN

C
C     Local parameters
C
      INTEGER               FILSIZ
      PARAMETER           ( FILSIZ = 255 )

      INTEGER               MXCMNT
      PARAMETER           ( MXCMNT = 20 )

      INTEGER               SHRTLN
      PARAMETER           ( SHRTLN = 80 )

C
C     Local variables
C
      
      CHARACTER*(SHRTLN)    ASTRLN
      CHARACTER*(FILSIZ)    CMNBUF ( MXCMNT )
      CHARACTER*(SHRTLN)    TSTAMP

      DOUBLE PRECISION      TVEC   ( 6 )

      INTEGER               I
      INTEGER               INHAN
      INTEGER               L
      INTEGER               N
      INTEGER               OUTHAN

      LOGICAL               DONE

C
C     Saved variables
C

C
C     Save large buffers to avoid stack problems in 
C     some C environments.
C
      SAVE



      IF ( RETURN() ) THEN
         RETURN
      END IF

      CALL CHKIN ( 'ADDCOM' )

C
C     Get handles of input and output CKs.
C
      CALL DAFFNH ( INPFN, INHAN  )
      CALL DAFFNH ( OUTFN, OUTHAN )

C
C     Comment area separator line.
C
      ASTRLN = '****************************************' //
     .         '****************************************'
            
C
C     Add a header preceding contents of the setup file and containing
C     setup file name and current CPU time.
C
      CALL CPUTIM ( TVEC )
      TSTAMP = 'YYYY-MM-DDTHR:MN:SC'

      CALL DPFMT ( TVEC(1), '0YYY',  TSTAMP(1:4)   )
      CALL DPFMT ( TVEC(2), '0M',    TSTAMP(6:7)   )
      CALL DPFMT ( TVEC(3), '0D',    TSTAMP(9:10)  )
      CALL DPFMT ( TVEC(4), '0h',    TSTAMP(12:13) )
      CALL DPFMT ( TVEC(5), '0m',    TSTAMP(15:16) )
      CALL DPFMT ( TVEC(6), '0s',    TSTAMP(18:19) )
      
      CMNBUF(1)  = ' ' 
      CMNBUF(2)  =  ASTRLN 
      CMNBUF(3)  = 'This file was created by CK5TO6. CK5TO6 converts '
      CMNBUF(4)  = 'a CK file containing only type 5 segments to one '
      CMNBUF(5)  = 'containing only type 6 segments.'
      CMNBUF(6)  = ' ' 
      CMNBUF(7)  = 'CK5TO6 RUN DATE/TIME: ' // TSTAMP(:RTRIM(TSTAMP))
      CMNBUF(8)  = 'CK5TO6 INPUT FILE:    ' // INPFN (:RTRIM(INPFN)) 
      CMNBUF(9)  = 'CK5TO6 OUTPUT FILE:   ' // OUTFN (:RTRIM(OUTFN))
      CMNBUF(10) = ' ' 
      CMNBUF(11) = 'Comments from the input file are '
     .//             'included below.'

      CMNBUF(12) = ASTRLN 
      CMNBUF(13) = ' ' 

      L          = 13

C
C     Write the buffer to the output file.
C
      CALL DAFAC ( OUTHAN, L, CMNBUF )

      DO I = 1, MXCMNT
         CMNBUF(I) = ' '
      END DO

C
C     Now we will copy contents of the input file's comment area
C     to the output file.
C
      CALL DAFEC ( INHAN, MXCMNT, N, CMNBUF, DONE ) 
      CALL DAFAC ( OUTHAN,        N, CMNBUF       )

      DO WHILE ( .NOT. DONE )

         CALL DAFEC ( INHAN, MXCMNT, N, CMNBUF, DONE ) 
         CALL DAFAC ( OUTHAN,        N, CMNBUF       )

      END DO


      CALL CHKOUT ( 'ADDCOM' )
      RETURN
      END


 
