C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C     Compress an object list.
C
      SUBROUTINE OBJCMP ( OBJLIS )
 
      IMPLICIT NONE
      INCLUDE              'object.inc'
      INTEGER               OBJLIS ( LBCELL:* )
C
C     SPICELIB Functions
C
      INTEGER               CARDI
C
C     Local Variables
C
      INTEGER               MTASIZ
      INTEGER               NHAVE
      INTEGER               PUT
      INTEGER               GET
      INTEGER               I
      INTEGER               J
 
      MTASIZ = OBJLIS ( RMPOBJ )
      NHAVE  = OBJLIS ( NACTIV )
 
      IF ( NHAVE .EQ. 0 ) THEN
         CALL SCARDI ( 0, OBJLIS )
         RETURN
      END IF
 
      IF ( NHAVE*MTASIZ .EQ. CARDI(OBJLIS) ) THEN
         RETURN
      END IF
 
 
      GET = 1
      PUT = 1
 
      DO I = 1, NHAVE
 
         DO WHILE ( OBJLIS(GET) .EQ. NULL )
            GET = GET + MTASIZ
         END DO
 
         IF ( PUT .NE. GET ) THEN
 
            DO J = 1, MTASIZ
               OBJLIS(PUT) = OBJLIS(GET)
               PUT         = PUT + 1
               GET         = GET + 1
            END DO
 
         ELSE
 
            GET = GET + MTASIZ
            PUT = PUT + MTASIZ
 
         END IF
 
      END DO
 
      CALL SCARDI ( NHAVE*MTASIZ, OBJLIS )
 
      RETURN
      END
