from smtplib import SMTP        # use this for standard SMTP protocol   (port 25, no encryption)
from email.mime.text import MIMEText
import socket

def send_status_email(setup, directories=[], sources_text='',
                      body_text='', kernels_text='', error=False):

    SMTPserver = 'smtp.sciops.esa.int'
    sender = 'esa_spice@sciops.esa.int'
    operational_host = setup['operational_host']
    if body_text:
        destination = setup['email'][0]['developer']
        if error:
            subject = "[ADCSng]: {} Runtime Error".format(setup['email'][0]['mission'])
        else:
            subject = "[ADCSng]: {} Execution Log".format(setup['email'][0]['mission'])
    else:
        destination = setup['email'][0]['clients']

        if socket.gethostname() != operational_host:
            host = '[TEST:{}]:'.format(socket.gethostname())
        else:
            host = ''

        subject = "{}{} New Operational Kernels Available".format(host, setup['email'][0]['mission'])

    if not sources_text:
        sources_text = 'None (ADCSng executed to generate MK)'

    USERNAME = "esa_spice"
    PASSWORD = "WRUBTNBLOJMHLUOR"

    # typical values for text_subtype are plain, html, xml
    text_subtype = 'plain'

    try:
        #
        # We build the e-mail body from the template
        #
        if not body_text:

            with open(setup['root_dir'] + '/etc/email.commnt', 'r') as f:
                body_text = ''
                lin_nr = 1
                for line in f:

                    # Insert extra line in the template if defined from user configuration:
                    # e.g.
                    #  "extra_lines": {
                    #                   "1": "Note_1\n",
                    #                   "10": "Note_10",
                    #                   "20": "Note_20\n\n",
                    #                   "30": "Note_30"
                    #                  }
                    if "extra_lines" in setup['email'][0]:
                        if str(lin_nr) in setup['email'][0]["extra_lines"]:
                            body_text += setup['email'][0]["extra_lines"][str(lin_nr)]

                    body_text += line
                    lin_nr += 1

            body_text = body_text.replace('{mission}', setup['email'][0]['mission'])
            body_text = body_text.replace('{contact}', setup['email'][0]['contact'])
            body_text = body_text.replace('{ftp_address}', setup['email'][0]['ftp_address'])
            body_text = body_text.replace('{git_repository}', setup['email'][0]['git_repository'])
            body_text = body_text.replace('{skd_name}', setup['email'][0]['skd_name'])
            body_text = body_text.replace('{sources}', sources_text)
            body_text = body_text.replace('{kernels}', kernels_text)

        body_text_list = body_text.split('\n')

        index = 0
        body_text_loop = body_text_list.copy()
        for line in body_text_loop:
            if '#' in line:
                if setup['email'][0]['git_repository'] == "False":
                    body_text_list.remove(line)
                else:
                    body_text_list[index] = line.replace('#','')
            index += 1

        body_text = '\n'.join(body_text_list)


        # Open a plain text file for reading.  For this example, assume that
        # the text file contains only ASCII characters.

        msg = MIMEText(body_text, text_subtype)
        msg['Subject'] = subject
        msg['From'] = sender  # some SMTP servers will do this automatically, not all

        # For each email in destination separated by ';' send the email
        dest_emails = destination.split(';')

        for dest_email in dest_emails:
            conn = SMTP(SMTPserver)

            conn.starttls()
            conn.ehlo()
            # Pretend the SMTP server supports some forms of authentication.
            conn.esmtp_features['auth'] = 'LOGIN DIGEST-MD5 PLAIN'


            conn.set_debuglevel(False)
            conn.login(USERNAME, PASSWORD)
            try:
                conn.sendmail(sender, dest_email, msg.as_string())
            except Exception as exc:
                print("Send mail failed; {}".format(str(exc)))  # give a error message
            finally:
                conn.quit()

    except Exception as exc:

        print("Mail failed; {}".format(str(exc)))# give a error message

