#!/usr/bin/perl
#   metacharacters:        {}[]()^$.|*+?\
#   for character class:   -]\^$

#****************************************************************************#
#- Table of contents
##TOC
#****************************************************************************#
#- 1 Settings
#-   1.1 Metakernel
#-   1.2 Archive DATA directory
#-   1.3 SKD kernels directory
#-   1.4 SPICE executables
#-   1.5 Seperator between file reports
#- 2 Read metakernel
#- 3 Get list of kernels in archive
#- 4 Loop through list
#-   4.1 Get path to kernel in archive
#-   4.2 Get path to kernel in SKD
#-   4.3 Treat explicitely
#-   4.4 Check difference
#-       4.4.1 Get difference for text kernels
#-       4.4.2 Get difference for SPKs
#-             4.4.2.1 Comment
#-             4.4.2.2 Data

#****************************************************************************#
#- 1
## Settings
#****************************************************************************#

#============================================================================#
#- 1.1
### Staging area with latest aareadmes
#============================================================================#
$staging = '../../RO-RL-E-M-A-C-SPICE-6-V1.0_rel0004_staging';

#============================================================================#
#- 1.3
### SKD kernels directory
#============================================================================#
$kernels = '~/COMETS/ROSETTA/SPICE/rosetta/kernels';

#============================================================================#
#- 1.4
### SPICE executables
#============================================================================#
$exe = '~/SUN/FORTRAN/toolkit/exe';

#============================================================================#
#- 1.5
### Seperator between file reports
#============================================================================#
$sep = "\n====================================".
         "====================================\n\n";

#****************************************************************************#
#- 3
## Get list of aareadmes in staging area
#****************************************************************************#
@list = `cd $staging; ls */*.txt`;

#****************************************************************************#
#- 4
## Loop through list
#****************************************************************************#
foreach ( @list ) {
    chomp;

#============================================================================#
#- 4.1
### Get path to file in staging area
#============================================================================#
    $inarc = "$staging/$_";

#============================================================================#
#- 4.2
### Get path to file in SKD
#============================================================================#
    if ( /^(\w+)\/(\S+)$/ ) {
        $dir = $1;
        $file = $2;
    } else {
	die;
    }
    $dir =~ tr/[A-Z]/[a-z]/;
    $inskd = "$kernels/$dir/$file";

#============================================================================#
#- 4.4
### Check difference
#============================================================================#
    $diff = `diff $inarc $inskd 2>&1`;
    if ( $diff ) {
	print $sep;
	if ( $diff =~ /No such file or directory/ ) {
	    print "$dir/$file missing in SKD.\n";
	} else {
	    print "$dir/$file different in SKD.\n";
	    print `diff $inarc $inskd`;
	}
    }

}
