C$ Abstract
C
C     Parameter declarations for TCP2SCET program.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Author_and_Institution
C
C     B.V.Semenov      (JPL)
C
C$ Version
C
C-    TCP2SCET Version 1.3.1, 03-JUN-2020 (BVS)
C
C-    TCP2SCET Version 1.3.0, 28-OCT-2011 (BVS)
C
C-    TCP2SCET Version 1.2.0, 04-JAN-2006 (BVS)
C
C-    TCP2SCET Version 1.1.0, 13-OCT-2003 (BVS)
C
C-    TCP2SCET Version 1.0.0, 16-SEP-2003 (BVS)
C 
C-&
 
C
C     TCP2SCET Version.
C
      CHARACTER*(*)         VER
      PARAMETER           ( VER = '1.3.1, June 3, 2020' )

C
C     TCP format/structure related parameters
C
C     TCP record size is 48 bytes.
C
      INTEGER               TCPRSZ
      PARAMETER           ( TCPRSZ = 48 )

C
C     SCLK tick size, seconds. Assume 1/65536th of a second.
C
      DOUBLE PRECISION      TICKSZ
      PARAMETER           ( TICKSZ =  0.00001525878906D0 )

C
C     Maximum number of TCPs the program can deal with.
C
      INTEGER               MAXTCP
      PARAMETER           ( MAXTCP = 10000 )

C
C     Command lines keys and total number of them.
C
      CHARACTER*(*)         SETKEY
      PARAMETER           ( SETKEY = '-SETUP' )
 
      CHARACTER*(*)         MODKEY
      PARAMETER           ( MODKEY = '-MODE' )
 
      CHARACTER*(*)         TCPKEY
      PARAMETER           ( TCPKEY = '-TCP' )
 
      CHARACTER*(*)         SCTKEY
      PARAMETER           ( SCTKEY = '-SCET' )
 
      CHARACTER*(*)         SILKEY
      PARAMETER           ( SILKEY = '-SILENT' )
 
      CHARACTER*(*)         VRBKEY
      PARAMETER           ( VRBKEY = '-VERBOSE' )
 
      CHARACTER*(*)         HLPKEY
      PARAMETER           ( HLPKEY = '-HELP' )
 
      CHARACTER*(*)         HKEY
      PARAMETER           ( HKEY   = '-H' )
 
      CHARACTER*(*)         USGKEY
      PARAMETER           ( USGKEY = '-USAGE' )
 
      CHARACTER*(*)         UKEY
      PARAMETER           ( UKEY   = '-U' )
 
      CHARACTER*(*)         TMLKEY
      PARAMETER           ( TMLKEY = '-TEMPLATE' )
 
      INTEGER               MAXKEY
      PARAMETER           ( MAXKEY = 11 )
 
C
C     Setup file variables.
C
      CHARACTER*(*)         LSKKWD
      PARAMETER           ( LSKKWD = 'LEAPSECONDS_FILE' )
 
      CHARACTER*(*)         SCLKWD
      PARAMETER           ( SCLKWD = 'CLOCK_START_TIME' )
 
      CHARACTER*(*)         BADKWD
      PARAMETER           ( BADKWD = 'BAD_PACKET_TIMES' )
 
      CHARACTER*(*)         DISKWD
      PARAMETER           ( DISKWD = 'DISCONTINUITY_THRESHOLD' )
 
      CHARACTER*(*)         INTKWD
      PARAMETER           ( INTKWD = 'AUXILIARY_INTERVAL_SIZE' )
 
      CHARACTER*(*)         MNMKWD
      PARAMETER           ( MNMKWD = 'MISSION_NAME' )
 
      CHARACTER*(*)         MIDKWD
      PARAMETER           ( MIDKWD = 'MISSION_ID' )
 
      CHARACTER*(*)         SNMKWD
      PARAMETER           ( SNMKWD = 'SPACECRAFT_NAME' )
 
      CHARACTER*(*)         SIDKWD
      PARAMETER           ( SIDKWD = 'SPACECRAFT_ID' )
 
      CHARACTER*(*)         PIDKWD
      PARAMETER           ( PIDKWD = 'PRODUCER_ID' )
 
C
C     Mode system indentifier strings.
C
      CHARACTER*(*)         STPMOD
      PARAMETER           ( STPMOD = 'STEP' )
 
      CHARACTER*(*)         STRMOD
      PARAMETER           ( STRMOD = 'STRETCH' )
 
C
C     Line size parameters.
C
      INTEGER               WRDSIZ
      PARAMETER           ( WRDSIZ = 32   )
 
      INTEGER               SLNSIZ
      PARAMETER           ( SLNSIZ = 80 )

      INTEGER               LINSIZ
      PARAMETER           ( LINSIZ = 256  )
 
      INTEGER               LLNSIZ
      PARAMETER           ( LLNSIZ = 2048 )
 
C
C     File name length parameters.
C
      INTEGER               FILSIZ
      PARAMETER           ( FILSIZ  =  256 )
 
