C$Procedure      SHOTMP ( Show a specification template )
C
      SUBROUTINE SHOTMP ()
C
C$ Abstract
C
C     Send to standard output a template for specifying a collection
C     of predict C-kernel segment.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     Utility
C
C$ Declarations
 
      IMPLICIT NONE
 
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     None
C
C$ Detailed_Input
C
C     None.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Files
C
C     None.
C
C$ Particulars
C
C     This simply writes an template to standard output.  See
C     the template for details.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Literature_References
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 31-MAR-2000 (WLT)
C
C
C-&
 
 
 
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 32 )
 
      INTEGER               TMPSIZ
      PARAMETER           ( TMPSIZ = 239 )
C
C     Utility Functions
C
      CHARACTER*(WDSIZE)    BEGDAT
      CHARACTER*(WDSIZE)    BEGTXT
 
      CHARACTER*(LNSIZE)    TEXT ( TMPSIZ )
      INTEGER               I
 
 
 
 
      TEXT(  1 ) = BEGTXT()
      TEXT(  2 ) = ' '
      TEXT(  3 ) = 'The specification of a C-kernel requires '
     .//           'several parts.'
      TEXT(  4 ) = 'The most fundamental of these are:'
      TEXT(  5 ) = ' '
      TEXT(  6 ) = '1) The spacecraft clock Id for the SCLK t'
     .//           'hat will be used to'
      TEXT(  7 ) = '   convert between "ticks" and ephemeris '
     .//           'time.'
      TEXT(  8 ) = ' '
      TEXT(  9 ) = '2) The spacecraft Id for the structure th'
     .//           'at all of the C-kernels'
      TEXT( 10 ) = '   may be regarded as being "centered" --'
     .//           '- that is the Id-code'
      TEXT( 11 ) = '   for the origin of the C-kernel frames.'
      TEXT( 12 ) = ' '
      TEXT( 13 ) = 'These two items are specified with the va'
     .//           'riables shown below:'
      TEXT( 14 ) = ' '
      TEXT( 15 ) = BEGDAT()
      TEXT( 16 ) = ' '
      TEXT( 17 ) = '   CK-SCLK          = <normally -scid>'
      TEXT( 18 ) = '   CK-SPK           = <scid>'
      TEXT( 19 ) = ' '
      TEXT( 20 ) = BEGTXT()
      TEXT( 21 ) = ' '
      TEXT( 22 ) = 'C-kernel frames are defined in terms of "'
     .//           'dynamic orientations" which'
      TEXT( 23 ) = 'are in turn defined in terms of direction'
     .//           's.  We look at the directions'
      TEXT( 24 ) = 'first.'
      TEXT( 25 ) = ' '
      TEXT( 26 ) = 'Directions'
      TEXT( 27 ) = '----------'
      TEXT( 28 ) = ' '
      TEXT( 29 ) = 'You define a direction with a specificati'
     .//           'on of the form:'
      TEXT( 30 ) = ' '
      TEXT( 31 ) = '   directionName = description'
      TEXT( 32 ) = ' '
      TEXT( 33 ) = 'where'
      TEXT( 34 ) = ' '
      TEXT( 35 ) = '   directionName  is a name of your choos'
     .//           'ing subject to the restriction'
      TEXT( 36 ) = '                  that it must be 32 char'
     .//           'acters or fewer in length.'
      TEXT( 37 ) = '                  Must start with a lette'
     .//           'r and may contain only'
      TEXT( 38 ) = '                  letters, digits, and un'
     .//           'derscores.'
      TEXT( 39 ) = ' '
      TEXT( 40 ) = '   description    is a string that descri'
     .//           'bes the direction.  For example,'
      TEXT( 41 ) = '                  "POSITION OF JUPITER FR'
     .//           'OM EARTH CORRECTION LT+S"'
      TEXT( 42 ) = '                  The complete list of de'
     .//           'scription templates can'
      TEXT( 43 ) = '                  be obtained by running '
     .//           'prediCkt with the'
      TEXT( 44 ) = '                  argument -dirspec.'
      TEXT( 45 ) = ' '
      TEXT( 46 ) = 'The direction specifications should be su'
     .//           'pplied via the kernel pool'
      TEXT( 47 ) = 'variable DIRECTION_SPECS.  Remember that '
     .//           'you must keep the lines'
      TEXT( 48 ) = 'in your input file to 80 or fewer charact'
     .//           'ers.  Since descriptions'
      TEXT( 49 ) = 'tend to be longer than 80 characters you '
     .//           'need to "continue" your'
      TEXT( 50 ) = 'description by placing a "-" at the end o'
     .//           'f a line and then'
      TEXT( 51 ) = 'continuing the description on the next li'
     .//           'ne as in the example'
      TEXT( 52 ) = 'shown here:'
      TEXT( 53 ) = ' '
      TEXT( 54 ) = '   DIRECTION_SPECS  += ''JUPITER_POSITION'
     .//           ' = POSITION OF JUPITER -'''
      TEXT( 55 ) = '   DIRECTION_SPECS  += ''FROM EARTH CORRE'
     .//           'CTION LT+S'''
      TEXT( 56 ) = ' '
      TEXT( 57 ) = 'or'
      TEXT( 58 ) = ' '
      TEXT( 59 ) = '   DIRECTION_SPECS  += ('
      TEXT( 60 ) = '                         ''JUPITER_POSITI'
     .//           'ON = POSITION OF JUPITER -'','
      TEXT( 61 ) = '                         ''FROM EARTH COR'
     .//           'RECTION LT+S'''
      TEXT( 62 ) = '                       )'
      TEXT( 63 ) = BEGDAT()
      TEXT( 64 ) = ' '
      TEXT( 65 ) = '   DIRECTION_SPECS     += ''name1 = descr'
     .//           'iption1 (continue with "-")'''
      TEXT( 66 ) = '   DIRECTION_SPECS     += ''name2 = descr'
     .//           'iption2 (continue with "-")'''
      TEXT( 67 ) = '   DIRECTION_SPECS     += ''name3 = descr'
     .//           'iption3 (continue with "-")'''
      TEXT( 68 ) = '   DIRECTION_SPECS     += ''name4 = descr'
     .//           'iption4 (continue with "-")'''
      TEXT( 69 ) = ' '
      TEXT( 70 ) = BEGTXT()
      TEXT( 71 ) = ' '
      TEXT( 72 ) = 'Orientations:'
      TEXT( 73 ) = '-------------'
      TEXT( 74 ) = ' '
      TEXT( 75 ) = 'Orientations are coordinate reference fra'
     .//           'mes (they have 3 axes, X,Y,'
      TEXT( 76 ) = 'and Z that are mutually orthogonal).  You'
     .//           ' specify an orientation by'
      TEXT( 77 ) = 'first giving the direction that one of it'
     .//           's axes (or opposites) points.'
      TEXT( 78 ) = 'This axis is called the primary axis of t'
     .//           'he orientation. It ties down'
      TEXT( 79 ) = 'one direction of the of the orientation. '
     .//           ' To tie down the other two'
      TEXT( 80 ) = 'you need to specify the direction of a se'
     .//           'condary axis (or its'
      TEXT( 81 ) = 'opposite).  Since pairs of directions are'
     .//           ' not in general orthogonal,'
      TEXT( 82 ) = 'the secondary axis can not point directly'
     .//           ' along the second direction.'
      TEXT( 83 ) = 'Instead, the frame is oriented so that th'
     .//           'e secondary axis points as'
      TEXT( 84 ) = 'closely as possible towards the secondary'
     .//           ' direction while keeping the'
      TEXT( 85 ) = 'primary direction fixed.  (Technically th'
     .//           'e third unspecified axis is'
      TEXT( 86 ) = 'defined to be parallel to the cross produ'
     .//           'ct of the primary and secondary'
      TEXT( 87 ) = 'directions so that he primary, secondary '
     .//           'and unspecified axes'
      TEXT( 88 ) = 'form a right handed set of basis directio'
     .//           'ns.)'
      TEXT( 89 ) = ' '
      TEXT( 90 ) = 'Specification of an orientation is done b'
     .//           'y giving:'
      TEXT( 91 ) = ' '
      TEXT( 92 ) = '  1) A name for the orientation (subject '
     .//           'to the same restrictions'
      TEXT( 93 ) = '     as used for naming directions)'
      TEXT( 94 ) = ' '
      TEXT( 95 ) = '  2) A designation of a primary axis and '
     .//           'direction (or direction'
      TEXT( 96 ) = '     specification).'
      TEXT( 97 ) = ' '
      TEXT( 98 ) = '  3) A designation of a secondary axis an'
     .//           'd direction (or direction'
      TEXT( 99 ) = '     specification).'
      TEXT( 100 ) = ' '
      TEXT( 101 ) = '  4) The name of a reference frame that '
     .//            'will be recognized by the'
      TEXT( 102 ) = '     SPICE system once the appropriate f'
     .//            'rame kernels have been'
      TEXT( 103 ) = '     furnished.  This is the frame that '
     .//            'will be the "relative"'
      TEXT( 104 ) = '     frame in the C-kernel for this orie'
     .//            'ntation when the C-kernel'
      TEXT( 105 ) = '     is constructed.'
      TEXT( 106 ) = ' '
      TEXT( 107 ) = 'The name of the orientation and its rela'
     .//            'tive frame are simply one word'
      TEXT( 108 ) = 'strings.  The primary and secondary axes'
     .//            ' are specified as:'
      TEXT( 109 ) = ' '
      TEXT( 110 ) = '   axis = direction_name'
      TEXT( 111 ) = 'or'
      TEXT( 112 ) = '   axis = description'
      TEXT( 113 ) = ' '
      TEXT( 114 ) = 'where'
      TEXT( 115 ) = ' '
      TEXT( 116 ) = '   axis              is one of +x, +y, +'
     .//            'z, -x, -y, -z.  (The "+" may be'
      TEXT( 117 ) = '                     dropped if you desi'
     .//            're).  The case of the letters'
      TEXT( 118 ) = '                     in the axis specifi'
     .//            'cation is insignificant.  +X'
      TEXT( 119 ) = '                     and +x mean the sam'
     .//            'e thing.'
      TEXT( 120 ) = ' '
      TEXT( 121 ) = '   direction_name    is just the name of'
     .//            ' one of the directions you'
      TEXT( 122 ) = '                     created in the firs'
     .//            't part of this specification'
      TEXT( 123 ) = '                     kernel.'
      TEXT( 124 ) = ' '
      TEXT( 125 ) = '   description       is any description '
     .//            'that you can use in the'
      TEXT( 126 ) = '                     creation of a direc'
     .//            'tion.'
      TEXT( 127 ) = ' '
      TEXT( 128 ) = 'As with the specification of directions,'
     .//            ' the specification of'
      TEXT( 129 ) = 'a primary or secondary axis must be plac'
     .//            'ed in a string and'
      TEXT( 130 ) = 'continued (if necessary) using "-".'
      TEXT( 131 ) = ' '
      TEXT( 132 ) = BEGDAT()
      TEXT( 133 ) = ' '
      TEXT( 134 ) = '   ORIENTATION_NAME += ''aOneWordName'
     .//            'ForAFrame1'''
      TEXT( 135 ) = '   PRIMARY          += ''axis1 = dire'
     .//            'ctionNamex1 (or description)'''
      TEXT( 136 ) = '   SECONDARY        += ''axis2 = dire'
     .//            'ctionNamey1 (or description))'''
      TEXT( 137 ) = '   BASE_FRAME       += ''Frame1Name'''
      TEXT( 138 ) = ' '
      TEXT( 139 ) = '   ORIENTATION_NAME += ''aOneWordName'
     .//            'ForAFrame2'''
      TEXT( 140 ) = '   PRIMARY          += ''axis1 = dire'
     .//            'ctionNamex2 (or description)'''
      TEXT( 141 ) = '   SECONDARY        += ''axis2 = dire'
     .//            'ctionNamey2 (or description))'''
      TEXT( 142 ) = '   BASE_FRAME   += ''Frame2Name'''
      TEXT( 143 ) = ' '
      TEXT( 144 ) = '   ORIENTATION_NAME += ''aOneWordName'
     .//            'ForAFrame3'''
      TEXT( 145 ) = '   PRIMARY          += ''axis1 = dire'
     .//            'ctionNamex3 (or description)'''
      TEXT( 146 ) = '   SECONDARY        += ''axis2 = dire'
     .//            'ctionNamey3 (or description))'''
      TEXT( 147 ) = '   BASE_FRAME       += ''Frame3Name'''
      TEXT( 148 ) = ' '
      TEXT( 149 ) = BEGTXT()
      TEXT( 150 ) = '   .'
      TEXT( 151 ) = '   .'
      TEXT( 152 ) = '   etc.'
      TEXT( 153 ) = ' '
      TEXT( 154 ) = 'C-kernels'
      TEXT( 155 ) = '--------------'
      TEXT( 156 ) = ' '
      TEXT( 157 ) = 'Once the various orientations have been '
     .//            'defined, you are ready'
      TEXT( 158 ) = 'to define the various CK structures and '
     .//            'how they are oriented'
      TEXT( 159 ) = '      over time.  Begin by specifying th'
     .//            'e Id-code for your'
      TEXT( 160 ) = '      C-kernel.'
      TEXT( 161 ) = ' '
      TEXT( 162 ) = BEGDAT()
      TEXT( 163 ) = ' '
      TEXT( 164 ) = '   CK-FRAMES            += idcode1'
      TEXT( 165 ) = ' '
      TEXT( 166 ) = BEGTXT()
      TEXT( 167 ) = ' '
      TEXT( 168 ) = 'The orientation of the structure with th'
     .//            'is Id-code is given by'
      TEXT( 169 ) = 'specifying its orientation and the bound'
     .//            's if the time interval when it'
      TEXT( 170 ) = 'possesses that orientation. Note that th'
     .//            'e times must be specified using'
      TEXT( 171 ) = 'the @<time> format recognized by the ker'
     .//            'nel pool software.'
      TEXT( 172 ) = ' '
      TEXT( 173 ) = BEGDAT()
      TEXT( 174 ) = ' '
      TEXT( 175 ) = '   CK<idcode1>ORIENTATION += ''dynamicOr'
     .//            'ientationName1 [at epoch]'''
      TEXT( 176 ) = '   CK<idcode1>START       += start1'
      TEXT( 177 ) = '   CK<idcode1>STOP        += stop1'
      TEXT( 178 ) = ' '
      TEXT( 179 ) = BEGTXT()
      TEXT( 180 ) = ' '
      TEXT( 181 ) = 'You may use the additional phrase [at ep'
     .//            'och] to freeze the orientation'
      TEXT( 182 ) = 'relative to the ORIENTATION_RELTO frame '
     .//            'for the entire interval.  The'
      TEXT( 183 ) = 'epoch will be interpreted as an ephemeri'
     .//            's epoch.'
      TEXT( 184 ) = ' '
      TEXT( 185 ) = 'If there is a second orientation, its de'
     .//            'scription should come next.'
      TEXT( 186 ) = ' '
      TEXT( 187 ) = BEGDAT()
      TEXT( 188 ) = ' '
      TEXT( 189 ) = '   CK<idcode1>ORIENTATION += ''dynamicOr'
     .//            'ientationName2 [at epoch]'''
      TEXT( 190 ) = '   CK<idcode1>START       += start2'
      TEXT( 191 ) = '   CK<idcode1>STOP        += stop2'
      TEXT( 192 ) = ' '
      TEXT( 193 ) = BEGTXT()
      TEXT( 194 ) = ' '
      TEXT( 195 ) = 'If there is a third segment, its descrip'
     .//            'tion should come next and so'
      TEXT( 196 ) = 'on...'
      TEXT( 197 ) = ' '
      TEXT( 198 ) = 'Note that the orientations do not have t'
     .//            'o be ordered in time. However,'
      TEXT( 199 ) = 'they will be returned in the order of th'
     .//            'e "START" time for a particular'
      TEXT( 200 ) = 'CK Id-code.'
      TEXT( 201 ) = ' '
      TEXT( 202 ) = 'If a time gap appears between the stop o'
     .//            'f one orientation segment and'
      TEXT( 203 ) = 'the start of the next, prediCkt will ins'
     .//            'ert a "slew" in the C-kernel'
      TEXT( 204 ) = 'that will bridge between the two orienta'
     .//            'tions.'
      TEXT( 205 ) = ' '
      TEXT( 206 ) = 'Adding More CK Frames.'
      TEXT( 207 ) = '----------------------'
      TEXT( 208 ) = ' '
      TEXT( 209 ) = 'If you need to create a C-kernel for mul'
     .//            'tiple structures on the same'
      TEXT( 210 ) = 'spacecraft, you can add more frames and '
     .//            'frame orientations as shown'
      TEXT( 211 ) = 'below.  First add the next Id-code ...'
      TEXT( 212 ) = ' '
      TEXT( 213 ) = BEGDAT()
      TEXT( 214 ) = ' '
      TEXT( 215 ) = '   CK-FRAMES            += idcode2'
      TEXT( 216 ) = ' '
      TEXT( 217 ) = BEGTXT()
      TEXT( 218 ) = ' '
      TEXT( 219 ) = 'then add its frame specification ...'
      TEXT( 220 ) = ' '
      TEXT( 221 ) = BEGDAT()
      TEXT( 222 ) = ' '
      TEXT( 223 ) = '   CK<idcode2>ORIENTATION += orientation'
     .//            '1'
      TEXT( 224 ) = '   CK<idcode2>START       += start1'
      TEXT( 225 ) = '   CK<idcode2>STOP        += stop1'
      TEXT( 226 ) = ' '
      TEXT( 227 ) = BEGTXT()
      TEXT( 228 ) = ' '
      TEXT( 229 ) = '...and so on for each orientation.'
      TEXT( 230 ) = ' '
      TEXT( 231 ) = BEGDAT()
      TEXT( 232 ) = ' '
      TEXT( 233 ) = '   CK<idcode2>ORIENTATION += orientation'
     .//            '2'
      TEXT( 234 ) = '   CK<idcode2>START       += start2'
      TEXT( 235 ) = '   CK<idcode2>STOP        += stop2'
      TEXT( 236 ) = ' '
      TEXT( 237 ) = BEGTXT()
      TEXT( 238 ) = ' '
      TEXT( 239 ) = ' '
 
 
 
      DO I = 1, TMPSIZ
         CALL TOSTDO ( TEXT(I) )
      END DO
 
      RETURN
      END
