import os
import logging
from datetime import datetime, timedelta


def fecs_processing(event_list, kernel):

    directions = ''
    orientations = ''
    timeline = ''
    first = True
    previous_event = False
    angles = []
    prev_end_angle = ''

    for event in event_list:

        #
        # We have two types of events:
        #    1) Normal Rolls      (ROLL)
        #    2) Calibration Rolls (CALIB_ROLL_MAG)
        #
        # <ROLL time="2020-166T00:32:46Z" duration="1052" start_roll_deg="0" end_roll_deg="45"/><!-- SCI_ROLL in v1_2 -->
        # <CALIB_ROLL_MAG time = "2020-092T04:34:10Z" duration = "43802"/>
        #
        event_type = event.split()[0][1:]

        #
        # Note that for the events to be valid, start_roll_deg must be equal
        # to the value of end_roll_deg for the previous roll event.
        #
        if event_type == 'ROLL':
            srt_angle = event.split('start_roll_deg')[-1].split('"')[1]
            if not first and not previous_event:
                prev_end_angle = end_angle
                if not float(srt_angle) == float(prev_end_angle):
                    raise ValueError('Start Roll Angle different than previous End Roll Angle')
            end_angle = event.split('end_roll_deg')[-1].split('"')[1]
        else:
            if first:
                srt_angle = 0.0

        start_utc = event.split('"')[1]
        # 2020-092T04:34:10Z

        try:
            start_dt = datetime.strptime(start_utc, "%Y-%jT%H:%M:%SZ")
        except:
            start_dt = datetime.strptime(start_utc, "%Y-%jT%H:%M:%S.%fZ")

        duration = event.split('"')[3]

        if first:

            start_ck_dt = start_dt + timedelta(minutes=-1)
            start_ck_utc = start_ck_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")

            if float(srt_angle) == 0.0:

                timeline = timeline + \
                       "      CK-144000ORIENTATION  += 'ORB_NORM'\n" + \
                       "      CK-144000START        += {}\n".format(start_ck_utc)

            else:

                angles.append(srt_angle)
                roll_att = 'ROLL{}'.format(srt_angle)

                directions = directions + \
                     "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(srt_angle) + \
                     "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(srt_angle) + \
                     "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                orientations = orientations + \
                       "      \\begindata\n\n" + \
                       "         ORIENTATION_NAME += 'ROLL{}'\n".format(srt_angle) + \
                       "         PRIMARY          += '+X = TOSUN'\n" + \
                       "         SECONDARY        += '+Z = ROT{}'\n".format(srt_angle) + \
                       "         BASE_FRAME       += 'J2000'\n\n" + \
                       "      \\begintext\n\n\n"

                timeline = timeline +\
                           "      CK-144000ORIENTATION  += '{}'\n".format(roll_att) + \
                           "      CK-144000START        += {}\n".format(start_ck_utc)

        if event_type == 'ROLL':

            if float(end_angle) != 0.0:

                if end_angle not in angles:
                    directions = directions + \
                        "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(end_angle) + \
                        "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(end_angle) + \
                        "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                    orientations = orientations + \
                        "      \\begindata\n\n" + \
                        "         ORIENTATION_NAME += 'ROLL{}'\n".format(end_angle) + \
                        "         PRIMARY          += '+X = TOSUN'\n" + \
                        "         SECONDARY        += '+Z = ROT{}'\n".format(end_angle) + \
                        "         BASE_FRAME       += 'J2000'\n\n" + \
                        "      \\begintext\n\n\n"

                start_cal_angle = 'ROLL{}'.format(end_angle)
            else:
                start_cal_angle = 'ORB_NORM'


            start_roll_dt = start_dt
            start_roll_utc = start_roll_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
            timeline = timeline + \
                       "      CK-144000STOP         += {}\n\n".format(start_roll_utc)

            finish_roll_dt = start_dt + timedelta(seconds=float(duration))
            start_roll_utc = finish_roll_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
            timeline = timeline + \
                   "      CK-144000ORIENTATION  += '{}'\n".format(start_cal_angle) + \
                   "      CK-144000START        += {}\n".format(start_roll_utc)

            first = False
            angles.append(end_angle)
            prev_end_angle = end_angle

        #
        # Here we implement the Calibration Roll
        #
        else:
            start_cal_angle = 0.0
            if prev_end_angle:
                start_cal_angle += float(prev_end_angle)

            n_rotations = int(kernel.config['calibration_rotations'])
            if kernel.input_type == 'EVENTS' and 'EFECS' in kernel.source:
                n_rotations = int(event.split('"')[5])
            rotation_duration = float(duration) / float(n_rotations)

            for number in range(n_rotations):

                if number == 0:

                    if start_cal_angle != 0.0 and start_cal_angle not in angles:


                        angles.append(start_cal_angle)
                        start_roll_att = 'ROLL{}'.format(srt_angle)

                        directions = directions + \
                                 "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(srt_angle) + \
                                 "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(srt_angle) + \
                                 "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                        orientations = orientations + \
                                   "      \\begindata\n\n" + \
                                   "         ORIENTATION_NAME += '{}'\n".format(start_roll_att) + \
                                   "         PRIMARY          += '+X = TOSUN'\n" + \
                                   "         SECONDARY        += '+Z = ROT{}'\n".format(srt_angle) + \
                                   "         BASE_FRAME       += 'J2000'\n\n" + \
                                   "      \\begintext\n\n\n"
                    else:
                        start_roll_att = 'ORB_NORM'

                    cal_angle = start_cal_angle
                    cal_dt = start_dt
                    start_roll_dt = start_dt
                    start_roll_utc = start_roll_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
                    cal_utc = start_roll_utc
                    timeline = timeline + \
                               "      CK-144000STOP         += {}\n\n".format(start_roll_utc)

                cal_angle += 90
                if cal_angle > 360:
                    cal_angle -= 360

                if cal_angle not in angles:
                    directions = directions + \
                         "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(str(cal_angle).split('.')[0]) + \
                         "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(cal_angle) + \
                         "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                    orientations = orientations + \
                           "      \\begindata\n\n" + \
                           "         ORIENTATION_NAME += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         PRIMARY          += '+X = TOSUN'\n" + \
                           "         SECONDARY        += '+Z = ROT{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         BASE_FRAME       += 'J2000'\n\n" + \
                           "      \\begintext\n\n\n"

                    angles.append(cal_angle)

                previous_cal_utc = cal_utc
                cal_dt += timedelta(seconds=rotation_duration/4.)
                cal_utc = cal_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
                timeline = timeline + \
                       "      CK-144000ORIENTATION  += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                       "      CK-144000START        += {}\n".format(previous_cal_utc) + \
                       "      CK-144000STOP         += {}\n\n".format(cal_utc)

                cal_angle += 90
                if cal_angle > 360:
                    cal_angle -= 360

                if cal_angle not in angles:
                    directions = directions + \
                         "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(str(cal_angle).split('.')[0]) + \
                         "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(cal_angle) + \
                         "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                    orientations = orientations + \
                           "      \\begindata\n\n" + \
                           "         ORIENTATION_NAME += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         PRIMARY          += '+X = TOSUN'\n" + \
                           "         SECONDARY        += '+Z = ROT{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         BASE_FRAME       += 'J2000'\n\n" + \
                           "      \\begintext\n\n\n"

                    angles.append(cal_angle)

                previous_cal_utc = cal_utc
                cal_dt += timedelta(seconds=rotation_duration/4.)
                cal_utc = cal_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
                timeline = timeline + \
                       "      CK-144000ORIENTATION  += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                       "      CK-144000START        += {}\n".format(previous_cal_utc) + \
                       "      CK-144000STOP         += {}\n\n".format(cal_utc)

                cal_angle += 90
                if cal_angle > 360:
                    cal_angle -= 360

                if cal_angle not in angles:
                    directions = directions + \
                         "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(str(cal_angle).split('.')[0]) + \
                         "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(cal_angle) + \
                         "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                    orientations = orientations + \
                           "      \\begindata\n\n" + \
                           "         ORIENTATION_NAME += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         PRIMARY          += '+X = TOSUN'\n" + \
                           "         SECONDARY        += '+Z = ROT{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         BASE_FRAME       += 'J2000'\n\n" + \
                           "      \\begintext\n\n\n"

                    angles.append(cal_angle)

                previous_cal_utc = cal_utc
                cal_dt += timedelta(seconds=rotation_duration/4.)
                cal_utc = cal_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
                timeline = timeline + \
                       "      CK-144000ORIENTATION  += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                       "      CK-144000START        += {}\n".format(previous_cal_utc) + \
                       "      CK-144000STOP         += {}\n\n".format(cal_utc)

                cal_angle += 90
                if cal_angle > 360:
                    cal_angle -= 360

                if cal_angle not in angles:
                    directions = directions + \
                         "         DIRECTION_SPECS +=  ('ROT{}      =  ROTATE CROSS     -')\n".format(str(cal_angle).split('.')[0]) + \
                         "         DIRECTION_SPECS +=  ('{} DEGREES                     -')\n".format(cal_angle) + \
                         "         DIRECTION_SPECS +=  ('ABOUT TOSUN'                     )\n\n"

                    orientations = orientations + \
                           "      \\begindata\n\n" + \
                           "         ORIENTATION_NAME += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         PRIMARY          += '+X = TOSUN'\n" + \
                           "         SECONDARY        += '+Z = ROT{}'\n".format(str(cal_angle).split('.')[0]) + \
                           "         BASE_FRAME       += 'J2000'\n\n" + \
                           "      \\begintext\n\n\n"

                    angles.append(cal_angle)

                previous_cal_utc = cal_utc
                cal_dt += timedelta(seconds=rotation_duration/4.)
                cal_utc = cal_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")
                timeline = timeline + \
                       "      CK-144000ORIENTATION  += 'ROLL{}'\n".format(str(cal_angle).split('.')[0]) + \
                       "      CK-144000START        += {}\n".format(previous_cal_utc) + \
                       "      CK-144000STOP         += {}\n\n".format(cal_utc)


            cal_dt_end = cal_dt + timedelta(seconds=1)
            cal_utc_end = cal_dt_end.strftime("@%Y-%m-%dT%H:%M:%S.%f")
            timeline = timeline + \
                       "      CK-144000ORIENTATION  += '{}'\n".format(start_roll_att) + \
                       "      CK-144000START        += {}\n".format(cal_utc_end)

            first = False
            previous_event = True

            #
            # Just in case this is the last event we need to update the
            # start_roll_utc for the last entry in the timeline string
            # at the end of the loop.
            #
            start_roll_dt = cal_dt_end + timedelta(seconds=60*60)
            start_roll_utc = start_roll_dt.strftime("@%Y-%m-%dT%H:%M:%S.%f")

            #
            # Just in case the calib roll is the first event
            #
            end_angle = start_cal_angle


    timeline = timeline + \
                   "      CK-144000STOP         += {}\n\n".format(start_roll_utc)

    kernel.config['directions'] = directions
    kernel.config['orientations'] = orientations
    kernel.config['timeline'] = timeline

    return

#
def events_filter(path, sources):

    new_filenames = []

    for source in sources:
        if source[1]['input_type'] == 'TM_QUATERNIONS' and not 'source_list' in source[1].keys():

            source[1]['source_list'] = list()
            input_file =  path + '/' + source[0]

            dataFiles = {}
            fileHandler = open(input_file, "r", encoding='utf-8')
            listOfLines = fileHandler.readlines()
            fileHandler.close()
            #
            # Homogeneize & remove duplicate lines
            #
            listOfLines = list(map(str.strip, listOfLines))
            listOfLines = list(dict.fromkeys(listOfLines))

            first_line = True
            index = 0
            file_number = 0
            for line in listOfLines:
                if first_line:
                    file = path + '/' + source[0].split('.')[0] + '_' + '{0:03}'.format(file_number) + '__adcsng_temp.txt'
                    dataFiles[file] = []
                    first_line = False
                    if len(dataFiles) != 0 and 'EVENT' not in line:
                        dataFiles[file].append(line + '\n')
                        previous_line = line
                    elif 'EVENT' in line:
                        pass

                elif len(dataFiles[file]) == 1 and 'EVENT' in line: pass
                elif 'EVENT' not in line:
                    dataFiles[file].append(line+'\n')
                    previous_line = line
                elif 'EVENT' in line:
                    previous_time = line.split(',')[0]
                    dataFiles[file].append('{},{},{},{},{}\n'.format(previous_time,
                                                    previous_line.split(',')[1],
                                                    previous_line.split(',')[2],
                                                    previous_line.split(',')[3],
                                                    previous_line.split(',')[4]))
                    try:
                        next_line_number = index
                        next_line = listOfLines[next_line_number]
                        while 'EVENT' in next_line:
                            next_line_number += 1
                            next_line = listOfLines[next_line_number]
                        next_time = next_line.split(',')[0]

                        delta_time = int(next_time.split('/')[-1].split(':')[0]) - int(previous_time.split('/')[-1].split(':')[0])
                        if delta_time < 60:
                            dataFiles[file].append('{},{},{},{},{}\n'.format(next_time,
                                                          previous_line.split(',')[1],
                                                          previous_line.split(',')[2],
                                                          previous_line.split(',')[3],
                                                          previous_line.split(',')[4]))
                    except:
                        pass
                    first_line = True
                    file_number += 1
                index += 1

    try:
        for file in dataFiles:
            with open(file, 'w') as f:
                for line in dataFiles[file]:
                    f.write(line)
            #
            # We need to add the new source files.
            #
            source[1]['source_list'].append(file.split('/')[-1])
            new_filenames.append(file.split('/')[-1])
    except:
        return new_filenames


    return new_filenames
