import os
import re
import datetime
import glob as glob
import logging


from adcsng.utils.files import fill_template
from adcsng.utils.files import kernel_type2extension
from adcsng.core.config import get_version_number
from adcsng.core.config import get_latest_kernel
from collections import OrderedDict
import adcsng.classes.exceptions as Exceptions


def mkgen(config,
          directories,
          kernel_grammar,
          mk_type,
          mk_version =None,
          mk_path=None,
          input_kernels=None):

    setup = config['mkgen'][0]

    if setup['types'][0][mk_type][0]['mk_path']:
        path_value = mk_path
    else:
        path_value = '..'

    #
    # We parse the meta-kernel grammar to obtain the kernel grammar.
    #
    with open(kernel_grammar, 'r') as kg:
        kernel_grammar_list = []

        for line in kg:

            if line.strip() != '':
                line = line.split("\n")[0]
                kernel_grammar_list.append(line.replace('$' + path_value,
                                                        directories.kernels))

    #
    # We scan the kernel directory to obtain the list of available kernels
    # For the time being 'dsk' is not included
    #
    kernel_type_list = ['ck', 'fk', 'ik', 'lsk', 'pck', 'sclk', 'spk']

    #
    # All the files of the directory are read into a list
    #
    mkgen_kernels = []
    excluded_kernels = []

    for kernel_type in kernel_type_list:

        #
        # First we build the list of excluded kernels
        #
        for kernel_grammar in kernel_grammar_list:
            if 'exclude:' in kernel_grammar:
                excluded_kernels.append(kernel_grammar.split('exclude:')[-1])

        for kernel_grammar in kernel_grammar_list:

            mkinclude_latest = 0
            if 'date:' in kernel_grammar:
                kernel_grammar = kernel_grammar.split('date:')[-1]
                dates = True
            else:
                dates = False
                if 'latest' in kernel_grammar:
                    mkinclude_latest = int(kernel_grammar.split('latest')[1].split(':')[0])
                    kernel_grammar = kernel_grammar.split(':')[1]


            if kernel_grammar.split('.')[-1].lower() in kernel_type2extension(kernel_type):

                try:
                    latest_kernel = get_latest_kernel(kernel_type,
                                                      [directories.kernels,
                                                      directories.output],
                                                      kernel_grammar,
                                                      dates=dates,
                                                      include_latest=mkinclude_latest,
                                                      excluded_kernels=excluded_kernels,
                                                      mkgen=True)

                except:
                    latest_kernel = []

                if latest_kernel:
                    if not isinstance(latest_kernel, list):
                        latest_kernel = [latest_kernel]

                    for kernel in latest_kernel:
                        mkgen_kernels.append(kernel_type + '/' + kernel)


    #
    # We add the the manual kernels
    #
    if input_kernels:
        for kernel in input_kernels:
            mkgen_kernels.append(kernel)

    #
    # We remove duplicate entries from the kernel list (possible depending on
    # the grammar)
    #
    mkgen_kernels = list(OrderedDict.fromkeys(mkgen_kernels))

    #
    # The kernel list for the new mk is formatted accordingly
    #
    kernels = ''
    kernel_dir_name = None
    for kernel in mkgen_kernels:

        if kernel_dir_name:
            if kernel_dir_name != kernel.split('.')[1]:
                kernels += '\n'

        kernel_dir_name = kernel.split('.')[1]

        kernel_line = 27*" " + "'$" + \
                   setup['path_symbol'] + os.sep + \
                   kernel + "'" + '\n'

        if len(kernel_line.strip()) > 82:
            kernel_line = os.sep.join(kernel_line.split(os.sep)[0:-1]) + \
                          os.sep + "+'\n" + 27*" " + "'" + kernel_line.split(os.sep)[-1]

        kernels += kernel_line

    rep_dict = {}
    rep_dict['kernels'] = kernels

    #
    # We call the adcs_fill_template function to fill the MK  file template as specified in the
    #
    fill_template(template=directories.templates+'/mkgen.commnt',
                       file='temporary.tm',
                       replacements=setup)

    #
    # We need to call the function again to add the kernel files
    #
    fill_template(template='temporary.tm',
                       file='temporary.tm',
                       replacements=rep_dict)

    #
    # To compute the coverage of the meta-kernel we need to be able to load the kernel itself. This is also
    # used to validate the kernel itself. In order to do so we need to modify the PATH_VALUES of the mk
    #
    with open('temporary.tm', 'r+') as mk:
        with open('test.tm', 'w+') as f:

            for line in mk:
                if 'PATH_VALUES' in line:
                    f.write("     PATH_VALUES       = ( '" + directories.kernels + "' )")
                else:
                    f.write(line)

    #
    # To obtain the Kernel Dataset Version.
    # We parse the release notes files in the misc directory
    #
    cwd = os.getcwd()

    release_notes_path = directories.kernels + '/../misc/release_notes'

    #
    # Get the kernels of type ``type`` from the ``path``/``type`` directory.
    #
    try:
        os.chdir(release_notes_path)
        release_notes = glob.glob('*_skd_???.txt')
        os.chdir(cwd)
        release_notes.sort()
        kernel_dataset_version = release_notes.pop().split('_')[-1].split('.')[0]

    except:
        logging.error('   SPICE Kernel Dataset Version not determined (missing release_notes)')
        kernel_dataset_version = 'N/A'

    #
    # We create the dictionary to fill the missing replacements of the MK
    #
    rep_dict = {}

    dt_creation = datetime.datetime.now()

    rep_dict['status'] = setup['types'][0][mk_type][0]['status']
    rep_dict['path_value'] = path_value
    rep_dict['gen_month'] = dt_creation.strftime("%B")
    rep_dict['gen_day'] = str(dt_creation.day)
    rep_dict['gen_year'] = str(dt_creation.year)
    rep_dict['mk_version'] = mk_version
    rep_dict['adcsng_version'] = config['generic'][0]['adcsng_version']

    #
    # There is only one exception: ExoMarsRSP
    #
    if setup['mission'] == 'ExoMarsRSP':
        #
        # We obtain the SOL from the resulting interpolated OEM
        #
        sols = []
        kernels = kernels.split('\n')
        for line in kernels:
            pattern = re.compile('.+[0-9][0-9][0-9][0-9][_][v][0-9][0-9][0-9][.][b].+')
            if pattern.match(line):
                sols.append(int(line.split('_')[-2]))

        if sols:
            sol = '{0:04}'.format(max(sols))
        else:
            sol = '0000'

        rep_dict['gen_date'] = sol
        kernel_dataset_version = ''

    else:
        rep_dict['gen_date'] = str(dt_creation.year) + \
                           '{num:02d}'.format(num=dt_creation.month) + \
                           '{num:02d}'.format(num=dt_creation.day)

    rep_dict['kernel_dataset_version'] = kernel_dataset_version

    #
    # Depending on the kernel name the extension is in capital letters or not
    #
    mk_extension = 'tm'
    if setup['types'][0][mk_type][0]['filename'].isupper():
        mk_extension = mk_extension.upper()

    if kernel_dataset_version != 'N/A':
        mk_filename = setup['types'][0][mk_type][0]['filename'] + \
                  kernel_dataset_version.replace('.', '') + '_' + \
                  rep_dict['gen_date'] + '_{version}.'+ mk_extension
    else:
        mk_filename = setup['types'][0][mk_type][0]['filename'] + '.' + mk_extension

    #
    # We fix the name for ExoMarsRSP
    #
    if '__' in mk_filename:
        mk_filename = '_'.join(mk_filename.split('__'))


    version = get_version_number('mk', [directories.kernels,directories.output],
                                        mk_filename)

    #
    # We obtain the meta_kernel version
    #
    mk_filename = mk_filename.replace('{version}', version)
    rep_dict['mk_version'] = '{0:02}'.format(int(version))
    rep_dict['mk_version_text'] = '{0:03}'.format(int(version))
    rep_dict['filename'] = mk_filename

    #
    # We need to call the function again to add the kernel files
    #
    fill_template(template='temporary.tm',
                       file='temporary.tm',
                       replacements=rep_dict)




    os.rename('temporary.tm', mk_filename)
    os.remove('test.tm')

    # Should return the object not the mk_filename
    return(mk_filename)