import logging
import os
import subprocess
from datetime import datetime, timedelta

def quaternions_filter(append_bool, line, row, row_prev, index, tm_list,
                       filter_flag, sclk_fraction_prev, sclk_fraction_pprev,
                       sclk_fraction_ppprev, sclk_fraction_pppprev,sclk_initial,
                       info_quaternions):

    #
    # We add a tolerance in the SCLK fraction for it to be considered spureous.
    #
    sclk_fraction = line.split(':')[-1].split(' ')[0]

    if not sclk_fraction_pppprev:
        sclk_fraction_ppprev = 0
    if not sclk_fraction_ppprev:
        sclk_fraction_ppprev = 0
    if not sclk_fraction_pprev:
        sclk_fraction_pprev = 0
    if not sclk_fraction_prev:
        sclk_fraction_prev = 0
    if not sclk_initial:
        sclk_initial = 0

    prev = False

    tolerance = 5  # Tolerance is manually set no need for it to be a configuration item.
    threshold_prev  = abs(int(sclk_fraction) - int(sclk_fraction_prev))
    threshold_init  = abs(int(sclk_fraction) - int(sclk_initial))

    if filter_flag:

        if threshold_prev < tolerance:
            row_prev.append(row)
        elif len(row_prev) <= 5 and  threshold_init < tolerance:

            #logging.warning(f'   EM16 Quaternions Filter: Coarse quaternion: Spurious SCLK fractions before input line {index}:')
            info_quaternions += 1
            for element in row_prev:
                #logging.warning('   ' + str(element).split('\n')[0])
                tm_list.remove(element)

            filter_flag = False
            row_prev = []

            sclk_fraction_prev = sclk_fraction
            prev = True


        #
        # This is the extra filtering we add to remove single SCLK fraction differences
        #
        elif len(row_prev) == 1 and threshold_init > tolerance:
            #logging.warning(f'   EM16 Quaternions Filter: Coarse quaternion: Spurious SCLK fractions before input line {index}:')
            info_quaternions += 1
            #logging.warning('   ' + str(row_prev[0]).split('\n')[0])

            append_bool = False

            filter_flag = False
            row_prev = []

            sclk_fraction_prev = sclk_fraction
            prev = True

        else:
            row_prev = []
            filter_flag = False

    if sclk_fraction_prev and threshold_prev > tolerance and not filter_flag:
        filter_flag = True
        row_prev.append(row)

        sclk_initial = sclk_fraction_prev

    sclk_fraction_pppprev = sclk_fraction_ppprev
    sclk_fraction_ppprev = sclk_fraction_pprev
    sclk_fraction_pprev = sclk_fraction_prev
    if not prev:
        sclk_fraction_prev = sclk_fraction


    threshold_ppprev = abs(int(sclk_fraction) - int(sclk_fraction_pppprev))
    if threshold_ppprev < tolerance:
        append_bool = True


    return append_bool, line, row, row_prev, index, tm_list, filter_flag, sclk_fraction_prev, \
           sclk_fraction_pprev, sclk_fraction_ppprev, sclk_fraction_ppprev, sclk_initial, info_quaternions



def oem_to_cog(source):

    #
    # We need to negate the incoming data and convert it to KM (it is in M)
    #
    cog_list = []
    with open(source, 'r') as t:
        data_record = False
        for line in t:
            if 'META_START' in line:
                data_record = False
            if data_record:
                line_list = line.split()
                if line_list:
                    utc_time = line_list[0].split('.')[0]
                    try:
                        utc_milisec = line_list[0].split('.')[-1][0:3]
                    except:
                        utc_milisec = line_list[0].split('.')[-1]
                    utc = utc_time + '.' + f'{utc_milisec}'
                    cog_list.append(f'{utc} '
                                    f'{-0.001*float(line_list[1].replace("D","E"))} '
                                    f'{-0.001*float(line_list[2].replace("D","E"))} '
                                    f'{-0.001*float(line_list[3].replace("D","E"))} '
                                    f'0.0 0.0 0.0\n')
            if 'META_STOP' in line:
                data_record = True

    previous_time = ''
    cog_list_processed = []


    for cog in cog_list:
        if previous_time:
            current_time = cog.split()[0]
            if cog.split()[0] not in previous_time:

                #
                # We need to generate a 'zero degree interpolation' as if in a step
                # function.
                previous_dt = datetime.strptime(previous_time,"%Y-%m-%dT%H:%M:%S.%f")
                current_dt = datetime.strptime(current_time,"%Y-%m-%dT%H:%M:%S.%f")

                delta_dt = current_dt - previous_dt
                if delta_dt.seconds >= 1:
                    step_dt = current_dt - timedelta(seconds=+1)
                    step_time = step_dt.strftime("%Y-%m-%dT%H:%M:%S.%f")
                    cog_list_processed.append(f'{step_time[:-3]} '
                                              f'{previous_cog.split()[1]} '
                                              f'{previous_cog.split()[2]} '
                                              f'{previous_cog.split()[3]} '
                                              f'0.0 0.0 0.0')
                cog_list_processed.append(cog)
        previous_time = cog.split()[0]
        previous_cog = cog

    #
    # We remove duplicates, preventing duplication of variables in the loop.
    #
    previous_tim = ''
    cog_list_processed_copy = cog_list_processed.copy()
    for cog in cog_list_processed_copy:
        time = cog.split()[0]
        if previous_tim:
            if time == previous_tim:
                cog_list_processed.remove(cog)
        previous_tim = time

    return cog_list_processed