KPL/FK

BepiColombo MTM Spacecraft Frames Kernel
=============================================================================

   This frame kernel contains complete set of frame definitions for the
   BepiColombo Mercury Transfer Module Spacecraft (MTM) including
   definitions for the MTM fixed and MTM instrument frames. This
   kernel also contains NAIF ID/name mapping for the MTM science instruments
   and S/C structures (see the last section of the file).


Version and Date
-----------------------------------------------------------------------------

  Version 0.4 -- May 29, 2019 -- Marc Costa Sitja, ESAC/ESA
                                 Joe Zender, ESTEC/ESA

     MCAM reference frames updated with boresights cross checked with
     Flight Dynamics (Frank Budnik).
     Corrected Solar Array reference frames definitons and added SA IDs.

  Version 0.3 -- December 7, 2018 -- Marc Costa Sitja, ESAC/ESA

     Updated typo in MTM frames description.

  Version 0.2 -- December 4, 2018 -- Marc Costa Sitja, ESAC/ESA

     Updated MTM SCLK: MTM uses MPO to send the Housekeeping Telemetry and
     therefore uses the MPO SCLK. Corrected MTM Solar Arrays frames.

  Version 0.1 -- September 6, 2018 -- Marc Costa Sitja, ESAC/ESA

     Updated MTM ID, corrected several typos and added SEP frame.
     Added MTM diagrams. Removed MTM_MCAM_MU frame.

  Version 0.0 -- October 2, 2017 -- Michele Zusi, INAF
                                    James Windsor, ESTEC/ESA
                                    Marc Costa Sitja, ESAC/ESA

     Initial prototype release.


References
-----------------------------------------------------------------------------

   1.   ``Frames Required Reading''

   2.   ``Kernel Pool Required Reading''

   3.   ``C-Kernel Required Reading''

   4.   ``BepiColombo - System Design Description'', BC-ASD-DD-00004,
        Airbus DS GmbH, Issue 2, 29th November 2014

   5.   ``AOCS Study Assumptions for BepiColombo'', BC-ASD-TN-00051,
        Issue 11, Revision 1, Airbus DS GmbH, 3rd June 2016

   6.   ``CAM HEAD Assembly'', BC-ASD-DW-00912,  Airbus DS GmbH,
        9th September 2016

   7.   E-Mail communication ``MCAM IK'' from Joe Zender on 14th December
        2018

   8.   ``BepiColombo - SfC Monitoring Camera System Operations Overview'',
        BC-ASD-MA-00036, Issue 2, 9th March 2018

   9.  ``Alignment measurement test report'', BC-ALS-TR-00096,
         V. Cuarto, Thales Alenia Space, 12th February 2018.


Contact Information
-----------------------------------------------------------------------------

   If you have any questions regarding this file contact SPICE support at
   ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           mcosta@sciops.esa.int, esa_spice@sciops.esa.int


Implementation Notes
-----------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this frame kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool".  The SPICELIB
   routine FURNSH loads a kernel into the pool as shown below:

     FORTRAN: (SPICELIB)

       CALL FURNSH ( frame_kernel_name )

     C: (CSPICE)

       furnsh_c ( frame_kernel_name );

     IDL: (ICY)

       cspice_furnsh, frame_kernel_name

     MATLAB: (MICE)

          cspice_furnsh ( 'frame_kernel_name' )

     PYTHON: (SPICEYPY)*

          furnsh( frame_kernel_name )

   In order for a program or routine to extract data from the pool, the
   SPICELIB routines GDPOOL, GIPOOL, and GCPOOL are used.  See [2] for
   more details.

   This file was created and may be updated with a text editor or word
   processor.

   * SPICEPY is a non-official, community developed Python wrapper for the
     NAIF SPICE toolkit. Its development is managed on Github.
     It is available at: https://github.com/AndrewAnnex/SpiceyPy


BepiColombo MTM Mission NAIF ID Codes
-----------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the MTM spacecraft,
   its structures and science instruments (the keywords implementing these
   definitions are located in the section "BepiColombo Mission NAIF ID
   Codes -- Definition Section" at the end of this file):

      MTM Spacecraft and Spacecraft Structures names/IDs:

            MTM                         -652     (synonyms: BEPICOLOMBO MTM,
                                                  MERCURY TRANSFER MODULE)

            MTM_SPACECRAFT              -652000  (synonym: MTM_SC)

            MTM_SA+X                    -652010
            MTM_SA+X_GIMBAL             -652110
            MTM_SA+X_P-1                -652111
            MTM_SA+X_P-2                -652112
            MTM_SA+X_P-3                -652113
            MTM_SA+X_P-4                -652114

            MTM_SA-X                    -652013
            MTM_SA-X_GIMBAL             -652120
            MTM_SA-X_P-1                -652121
            MTM_SA-X_P-2                -652122
            MTM_SA-X_P-3                -652123
            MTM_SA-X_P-4                -652124

            MTM_SEP                     -652020
            MTM_SEPT-1                  -652021
            MTM_SEPT-2                  -652022
            MTM_SEPT-3                  -652023
            MTM_SEPT-4                  -652024

      M-CAM names/ID:

            MTM_MCAM1                   -652950
            MTM_MCAM2                   -652960
            MTM_MCAM3                   -652970


BepiColombo MTM Mission Frames
-----------------------------------------------------------------------------

   The following MTM frames are defined in this kernel file:

           Name                  Relative to           Type          NAIF ID
      ======================  =====================  ============   =========

    Spacecraft frames:
    ------------------
      MTM_SPACECRAFT           J2000                  CK              -652000
      MTM_SPACECRAFT_CRUISE    MPO_SPACECRAFT         CK              -652001

      MTM_SA+X_ZERO            MTM_SPACECRAFT         FIXED           -652010
      MTM_SA+X                 MTM_SA+X_ZERO          CK              -652011
      MTM_SA-Y_ZERO            MTM_SPACECRAFT         FIXED           -652012
      MTM_SA-X                 MTM_SA-X_ZERO          CK              -652013

      MTM_SEP                  J2000                  CK              -652020
      MTM_SEPT-1               MTM_SPACECRAFT         FIXED           -652021
      MTM_SEPT-2               MTM_SPACECRAFT         FIXED           -652022
      MTM_SEPT-3               MTM_SPACECRAFT         FIXED           -652023
      MTM_SEPT-4               MTM_SPACECRAFT         FIXED           -652024

    MCAM Frames:
    ------------------
      MTM_MCAM1                MTM_SPACECRAFT         FIXED           -652950
      MTM_MCAM2                MTM_SPACECRAFT         FIXED           -652960
      MTM_MCAM3                MTM_SPACECRAFT         FIXED           -652970
      MTM_MCAM_MU              MTM_SPACECRAFT         FIXED           -652980

   SPICE 'Built-in' PCK frames in use by BepiColombo (3):
   ------------------------------------------------------
      IAU_MERCURY             J2000                  PCK            built-in
      IAU_EARTH               J2000                  PCK            built-in
      IAU_VENUS               J2000                  PCK            built-in

      (3) Data for these frames is loaded using either the PCK file
          "pckVVVVV.tpc" (VVVVV is the version number)


BepiColombo MTM Frames Hierarchy
-----------------------------------------------------------------------------

  The diagram below shows the BepiColombo MTM spacecraft and its structures
  frame hierarchy:


     BC_MME_IAU2006_OF_DATE
     ----------------------
          ^
          |   BC_MME_IAU2006_J2000
          |   --------------------
          |      ^
          |      |  BC_MME_IAU2009_OF_DATE                     BC_MERCURY_BSM
          |      |  ----------------------                     --------------
          |      |      ^                                             ^
          |      |      |    BC_MME_IAU2009_J2000   MERCURY_SUN_ORB   |
          |      |      |    --------------------   ---------------   |
          |      |      |      ^                        ^             |
          |      |      |      |                        |             |
     dyn->| fxd->| dyn->| fxd->|                   dyn->|        dyn->|
          |      |      |      |                        |             |
          |      |      |      |  J2000" INERTIAL       |             |
          +-----------------------------------------------------------+
          |             |               |          |                  |
          |<-pck        |<-ck           |<-ck      |<-pck             |<-pck
          |             |               |          |                  |
          V             |               |          V                  V
     "IAU_MERCURY"      |               |     "IAU_EARTH"       "IAU_VENUS"
     -------------      |               |     -----------        ----------
                        v               |
                    "MTM_SEP"           |
                    ---------           V
                                "MTM_SPACECRAFT"
          +---------------------------------------------------------------+
          |              |                |   |   |           |   |   |   |
          |<-fixed       |<-fixed  fixed->|   |   |    fixed->|   |   |   |
          |              |                |   |   |           |   |   |   |
          v              |                v   |   |           v   |   |   |
  "MTM_SA+X_ZERO"        |       "MTM_MCAM1"  |   |  "MTM_SEPT-1" |   |   |
  ---------------        |       -----------  |   |  ------------ |   |   |
          |              |                    |   |               |   |   |
          |<-ck          v             fixed->|   |        fixed->|   |   |
          |      "MTM_SA-X_ZERO"              |   |               |   |   |
          v      ---------------              v   |               v   |   |
     "MTM_SA+X"          |           "MTM_MCAM2"  |      "MTM_SEPT-2" |   |
     ----------          |<-ck       -----------  |      -----------  |   |
                         |                        |                   |   |
                         v                 fixed->|            fixed->|   |
                    "MTM_SA-X"                    |                   |   |
                    ----------                    v                   v   |
                                         "MTM_MCAM3"        "MTM_SEPT-3"  |
                                         -----------         -----------  |
                                                                          |
                                                                          v
                                                                 "MTM_SEPT-4"
                                                                 ------------


MTM Spacecraft and Spacecraft Structures Frames
------------------------------------------------------------------------

   This section of the file contains the definitions of the spacecraft
   and spacecraft structures frames.

   DISCLAIMER: The origin of the frames specified in the following
   definitions are not implemented. The ``true'' origin of all frames
   is in the center of the MTM_SPACECRAFT frame, the center of which
   is defined by the position given by the SPK (ephemeris) kernel in
   use.


MTM Spacecraft Bus Frame
-----------------------------------------------------------------------------

    The MTM spacecraft frame -- MTM_SPACECRAFT --, is defined by the S/C
    design as follows [4]:

      - +Z axis is perpendicular to the launch vehicle interface plane
        and points toward the payload side; representing the spacecraft
        line of sight toward Mercury during science operation;

      - +X axis is parallel to the Solar Arrays hinges axes;

      - +Y axis completes the right-handed frame;

      - the origin of this frame is the Mercury Transfer Module/MTM interface
        point on the separation plane.

   These diagram(s) illustrate the MTM_SPACECRAFT frame:


   -Z S/C side view:
   -----------------
                                     ()
                                     ||
                                     -- -X Solar Array
                                     __
                                     ||
                                     ||
                                .    ||
                               /   '  |
                              /          '  .
                             /                 '  .
                            /       __   __         '
                           /       /  \ /  \        |
                          /  +Ysc  \__/ \__/        |
                          \    <-------x __         |
                           \       /  \|/  \        |
                            \      \__/|\__/        .
                             \         |          .
                              \   +Xsc v     .  '
                               \       .  '
                                '  '  |
                                     ||                      +Zsc is into
                                     ||                       the page.
                                     ||
                                     --

                                     --
                                     ||
                                     () +X Solar Array


   -Y S/C side view:
   -----------------
                             .------------.
                             |            |
                             '/\/\/\/\/\/\'

                              /\/\/\/\/\/\
                             |            |
                             |            | -X Solar Array
                            ================
                                \\    //
                          .------\\--//--.
                          |       \\//   |\
                          |        ()    | \
                          |              |  \
                          |--------------|   \
                          |             +Ysc |
                          |              |x------------> +Zsc
                          |              ||  |
                          |--------------||  /
                          |              || /
                          |        ()    ||/                +Ysc is into
                          |       //\\   ||                  the page.
                          '------//--\\--'v
                                //    \\  +Xsc
                            ================
                             |            |
                             |            | +X Solar Array
                              \/\/\/\/\/\/

                             /\/\/\/\/\/\/\
                             |            |
                             '------------'


   +X S/C side view:
   -----------------

                           V            V
                          .--------------.
                          |              |
                          |              |
                          |              |
                          |              |
                          |              |
                          |              |o------------> +Zsc
                          |              ||
                          | =======()=======
                          |              ||                 +Ysc is out
                          |              ||                  of the page.
                          |              ||'.
                          '--------------'|--'
                                          v
                                         +Xsc


   Since the S/C bus attitude with respect to an inertial frame is provided
   by a C-kernel (see [3] for more information), this frame is defined as
   a CK-based frame.

    \begindata

      FRAME_MTM_SPACECRAFT           = -652000
      FRAME_-652000_NAME             = 'MTM_SPACECRAFT'
      FRAME_-652000_CLASS            =  3
      FRAME_-652000_CLASS_ID         = -652000
      FRAME_-652000_CENTER           = -652
      CK_-652000_SCLK                = -121
      CK_-652000_SPK                 = -652

    \begintext


MTM Spacecraft Cruise Frame
----------------------------------------------------------------------------

    The MMO Spacecraft Cruise frame -- MMO_SPACECRAFT_CRUISE -- is a special
    frame used in cruise in order to "attach" the MTM spacecraft to MPO
    during the cruise phase, it is defined as follows (from [4]):

      - +Z axis is parallel to MPO's +Z axis;

      - +X axis is parallel to MPO's +X axis;

      - +Y axis completes the right-handed frame;

      - the origin of this frame is the Mercury Transfer Module/MPO interface
        point on the separation plane.


    This frame is defined a fixed-offset frame.

    Since the SPICE frames subsystem calls for specifying the reverse
    transformation--going from the instrument or structure frame to the
    base frame--as compared to the description given above, the order of
    rotations assigned to the TKFRAME_*_AXES keyword is also reversed
    compared to the above text, and the signs associated with the
    rotation angles assigned to the TKFRAME_*_ANGLES keyword are the
    opposite from what is written in the above text.

    \begindata

       FRAME_MTM_SPACECRAFT_CRUISE      = -652001
       FRAME_-652001_NAME               = 'MTM_SPACECRAFT_CRUISE'
       FRAME_-652001_CLASS              =  4
       FRAME_-652001_CLASS_ID           = -652001
       FRAME_-652001_CENTER             = -652
       TKFRAME_-652001_RELATIVE         = 'MPO_SPACECRAFT'
       TKFRAME_-652001_SPEC             = 'ANGLES'
       TKFRAME_-652001_UNITS            = 'DEGREES'
       TKFRAME_-652001_AXES             = (    1,     3,       1  )
       TKFRAME_-652001_ANGLES           = (  0.0,   0.0,     0.0  )

    \begintext


MTM Solar Array Frames
--------------------------------------------------------------------------

   MTM solar arrays are articulated (having one degree of freedom),
   therefore the Solar Array frames, MTM_SA+X and MTM_SA-X, are
   defined as CK frames with their orientation given relative to
   MTM_SA+X_ZERO and MTM_SA-X_ZERO respectively.

   MTM_SA+X_ZERO and MTM_SA-X_ZERO are two ``fixed-offset'' frames,
   defined with respect to MTM_SPACECRAFT, as follows:

      -  +X is parallel to the longest side of the array, positively
         oriented from the yoke to the end of the wing for SA+X and
         negatively for SA-X;

      -  +Y is anti-parallel to the spacecraft bus Zsc;

      -  +Z completes the right-handed frame.

      -  the origin of the frame is located at the yoke geometric
         center.


   Both Solar Array frames (MTM_SA+X and MTM_SA-X) are defined as
   follows:

      -  +X is parallel to the longest side of the array, positively
         oriented from the yoke to the end of the wing for SA+X and
         negatively for SA-X;

      -  +Z is normal to the solar array plane, the solar cells facing +X;

      -  +Y completes the right-handed frame;

      -  the origin of the frame is located at the yoke geometric center.


   The axis of rotation is parallel to the X axis of the spacecraft and the
   solar array frames.

   This diagram illustrates the MTM_SA+X_ZERO, MTM_SA+X, MTM_SA-X_ZERO
   and MTM_SA-X frames:


   -Y S/C side view:
   -----------------
                             .------------.
                             |            | -X Solar Array
                             '/\/\/\/\/\/\'

                              /\/\/\/+Xsa-x
                             |     ^ +Xsa-x0
                             |     |      |
                            =======|========
                                \\ |  //
                          .------\\|-//--.
                          |       \|//   |\      +Ysa-x
                          |        x-----------> +Ysa-x0
                          |              |  \
                          |----------+Xsa+x0 \
                          |        ^ +Xsa+x  |
                          |        |     |x------------> +Zsc
                          |        |     ||  |
                          |--------|-----||  /
                          |        |     || /
                          |        x-----------> +Ysa+x     +Ysc, +Ysa+x0,
                          |       //\\   ||      +Ysa+x0    +Ysa+x, +Ysa-y0
                            ================                and +Zsa-x are
                             |            |                 into the page.
                             |            |
                              \/\/\/\/\/\/

                             /\/\/\/\/\/\/\
                             |            | +X Solar Array
                             '------------'


   These sets of keywords define solar array frames:

   \begindata

      FRAME_MTM_SA+X_ZERO             = -652010
      FRAME_-652010_NAME              = 'MTM_SA+X_ZERO'
      FRAME_-652010_CLASS             =  4
      FRAME_-652010_CLASS_ID          = -652010
      FRAME_-652010_CENTER            = -652
      TKFRAME_-652010_RELATIVE        = 'MTM_SPACECRAFT'
      TKFRAME_-652010_SPEC            = 'ANGLES'
      TKFRAME_-652010_UNITS           = 'DEGREES'
      TKFRAME_-652010_AXES            = (     3,      2,     1   )
      TKFRAME_-652010_ANGLES          = (   0.0,  180.0,    90.0 )

      FRAME_MTM_SA+X                  = -652011
      FRAME_-652011_NAME              = 'MTM_SA+X'
      FRAME_-652011_CLASS             =  3
      FRAME_-652011_CLASS_ID          = -652011
      FRAME_-652011_CENTER            = -652
      CK_-652011_SCLK                 = -121
      CK_-652011_SPK                  = -652

      FRAME_MTM_SA-X_ZERO             = -652012
      FRAME_-652012_NAME              = 'MTM_SA-X_ZERO'
      FRAME_-652012_CLASS             =  4
      FRAME_-652012_CLASS_ID          = -652012
      FRAME_-652012_CENTER            = -652
      TKFRAME_-652012_RELATIVE        = 'MTM_SPACECRAFT'
      TKFRAME_-652012_SPEC            = 'ANGLES'
      TKFRAME_-652012_UNITS           = 'DEGREES'
      TKFRAME_-652012_AXES            = (    3,      2,      1   )
      TKFRAME_-652012_ANGLES          = (    0.0,  180.0,   90.0 )

      FRAME_MTM_SA-X                  = -652013
      FRAME_-652013_NAME              = 'MTM_SA-X'
      FRAME_-652013_CLASS             =  3
      FRAME_-652013_CLASS_ID          = -652013
      FRAME_-652013_CENTER            = -652
      CK_-652013_SCLK                 = -121
      CK_-652013_SPK                  = -652

   \begintext


Solar Electrical Propulsion Frames:
--------------------------------------------------------------------------

   This section describes several frames for the Solar Electrical Propulsion
   System.

   The Solar Electrical Propulsion frame -- MTM_SEP -- is aimed to provide
   a mechanism to obtain the time windows during which the Solar Electrical
   propulsion trusters are activated. This frame is defined as follows:

      - MTM_SEP is co-aligned with J2000 if the Thrusters are off.

      - MTM_SEP has a Right Ascension and Declination in J2000 according
        to the thrust direction -if the information is available, if the
        information is not available, then RA = 45 deg and DEC = 45 is used.


   In addition a reference frame is defined for each Solar Electrical
   Propulsion Thruster: MTM_SEPT-1, MTM_SEPT-2, MTM_SEPT-3. Each thruster
   is mounted individually on its own Thruster Pointing Mechanism (TPM), with
   four thrusters in total, each located at the corner of a square centred on
   the MTM_SPACECRAFT +Z axis.

   MTM_SEPT-1 is co-aligned with the MTM_SPACECRAFT reference frame whilst
   the others are rotated around the +Z axis as follows:

      SEPT-1 = 90  deg
      SEPT-3 = 180 deg
      SEPT-4 = 270 deg


   The following diagram illustrates the Solar Electrical Propulsion Frames:


   -Z S/C side view:
   -----------------
                                     ()
                                     ||
                                     -- -X Solar Array
                                     __
                                     ||
                                     ||
                                .    ||
                               / +Ys4 |    +Xs3
                              /    ^     ' ^.
                             /     |       |   ' .
                            /      |__   __|       '
                          +Xs4 <---x 4\ /3 x--> +Ys3
                          /  +Ysc  \__/ \__/        |
                          \    <-------x __         |
                           \       /2 \|/1 \        |
                           +Ys2 <---x_/|\_x---> +Xs1
                             \      |  |  |       .
                              \     |  v  |  .  '
                               +Xs2 v+Xsc v +Ys1
                                '  '  |
                                     ||                   +Zsc and +Zsi are
                                     ||                   into the page.
                                     ||
                                     --

                                     --
                                     ||
                                     () +X Solar Array


   These sets of keywords define Solar Electrical Propulsion frames:

    \begindata

      FRAME_MTM_SEP                   = -652020
      FRAME_-652020_NAME              = 'MTM_SEP'
      FRAME_-652020_CLASS             =  3
      FRAME_-652020_CLASS_ID          = -652020
      FRAME_-652020_CENTER            = -652
      CK_-652020_SCLK                 = -121
      CK_-652020_SPK                  = -652

      FRAME_MTM_SEPT-1                = -652021
      FRAME_-652021_NAME              = 'MTM_SEPT-1'
      FRAME_-652021_CLASS             =  4
      FRAME_-652021_CLASS_ID          = -652021
      FRAME_-652021_CENTER            = -652
      TKFRAME_-652021_RELATIVE        = 'MTM_SPACECRAFT'
      TKFRAME_-652021_SPEC            = 'ANGLES'
      TKFRAME_-652021_UNITS           = 'DEGREES'
      TKFRAME_-652021_AXES            = (     3,      1,     2 )
      TKFRAME_-652021_ANGLES          = ( -90.0,    0.0,   0.0 )

      FRAME_MTM_SEPT-2                = -652022
      FRAME_-652022_NAME              = 'MTM_SEPT-2'
      FRAME_-652022_CLASS             =  4
      FRAME_-652022_CLASS_ID          = -652021
      FRAME_-652022_CENTER            = -652
      TKFRAME_-652022_RELATIVE        = 'MTM_SPACECRAFT'
      TKFRAME_-652022_SPEC            = 'ANGLES'
      TKFRAME_-652022_UNITS           = 'DEGREES'
      TKFRAME_-652022_AXES            = (     3,      1,     2 )
      TKFRAME_-652023_ANGLES          = (   0.0,    0.0,   0.0 )

      FRAME_MTM_SEPT-3                = -652023
      FRAME_-652023_NAME              = 'MTM_SEPT-3'
      FRAME_-652023_CLASS             =  4
      FRAME_-652023_CLASS_ID          = -652023
      FRAME_-652023_CENTER            = -652
      TKFRAME_-652023_RELATIVE        = 'MTM_SPACECRAFT'
      TKFRAME_-652023_SPEC            = 'ANGLES'
      TKFRAME_-652023_UNITS           = 'DEGREES'
      TKFRAME_-652023_AXES            = (     3,      1,     2 )
      TKFRAME_-652023_ANGLES          = ( 180.0,    0.0,   0.0 )

      FRAME_MTM_SEPT-4                = -652024
      FRAME_-652024_NAME              = 'MTM_SEPT-4'
      FRAME_-652024_CLASS             =  4
      FRAME_-652024_CLASS_ID          = -652024
      FRAME_-652024_CENTER            = -652
      TKFRAME_-652024_RELATIVE        = 'MTM_SPACECRAFT'
      TKFRAME_-652024_SPEC            = 'ANGLES'
      TKFRAME_-652024_UNITS           = 'DEGREES'
      TKFRAME_-652024_AXES            = (     3,      1,     2 )
      TKFRAME_-652024_ANGLES          = (  90.0,    0.0,   0.0 )

    \begintext


Miniaturised Micro-Cameras Frames:
--------------------------------------------------------------------------

    The MCAM frames -- MTM_MCAM1, MTM_MCAM2 and MTM_MCAM3 -- are defined as
    follows:

      - +Z axis points along the MCAM boresight;

      - +X axis is parallel to the mounting alignment of the MCAM in the MTM
        lower tanker floor;

      - +Y axis completes the right handed frame;

      - the origin of the frame is located at the camera focal point.


   The MCAM boresights in the MTM S/C frame (MTM_SPACECRAFT) are defined as
   follows (from [6], [7] and [8]):

       - MCAM1:  ( -0.98106026,  0.08583165, -0.17364818 )
       - MCAM2:  ( -0.58256342, -0.27165378, -0.76604444 )
       - MCAM3:  (  0.45451948, -0.45451948, -0.76604444 )

   The +X axis for the MCAM frames are derived from [7] referred to the MTM S/C
   reference frame (MTM_SPACECRAFT) and are defined as follows (angles are in
   degrees):

       - MCAM1:  ( -sin(8.50),   cos(8.50),   0 )
       - MCAM2:  (  cos(75.0),   sin(75.0),   0 )
       - MCAM3:  ( -sin(45.0),   cos(45.0),   0 )

   The following diagram illustrates the MCAM imager boresights:

   -Y S/C side view:
   -----------------
                              /\/\/\/\/\/\
                            +Zmcam2 +Zmcam1
                             |   <.  ^   | -X Solar Array
                            ======='. \====
                                \\   '.\
                          .------\\--/ '\.
                          |       \\// xx|\
                          |        ()    | \
                          |              |  \
                          |--------------|   \
                          |              |   |
                          |              |x------------> +Zsc
                          |              ||  |
                          |--------------||  /
                          |              || /
                          |        ()    ||/                +Ysc is into
                          |       //\\  x||                  the page.
                          '------//--\\/-'v
                                //    /\  +Xsc
                            =========/======
                             |      V     |
                             |   +Zmcam3  | +X Solar Array
                              \/\/\/\/\/\/


   Since the SPICE frames subsystem calls for specifying the reverse
   transformation -- going from the instrument or structure frame to the base
   frame -- as compared to the description given above, the order of rotations
   assigned to the TKFRAME_*_AXES keyword is also reversed compared to the
   above text, and the signs associated with the rotation angles assigned to
   the TKFRAME_*_ANGLES keyword are the opposite from what is written in the
   above text.

   \begindata

      FRAME_MTM_MCAM1                  =  -652950
      FRAME_-652950_NAME               = 'MTM_MCAM1'
      FRAME_-652950_CLASS              =  4
      FRAME_-652950_CLASS_ID           =  -652950
      FRAME_-652950_CENTER             =  -652
      TKFRAME_-652950_RELATIVE         = 'MTM_SPACECRAFT'
      TKFRAME_-652950_SPEC             = 'ANGLES'
      TKFRAME_-652950_UNITS            = 'DEGREES'
      TKFRAME_-652950_ANGLES           = (
                      153.6975142726667, 78.83104707509644, -115.19074964635473
                                         )
      TKFRAME_-652950_AXES             = ( 1,    2,   3   )

      FRAME_MTM_MCAM2                  =  -652960
      FRAME_-652960_NAME               = 'MTM_MCAM2'
      FRAME_-652960_CLASS              =  4
      FRAME_-652960_CLASS_ID           =  -652960
      FRAME_-652960_CENTER             =  -652
      TKFRAME_-652960_RELATIVE         = 'MTM_SPACECRAFT'
      TKFRAME_-652960_SPEC             = 'ANGLES'
      TKFRAME_-652960_UNITS            = 'DEGREES'
      TKFRAME_-652960_ANGLES           = (
                     -160.47453536321837, 35.63104269332954, 30.03854769076893
                                         )
      TKFRAME_-652960_AXES             = ( 1,    2,   3   )

      FRAME_MTM_MCAM3                  =  -652970
      FRAME_-652970_NAME               = 'MTM_MCAM3'
      FRAME_-652970_CLASS              =  4
      FRAME_-652970_CLASS_ID           =  -652970
      FRAME_-652970_CENTER             =  -652
      TKFRAME_-652970_RELATIVE         = 'MTM_SPACECRAFT'
      TKFRAME_-652970_SPEC             = 'ANGLES'
      TKFRAME_-652970_UNITS            = 'DEGREES'
      TKFRAME_-652970_ANGLES           = (
                 -149.31794359241158, -27.034020997552087, -149.24307348039397
                                         )
      TKFRAME_-652970_AXES             = ( 1,    2,   3   )

   \begintext


BEPICOLOMBO MTM NAIF ID Codes to Name Mapping
------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for the BepiColombo MTM
   mission. Once the contents of this file is loaded into the KERNEL POOL,
   these mappings become available within SPICE, making it possible to use
   names instead of ID code in the high level SPICE routine calls.

  Spacecraft:
  ----------------------------------------------------------------

      This table presents the BepiColombo Spacecraft and its main
      structures' names and

      ---------------------  -------  --------------------------
       Name                   ID       Synonyms
      ---------------------  -------  --------------------------
       MTM                      -652   BEPICOLOMBO MTM,
                                       MERCURY TRANSFER MODLE
       MTM_SPACECRAFT        -652000   MTM_SC

       MTM_SA+X              -652010
       MTM_SA+X_GIMBAL       -652110
       MTM_SA+X_P-1          -652111
       MTM_SA+X_P-2          -652112
       MTM_SA+X_P-3          -652113
       MTM_SA+X_P-4          -652114

       MTM_SA-X               -652013
       MTM_SA-X_GIMBAL        -652120
       MTM_SA+X_P-1           -652121
       MTM_SA+X_P-2           -652122
       MTM_SA+X_P-3           -652123
       MTM_SA+X_P-4           -652124


       MTM_SEP               -652020
       MTM_SEPT-1            -652021
       MTM_SEPT-2            -652022
       MTM_SEPT-3            -652023
       MTM_SEPT-4            -652024
      ---------------------  -------  --------------------------

      Notes:

         -- 'MTM', 'BEPICOLOMBO MTM' and 'MERCURY TRANSFER MODULE' are
            synonyms and all map to the BepiColombo MTM spacecraft ID (-652);

         -- 'MTM_SC' and 'MTM_SPACECRAFT' are synonyms and all map to the
            BepiColombo MTM S/C bus structure ID (-652000);

      \begindata

         NAIF_BODY_NAME += ( 'MTM'                             )
         NAIF_BODY_CODE += ( -652                              )

         NAIF_BODY_NAME += ( 'BEPICOLOMBO MTM'                 )
         NAIF_BODY_CODE += ( -652                              )

         NAIF_BODY_NAME += ( 'MERCURY TRANSFER MODULE'         )
         NAIF_BODY_CODE += ( -652                              )

         NAIF_BODY_NAME += ( 'MTM_SC'                          )
         NAIF_BODY_CODE += ( -652000                           )

         NAIF_BODY_NAME += ( 'MTM_SPACECRAFT'                  )
         NAIF_BODY_CODE += ( -652000                           )

         NAIF_BODY_NAME += ( 'MTM_SA+X'                        )
         NAIF_BODY_CODE += ( -652010                           )

         NAIF_BODY_NAME += ( 'MTM_SA+X_GIMBAL'                 )
         NAIF_BODY_CODE += ( -652110                           )

         NAIF_BODY_NAME += ( 'MTM_SA+X_P-1'                    )
         NAIF_BODY_CODE += ( -652111                           )

         NAIF_BODY_NAME += ( 'MTM_SA+X_P-2'                    )
         NAIF_BODY_CODE += ( -652112                           )

         NAIF_BODY_NAME += ( 'MTM_SA+X_P-3'                    )
         NAIF_BODY_CODE += ( -652113                           )

         NAIF_BODY_NAME += ( 'MTM_SA+X_P-4'                    )
         NAIF_BODY_CODE += ( -652114                           )

         NAIF_BODY_NAME += ( 'MTM_SA-X'                        )
         NAIF_BODY_CODE += ( -652013                           )

         NAIF_BODY_NAME += ( 'MTM_SA-X_GIMBAL'                 )
         NAIF_BODY_CODE += ( -652120                           )

         NAIF_BODY_NAME += ( 'MTM_SA-X_P-1'                    )
         NAIF_BODY_CODE += ( -652121                           )

         NAIF_BODY_NAME += ( 'MTM_SA-X_P-2'                    )
         NAIF_BODY_CODE += ( -652122                           )

         NAIF_BODY_NAME += ( 'MTM_SA-X_P-3'                    )
         NAIF_BODY_CODE += ( -652123                           )

         NAIF_BODY_NAME += ( 'MTM_SA-X_P-4'                    )
         NAIF_BODY_CODE += ( -652124                           )

         NAIF_BODY_NAME += ( 'MTM_SEP'                         )
         NAIF_BODY_CODE += ( -652020                           )

         NAIF_BODY_NAME += ( 'MTM_SEPT-1'                      )
         NAIF_BODY_CODE += ( -652021                           )

         NAIF_BODY_NAME += ( 'MTM_SEPT-2'                      )
         NAIF_BODY_CODE += ( -652022                           )

         NAIF_BODY_NAME += ( 'MTM_SEPT-3'                      )
         NAIF_BODY_CODE += ( -652023                           )

         NAIF_BODY_NAME += ( 'MTM_SEPT-4'                      )
         NAIF_BODY_CODE += ( -652024                           )

      \begintext

  MCAM:
  ----------------------------------------------------------------

     This table summarizes MCAMs IDs:

      -------------------------   --------
       Name                        ID
      -------------------------   --------
       MTM_MCAM1                   -652950
       MTM_MCAM2                   -652960
       MTM_MCAM3                   -652970
      -------------------------   --------

     Name-ID Mapping keywords:

      \begindata

        NAIF_BODY_NAME   += ( 'MTM_MCAM1'                 )
        NAIF_BODY_CODE   += ( -652950                     )

        NAIF_BODY_NAME   += ( 'MTM_MCAM2'                 )
        NAIF_BODY_CODE   += ( -652960                     )

        NAIF_BODY_NAME   += ( 'MTM_MCAM3'                 )
        NAIF_BODY_CODE   += ( -652970                     )

      \begintext


End of FK file.