C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C
C     Initialize an object list.
C
      SUBROUTINE OBJINL ( OBJSIZ, NOBJ, OBJLIS )
      IMPLICIT NONE
 
      INCLUDE              'object.inc'
 
      INTEGER               OBJLIS ( LBCELL : * )
      INTEGER               OBJSIZ
      INTEGER               NOBJ
 
C
C     Each object has an extra space that specifies
C     the objects id-code and status.  The object
C     is "active" if the extra-space has a non-null
C     value.
C
      INTEGER               ROOM
      INTEGER               MTASIZ
      INTEGER               I
      INTEGER               J
C
C     Compute the number of slots required to store NOBJ objects
C     each of size OBJSIZ.  Recall that each object has an
C     extra "ID" slot.
C
      ROOM   = ( OBJSIZ + 1 ) * NOBJ
      MTASIZ =   OBJSIZ + 1
C
C     Set the size of the cell
C
      CALL SSIZEI ( ROOM, OBJLIS )
C
C     Fill in the extra slots of the cell used by the objects.
C
      OBJLIS ( RMPOBJ ) = MTASIZ
      OBJLIS ( NACTIV ) = 0
      OBJLIS ( LSTID  ) = 0
C
C     Set each object to have a NULL ID code.
C
      DO I = 1, NOBJ
         J         = (I-1)*MTASIZ + 1
         OBJLIS(J) =  NULL
      END DO
 
      RETURN
      END
