import os
import logging

from datetime import date
from tempfile import mkstemp
from shutil import move
from os import remove, close

def get_filepaths(directory):
    """
    This function will generate the file names in a directory
    tree by walking the tree either top-down or bottom-up. For each
    directory in the tree rooted at directory top (including top itself),
    it yields a 3-tuple (dirpath, dirnames, filenames).
    """
    file_paths = []  # List which will store all of the full filepaths.

    # Walk the tree.
    for root, directories, files in os.walk(directory):
        for filename in files:
            # Join the two strings in order to form the full filepath.
            filepath = os.path.join(root, filename)
            file_paths.append(filepath)  # Add it to the list.

    return file_paths  # Self-explanatory.


def arcgen_add_cr_to_files(working_directory,
                           reference_date,
                           ):

    full_file_paths = get_filepaths(working_directory)
    non_kernel_file_types = ['LBL','TXT','CAT','HTM','TAB']

    reference_dt = date( int(reference_date.split('-')[0]),
                         int(reference_date.split('-')[1]),
                         int(reference_date.split('-')[2]),
                       )

    for file in full_file_paths:

        dt = date.fromtimestamp(os.path.getmtime(file))
        logging.info(f'{file} {dt}')

        if dt > reference_dt:

            if file.split('.')[-1] in non_kernel_file_types:

                logging.info(f'Adding CR to {file}')
                # Create temp file
                fh, abs_path = mkstemp()

                with open(abs_path, 'w') as new_file:

                    with open(file) as old_file:

                        for line in old_file:
                            if '\r\n' not in line:
                                new_file.write(line.replace('\n', '\r\n'))
                            else: print('Line already had CR')

                close(fh)

                # Remove original file
                remove(file)

                # Move new file
                move(abs_path, file)


working_directory = '/Users/mcosta/Dropbox/SPICE/SPICE_ARCGEN/datasets/ROSETTA/RO-RL-E-M-A-C-SPICE-6-V1.0_rel0004'

arcgen_add_cr_to_files( working_directory=working_directory,
                        reference_date='2016-07-01',
                      )



