#!/bin/tcsh

#
# This script fixes target name for target-specific kernels.
#

cd /usr1/rosetta/RO_RL-E_M_A_C-SPICE-6-V1.0

foreach PAIR ( \
"NA    DATA/CK/ATNR_P040302093352_00046.LBL" \
"NA    DATA/CK/ATNR_P040302093352_00096.LBL" \
"NA    DATA/CK/ATNR_P040302093352_00109.LBL" \
"NA    DATA/CK/ATNR_P040302093352_00127.LBL" \
" CG   DATA/CK/CATT_DV_145_01_______00216.LBL" \
"NA    DATA/CK/RATT_DV_145_01_01____00216.LBL" \
"NA    DATA/CK/ROS_HGA_2004_V0001.LBL" \
"NA    DATA/CK/ROS_HGA_2005_V0001.LBL" \
"NA    DATA/CK/ROS_HGA_2006_V0001.LBL" \
"NA    DATA/CK/ROS_HGA_2007_V0001.LBL" \
"NA    DATA/CK/ROS_HGA_2008_V0018.LBL" \
"NA    DATA/CK/ROS_HGA_2008_V0019.LBL" \
"NA    DATA/CK/ROS_HGA_2009_V0051.LBL" \
"NA    DATA/CK/ROS_HGA_2009_V0052.LBL" \
"NA    DATA/CK/ROS_HGA_2010_V0042.LBL" \
"NA    DATA/CK/ROS_HGA_2010_V0046.LBL" \
"NA    DATA/CK/ROS_HGA_2011_V0018.LBL" \
"NA    DATA/CK/ROS_HGA_2014_V0044.LBL" \
"NA    DATA/CK/ROS_HGA_2015_V0038.LBL" \
"NA    DATA/CK/ROS_LBOOM_V0.LBL" \
"NA    DATA/CK/ROS_SA_2004_V0001.LBL" \
"NA    DATA/CK/ROS_SA_2005_V0001.LBL" \
"NA    DATA/CK/ROS_SA_2006_V0001.LBL" \
"NA    DATA/CK/ROS_SA_2007_V0001.LBL" \
"NA    DATA/CK/ROS_SA_2008_V0038.LBL" \
"NA    DATA/CK/ROS_SA_2009_V0054.LBL" \
"NA    DATA/CK/ROS_SA_2010_V0043.LBL" \
"NA    DATA/CK/ROS_SA_2010_V0052.LBL" \
"NA    DATA/CK/ROS_SA_2011_V0020.LBL" \
"NA    DATA/CK/ROS_SA_2014_V0047.LBL" \
"NA    DATA/CK/ROS_SA_2015_V0037.LBL" \
"NA    DATA/CK/ROS_VIRTIS_M_0403_1509_V1.LBL" \
"NA    DATA/CK/ROS_VIRTIS_ZERO_V1.LBL" \
"NA    DATA/FK/EARTHFIXEDIAU.LBL" \
"NA    DATA/FK/EARTHFIXEDITRF93.LBL" \
"NA    DATA/FK/EARTH_TOPO_050714.LBL" \
"NA    DATA/FK/ESTRACK_V01.LBL" \
"NA    DATA/FK/NEW_NORCIA_TOPO.LBL" \
"  LU  DATA/FK/ROS_LUTETIA_RSOC_V02.LBL" \
"  LU  DATA/FK/ROS_LUTETIA_RSOC_V03.LBL" \
"NA    DATA/FK/ROS_V12.LBL" \
"NA    DATA/FK/ROS_V16.LBL" \
"NA    DATA/FK/ROS_V17.LBL" \
"NA    DATA/FK/ROS_V25.LBL" \
"NA    DATA/FK/RSSD0001.LBL" \
"NA    DATA/FK/RSSD0002.LBL" \
"NA    DATA/IK/ROS_ALICE_V12.LBL" \
"NA    DATA/IK/ROS_ALICE_V15.LBL" \
"NA    DATA/IK/ROS_ALICE_V16.LBL" \
"NA    DATA/IK/ROS_CIVA_V10.LBL" \
"NA    DATA/IK/ROS_CONSERT_V10.LBL" \
"NA    DATA/IK/ROS_COSIMA_V13.LBL" \
"NA    DATA/IK/ROS_DIM_V10.LBL" \
"NA    DATA/IK/ROS_GIADA_V11.LBL" \
"NA    DATA/IK/ROS_MIDAS_V10.LBL" \
"NA    DATA/IK/ROS_MIRO_V10.LBL" \
"NA    DATA/IK/ROS_NAVCAM_V01.LBL" \
"NA    DATA/IK/ROS_OSIRIS_V10.LBL" \
"NA    DATA/IK/ROS_OSIRIS_V11.LBL" \
"NA    DATA/IK/ROS_OSIRIS_V12.LBL" \
"NA    DATA/IK/ROS_ROLIS_V03.LBL" \
"NA    DATA/IK/ROS_ROSINA_V10.LBL" \
"NA    DATA/IK/ROS_ROSINA_V11.LBL" \
"NA    DATA/IK/ROS_RPC_V15.LBL" \
"NA    DATA/IK/ROS_RPC_V17.LBL" \
"NA    DATA/IK/ROS_STR_V10.LBL" \
"NA    DATA/IK/ROS_VIRTIS_V11.LBL" \
"NA    DATA/IK/ROS_VIRTIS_V12.LBL" \
"NA    DATA/IK/ROS_VIRTIS_V13.LBL" \
"NA    DATA/LSK/NAIF0008.LBL" \
"NA    DATA/LSK/NAIF0009.LBL" \
"NA    DATA/LSK/NAIF0011.LBL" \
"NA    DATA/PCK/DE403_MASSES.LBL" \
"NA    DATA/PCK/EARTH_000101_070916_070625.LBL" \
"NA    DATA/PCK/EARTH_000101_100428_100204.LBL" \
"NA    DATA/PCK/EARTH_000101_110111_101020.LBL" \
"NA    DATA/PCK/EARTH_000101_120117_111026.LBL" \
"NA    DATA/PCK/EARTH_000101_160131_151109.LBL" \
"NA    DATA/PCK/PCK00008.LBL" \
"NA    DATA/PCK/PCK00010.LBL" \
" CG   DATA/PCK/ROS_CGS_RSOC_V01.LBL" \
" CG   DATA/PCK/ROS_CG_RAD_V10.LBL" \
" CG   DATA/PCK/ROS_CG_ROT_1408_1409_V10.LBL" \
"  LU  DATA/PCK/ROS_LUTETIA_LC1_V02.LBL" \
"  LU  DATA/PCK/ROS_LUTETIA_LC2_V02.LBL" \
"  LU  DATA/PCK/ROS_LUTETIA_R1_V02.LBL" \
"  LU  DATA/PCK/ROS_LUTETIA_R2_V02.LBL" \
"  LU  DATA/PCK/ROS_LUTETIA_RSOC_V01.LBL" \
"  LU  DATA/PCK/ROS_LUTETIA_RSOC_V03.LBL" \
"   ST DATA/PCK/ROS_STEINS_V03.LBL" \
"   ST DATA/PCK/ROS_STEINS_V04.LBL" \
"   ST DATA/PCK/ROS_STEINS_V05.LBL" \
"NA    DATA/SCLK/ROS_061208_STEP.LBL" \
"NA    DATA/SCLK/ROS_091210_STEP.LBL" \
"NA    DATA/SCLK/ROS_100617_STEP.LBL" \
"NA    DATA/SCLK/ROS_110405_STEP.LBL" \
"NA    DATA/SCLK/ROS_150908_STEP.LBL" \
"  LU  DATA/SPK/21_LUTETIA_2004_2016.LBL" \
"   ST DATA/SPK/2867_STEINS_2004_2016.LBL" \
" CG   DATA/SPK/67P_CHURY_GERAS_2004_2016.LBL" \
" CG   DATA/SPK/CORB_DV_145_01_______00216.LBL" \
"NA    DATA/SPK/DE405.LBL" \
"NA    DATA/SPK/EARTHSTNS_FX_050714.LBL" \
"NA    DATA/SPK/EARTHSTNS_ITRF93_050714.LBL" \
"NA    DATA/SPK/ESTRACK_V01.LBL" \
"NA    DATA/SPK/LORB_DV_145_01_______00216.LBL" \
"NA    DATA/SPK/NEW_NORCIA.LBL" \
"NA    DATA/SPK/ORER_______________00031.LBL" \
"NA    DATA/SPK/ORFR_______________00067.LBL" \
"NA    DATA/SPK/ORGR_______________00096.LBL" \
"   ST DATA/SPK/ORHO_______________00077.LBL" \
"NA    DATA/SPK/ORHR_______________00047.LBL" \
"NA    DATA/SPK/ORHR_______________00096.LBL" \
"NA    DATA/SPK/ORHR_______________00109.LBL" \
"NA    DATA/SPK/ORHR_______________00122.LBL" \
"  LU  DATA/SPK/ORHS_______________00109.LBL" \
" CG   DATA/SPK/ORHW_______________00016.LBL" \
" CG   DATA/SPK/ORHW_______________00122.LBL" \
"NA    DATA/SPK/ORMR_______________00052.LBL" \
"NA    DATA/SPK/OUTERPLANETS_V0002.LBL" \
"NA    DATA/SPK/RORB_DV_145_01_______00216.LBL" \
"NA    DATA/SPK/ROS_STRUCT_V1.LBL" \
"NA    DATA/SPK/ROS_STRUCT_V2.LBL" \
"NA    DATA/SPK/ROS_STRUCT_V5.LBL" \
"   TE DATA/SPK/TEMPEL1_9P_DI_P.LBL" \
)
    set ITEM = ( $PAIR )
    set TAG  = $ITEM[1]
    set LBL  = $ITEM[2]

    if      ( $TAG == "CG" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/TARGET_NAME                  = "N\/A"/TARGET_NAME                  = "67P\/CHURYUMOV-GERASIMENKO 1 (1969 R1)"/' \
            > $LBL.new

    else if ( $TAG == "LU" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/TARGET_NAME                  = "N\/A"/TARGET_NAME                  = "21 LUTETIA"/' \
            > $LBL.new

    else if ( $TAG == "ST" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/TARGET_NAME                  = "N\/A"/TARGET_NAME                  = "2867 STEINS"/' \
            > $LBL.new

    else if ( $TAG == "TE" ) then

	grep -v DATA_SET_NAME $LBL | \
            sed 's/TARGET_NAME                  = "N\/A"/TARGET_NAME                  = "9P\/TEMPEL 1 (1867 G1)"/' \
            > $LBL.new

    else if ( $TAG == "NA" ) then

	cp $LBL $LBL.new

    else
	echo
	echo ERROR: Cannot recognize $TAG.
	echo 
    endif

    echo -------------------------------------------------------- $LBL
    diff $LBL.new $LBL

end

exit
