KPL/MK

   This meta-kernel includes all SPICE kernels needed to compute cruise
   position and orientation, and rover surface position and orientation
   along with orientation of the rover structures (PMA, IDD, and HGA)
   and the camera parameters. It lists the rover and site position SPK
   file containing data based only on rover telemetry (and, therefore,
   not corrected for slippage and sliding) and gravity-compensated
   Microscopic Imager (MI) tip position SPK and MI orientation CK
   (``iddg'' files) that provide correct information ONLY at the times
   of MI images.

   All of the kernels listed below are archived in the MER2 SPICE data
   set (DATA_SET_ID = "MER2-M-SPICE-6-V1.0"). For detailed information
   about the kernels listed below refer to the internal comments
   included in the kernels and the documentation accompanying the MER2
   SPICE data set.
 
   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the MER2 SPICE data set's ``data'' directory on their
   system. Replacing ``/'' with ``\'' and converting line terminators
   to the format native to the user's system may also be required if
   this meta-kernel is to be used on a non-UNIX workstation.
 
   This file was created on March 1, 2007 by Boris Semenov, NAIF/JPL.
   The original name of this file was mer2_tlm_v01.tm.

   \begindata

      PATH_VALUES       = (
                           './data'
                          )
      PATH_SYMBOLS      = (
                           'KERNELS'
                          )
      KERNELS_TO_LOAD   = (
                          '$KERNELS/lsk/naif0008.tls'
                          '$KERNELS/pck/mars_iau2000_v0.tpc'
                          '$KERNELS/sclk/mer_254_sclkscet_00022.tsc'
                          '$KERNELS/sclk/mer2_hlst_ep55a3_v2.tsc'
                          '$KERNELS/fk/mer2_v09.tf'
                          '$KERNELS/ik/mer2_fl_20031204_c58.ti'
                          '$KERNELS/ik/mer2_fr_20031204_c59.ti'
                          '$KERNELS/ik/mer2_mi_f1_20031204_c173.ti'
                          '$KERNELS/ik/mer2_nl_20031204_c174.ti'
                          '$KERNELS/ik/mer2_nr_20031204_c175.ti'
                          '$KERNELS/ik/mer2_pl_f1_20031204_c176.ti'
                          '$KERNELS/ik/mer2_pr_f1_20031204_c184.ti'
                          '$KERNELS/ik/mer2_rl_20031204_c60.ti'
                          '$KERNELS/ik/mer2_rr_20031204_c61.ti'
                          '$KERNELS/spk/de410.bsp'
                          '$KERNELS/spk/mar033_2000_2025.bsp'
                          '$KERNELS/spk/mer2_cruise.bsp'
                          '$KERNELS/spk/mer2_ls_040108_iau2000_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_prim_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_prim_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext1_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext1_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext2_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext2_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext3_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext3_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext4_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext4_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext5_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext5_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext6_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext6_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext7_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext7_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext8_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext8_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext9_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext9_v1.bsp'
                          '$KERNELS/spk/mer2_surf_rover_ext10_v1.bsp'
                          '$KERNELS/spk/mer2_surf_iddg_ext10_v1.bsp'
                          '$KERNELS/ck/mer2_cruise.bc'
                          '$KERNELS/ck/mer2_surf_rover_prim_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_prim_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_prim_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_prim_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext1_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext1_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext1_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext1_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext2_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext2_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext2_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext2_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext3_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext3_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext3_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext3_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext4_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext4_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext4_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext4_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext5_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext5_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext5_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext5_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext6_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext6_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext6_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext6_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext7_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext7_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext7_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext7_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext8_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext8_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext8_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext8_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext9_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext9_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext9_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext9_v1.bc'
                          '$KERNELS/ck/mer2_surf_rover_ext10_v1.bc'
                          '$KERNELS/ck/mer2_surf_pma_ext10_v1.bc'
                          '$KERNELS/ck/mer2_surf_hga_ext10_v1.bc'
                          '$KERNELS/ck/mer2_surf_iddg_ext10_v1.bc'
                          )

      SPACECRAFT_ID     = -254
      CENTER_ID         = 499
      LANDING_TIME      = '2004-01-04 04:25'
      LANDING_SOL_INDEX = 1
      BODY10_GM         = 132712440035.0199

   \begintext

