KPL/FK


Stardust Frames Kernel
===============================================================================

   This frame kernel contains complete set of frame definitions for the 
   Stardust (SDU) spacecraft frames including definitions for the spacecraft
   fixed frame, antenna, star camera and science instrument frames.


Version and Date
-------------------------------------------------------------------------------

   Version 2.0 -- June 30, 2005 -- Boris Semenov

      Added name/ID pair for Sample Return Capsule (SRC) --
      SDU_SRC (synonym STARDUST_SRC)/-29900 -- so that its descent
      trajectory data can be referred to by name in SPK lookups.
      
   Version 1.9 -- March 3, 2005 -- Boris Semenov, NAIF/JPL

      Added NAIF ID <-> name mapping for the instruments, structures,
      and target bodies. Added body-fixed, PCK-based frames for the
      targets -- WILD2_FIXED and ANNEFRANK_FIXED. Corrected/augmented
      comments in a number of places to address liens from 2004
      peer-review.

   Version 1.8 -- October 7, 2003 -- Boris Semenov, NAIF/JPL

      Replaced collector frame branch with a single CK-based collector
      frame. Corrected SDU_ISP_STREAM definition: it should be w.r.t be 
      ECLIPJ2000 and use different angles as the direction specified by
      RA and DEC is the ISP "incoming" direction.

   Version 1.7 -- June 2, 2003 -- Boris Semenov, NAIF/JPL

      Added CIDA_TARGET frame. Added diagrams. Improved some comments.

   Version 1.6 -- May 25, 2001 -- Boris Semenov, NAIF/JPL

      Corrected MGA frame to add 7 degree offset (from [13]). Added
      LGA2 frame.

   Version 1.5 -- March 4, 1999 -- Boris Semenov, NAIF/JPL

      Added SDU_ISP_STREAM (InterStellar Particle Stream) frame definition
      provided by Howard Taylor, Stardust D&MA/ACT, to facilitate geometry
      computations of the geometry parameters in the DFMI PDS labels.

   Version 1.4 -- March 3, 1999 -- Boris Semenov, NAIF/JPL

      Updated SDU_NC_BASE to incorporate misalignment between the s/c 
      alignment cube and NAVCAM mounting mirror per information from 
      David Perkins.

   Version 1.3 -- February 26, 1999 -- Boris Semenov, NAIF/JPL

      The frame center ID was set to -29 in all frame definitions to make
      sure that position of the center can always be computed for a light
      time correction of the orientation of a frame.

   Version 1.2 -- January 3, 1999 -- Boris Semenov, NAIF/JPL

      The NAVCAM ``real'' frame tree frame definitions were "filled" with 
      misalignment values obtained from [8,9]. The DFMI frames were completed.

   Version 1.1 -- December 8, 1998 -- Boris Semenov, NAIF/JPL

      NAVCAM IDEAL/OPNAV Frame tree was added to accommodate Shyam's
      OPNAV camera pointing algorithm. DFMI sensor frames were added.

   Version 1.0 -- December 2, 1998 -- Boris Semenov, NAIF/JPL

      Initial Release.


References
-------------------------------------------------------------------------------

   1. Stardust Spacecraft Drawing: Fig 1-5 ``Bottom, Rear View'' (1&2);

   2. ``NC ICD'', Document SD-62200-220, Revision B, February 19, 1998;

   3. ``CIDA ICD'', Document SD-62200-230, Revision A, May 4, 1998;

   4. ``DFMI ICD'', Document SD-62200-250, Revision C, November 8, 1997;

   5. ``Frames Required Reading''

   6. ``Kernel Pool Required Reading''

   7. ``C-Kernel Required Reading''

   8. JPL IOM ``Test Report; Stardust Camera Alignment measurement'', 
      by E. Motts, May 7, 1998

   9. JPL IOM ``Addendum to Test Report; Stardust Camera Alignment 
      measurement'', by E. Motts/M. Schwochert, September 19, 1998

  10. "Alignment Summary for the Stardust Spacecraft" by Al Stoltz, 
      Precision Alignment Lab/LMA, December 7, 1998
      
  11. "Scan Mirror Optical Alignment" by David Perkins, LMA, February-
      March 1999.

  12. M. Baguhl, E. Grun, and M. Landgraf. In Situ Measurements
      of Interstellar Dust with the Ulysses and Galileo Spaceprobes,
      Space Science Reviews No. 78, pp.  165-172, 1996 
      (http://galileo.mpi-hd.mpg.de/~landgraf/)
      
  13. R.Tung, JPL Telecom Analysis. E-mail from 05/21/01.
      

Contact Information
-------------------------------------------------------------------------------

   Boris V. Semenov, NAIF/JPL, (818)-354-8136, bsemenov@spice.jpl.nasa.gov


Implementation Notes
-------------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during program
   initialization. The SPICELIB routine FURNSH loads a kernel file into the 
   pool as shown below.

      CALL FURNSH ( 'frame_kernel_name' )

   This file was created and may be updated with a text editor or word
   processor.
   

Usage Notes
-------------------------------------------------------------------------------

   If you're in a hurry and want to compute state transformation matrix 
   from a particular Stardust instrument frame to the J2000 inertial frame 
   without going through frame descriptions/definitions in this file, you 
   should:
   
      *  for the NAVCAM image frames:
      
            -- load LSK, SDU SCLK, SDU spacecraft and NAVCAM CK files;
               
            -- call SXFORM as follows:
            
                  CALL SXFORM( 'SDU_NC_IMAGE_OPNAV', 'J2000', ET, XFORM ) 
                  
         or  

            -- load LSK, SDU SCLK, SDU spacecraft and NAVCAM CK files;
               
            -- call SXFORM as follows:
            
                  CALL SXFORM( 'SDU_NC_IMAGE', 'J2000', ET, XFORM ) 
         
         depending on whether you want to use "ideal/opnav correction"
         or "real alignment" camera model. 

         In either case you need to make sure that you start with the
         SCLK value provided in the SPACECRAFT_CLOCK_START_COUNT
         keyword in a NAVCAM image label and convert this SCLK to ET
         before calling SXFORM. This is required because NAVCAM CK
         file(s) contain discrete data points "tagged" with these SCLKs
         and cannot be used to compute the camera view direction for
         any other times. Starting with UTC times from the NAVCAM
         labels will result in a small round off and the pointing will
         not be found.
                  
      *  for the DFMI frame:
      
            -- load LSK, SDU SCLK and SDU spacecraft CK files;
               
            -- call SXFORM as follows:
            
                  CALL SXFORM( 'SDU_DFMI', 'J2000', ET, XFORM ) 
                  
      
      *  for the CIDA frame:
      
            -- load LSK, SDU SCLK and SDU spacecraft CK files;
               
            -- call SXFORM as follows:
            
                  CALL SXFORM( 'SDU_CIDA', 'J2000', ET, XFORM ) 
                  
                  
SDU NAIF ID Codes
-------------------------------------------------------------------------------

   The following names and NAIF ID codes are assigned to the Stardust
   spacecraft, its structures and science instruments and targets (the
   keywords implementing these definitions are located in the section
   "SDU NAIF ID Codes -- Definition Section" at the end of this file):

   SDU Spacecraft and SRC:
   -----------------------
      SDU                        -29    (synonyms: STARDUST)
      SDU_SRC                    -29900 (synonyms: STARDUST_SRC)
      SDU_SPACECRAFT_BUS         -29000

   SDU Science Instruments:
   ------------------------
      SDU_NAVCAM                 -29010 (synonyms: SDU_NC)
      SDU_CIDA                   -29020
      SDU_DFMI                   -29030
      SDU_DUST_COLLECTOR         -29040 (synonyms: SDU_COLLECTOR)

   SDU Structures:
   ---------------
      SDU_STARCAM_A              -29110
      SDU_STARCAM_B              -29120
      SDU_HGA                    -29210
      SDU_MGA                    -29211
      SDU_LGA1                   -29212
      SDU_LGA2                   -29214
      SDU_LGA3                   -29213

   Target Bodies:
   --------------
      81P/WILD 2 (1978 A2)       1000107 (synonyms: WILD2,  WILD-2, WILD 2)
      5535 ANNEFRANK             2005535 (synonyms: ANNEFRANK)
      

SDU Frames
-------------------------------------------------------------------------------

   The following SDU frames are defined in this kernel file:

        Frame Name                    Relative to              Type    NAIF ID
   =========================     =========================    =======   =======

   Spacecraft frame:
   -----------------
      SDU_SPACECRAFT             rel.to J2000                  CK       -29000

   NAVCAM Frames (-2901x and -2909x):
   -----------------------
      SDU_NC_BASE                rel.to SPACECRAFT             FIXED    -29011
      SDU_NC_OPTICS              rel.to NC_BASE                FIXED    -29012
      SDU_NC_REFLECTION          rel.to NC_OPTICS              CK       -29013
      SDU_NC_IMAGE               rel.to NC_REFLECTION          FIXED    -29010
      SDU_NC_AXIS_STOWED         rel.to NC_BASE                FIXED    -29015
      SDU_NC_AXIS                rel.to NC_AXIS_STOWED         CK       -29016
      SDU_NC_MIRROR              rel.to NC_AXIS                FIXED    -29017
      
      SDU_NC_BASE_IDEAL          rel.to SPACECRAFT             FIXED    -29091
      SDU_NC_OPTICS_IDEAL        rel.to NC_BASE_IDEAL          FIXED    -29092
      SDU_NC_REFLECTION_IDEAL    rel.to NC_OPTICS_IDEAL        CK       -29093
      SDU_NC_IMAGE_IDEAL         rel.to NC_REFLECTION_IDEAL    FIXED    -29094
      SDU_NC_IMAGE_OPNAV         rel.to NC_IMAGE_IDEAL         CK       -29090
      SDU_NC_AXIS_STOWED_IDEAL   rel.to NC_BASE_IDEAL          FIXED    -29095
      SDU_NC_AXIS_IDEAL          rel.to NC_AXIS_STOWED_IDEAL   CK       -29096
      SDU_NC_MIRROR_IDEAL        rel.to NC_AXIS_IDEAL          FIXED    -29097
         
      
   CIDA Frame(s) (-2902x):
   -----------------------    
      SDU_CIDA                   rel.to SPACECRAFT             FIXED    -29020
      SDU_CIDA_TARGET            rel.to CIDA                   FIXED    -29021
      
   DFMI Frame(s) (-2903x):
   -----------------------    
      SDU_DFMI                   rel.to SPACECRAFT             FIXED    -29030
      SDU_DFMI_SU                rel.to DFMI                   FIXED    -29031
      SDU_DFMI_A1                rel.to DFMI                   FIXED    -29032
      SDU_DFMI_A2                rel.to DFMI                   FIXED    -29033
      
   Dust Collector Frame:
   ---------------------
      SDU_DUST_COLLECTOR         rel.to SPACECRAFT             CK       -29040
      
   Star Camera frames (-291xx):
   ----------------------------
      SDU_STARCAM_A              rel.to SPACECRAFT             FIXED    -29110
      SDU_STARCAM_B              rel.to SPACECRAFT             FIXED    -29120
   
   Antenna frames (-292xx):
   ------------------------
      SDU_HGA                    rel.to SPACECRAFT             FIXED    -29210
      SDU_MGA                    rel.to SPACECRAFT             FIXED    -29211
      SDU_LGA1                   rel.to SPACECRAFT             FIXED    -29212
      SDU_LGA2                   rel.to SPACECRAFT             FIXED    -29214
      SDU_LGA3                   rel.to SPACECRAFT             FIXED    -29213
      
   InterStellar Particle Stream frame(s) (-293xx):
   -----------------------------------------------
      SDU_ISP_STREAM             rel.to J2000                  FIXED    -29300

   Target Body-fixed frames (-299xx):
   ----------------------------------
      WILD2_FIXED                rel.to J2000                  PCK      -29901
      ANNEFRANK_FIXED            rel.to J2000                  PCK      -29902


SDU Frames Hierarchy
-------------------------------------------------------------------------------

   The diagram below shows Stardust frames hierarchy:


         "SDU_ISP_STREAM"
         ----------------
               ^
               | <--fixed 
               |
               |               "J2000" INERTIAL
               +-----------------------------------------------+
               |            |          |                       |
               | <--pck     |<--pck    | <--ck                 | <--pck
               |            |          |                       |   
               V            |          |                       V
           "WILD2_FIXED"    |          |                  "IAU_EARTH"
           WILD 2 BFR(*)    |          |                   EARTH BFR(*)
           -------------    |          |                  --------------
                            |          |
                            |          |
                            |          |                  "LGA2"
                            V          |                  ------
                   "ANNEFRANK_FIXED"   |                     ^
                    ANNEFRANK BFR(*)   |            fixed--> |
                   -----------------   |                     |
                                       |                     |
                                       |             "LGA1"  |  "LGA3"
                                       |             ------  |  ------  
                                       |                 ^   |   ^
                                       |        fixed--> |   |   | <--fixed
                                       |                 |   |   |
                                       |                 |   |   |
      "STARCAM_A"     "STARCAM_B"      |          "HGA"  |   |   |  "MGA" 
      -----------     -----------      |          -----  |   |   |  -----
        ^                ^             |             ^   |   |   |   ^
        | <--fixed       | <--fixed    |    fixed--> |   |   |   |   | <--fixed
        |                |             |             |   |   |   |   |
        |                |             |             |   |   |   |   |
        |                |             |             |   |   |   |   |
        |                |             |             |   |   |   |   |
        |                |             V             |   |   |   |   |
        |                |        "SPACECRAFT"       |   |   |   |   |
        +-----------+----+----------+----------------+---+-+-+---+---+
        |           |               |                      |         |
        | <--fixed  |               | <--fixed             |         |
        |           |               |                      |         |
        V           |               V                      |         |
      "CIDA"        |             "DFMI"                   |         |  
      ------        |   +-----------+-----------+          |         |  
        |           |   |           |           |          |         |         
        |           |   | <--fixed  | <--fixed  | <--fixed |         |  
        |           |   |           |           |          |         |
        V           |   V           V           V          |         |
      "CIDA_TARGET" |  "DFMI_SU"  "DFMI_A1"  "DFMI_A2"     |         |
      ------------- |  ---------  ---------  ---------     |         |
                    |                                      |         |
                    |                                      |         |         
                    |                                      |         |
                    |                                      |         |
                    |                                      |         |
                    |                                      |         | <--ck
                    |                                      |         |
                    |                                      |         V         
                    |                                      |   "DUST_COLLECTOR"
                    |                                      |   ----------------
                    |                                      |
                    | <--fixed                             | <--fixed
                    |                                      |
                    V                                      V
                "NC_BASE"                          "NC_BASE_IDEAL"
           +--------------+                    +-----------------+      
           |              |                    |                 |            
           | <--fixed     | <--fixed           | <--fixed        | <--fixed   
           |              |                    |                 |
           V              V                    V                 V
      "NC_OPTICS"  "NC_AXIS_STOWED"   "NC_OPTICS_IDEAL"  "NC_AXIS_STOWED_IDEAL"
      -----+-----  -------+--------   ---------+-------  --------+-------------
           |              |                    |                 |            
           | <--ck        | <--ck              | <--ck           | <--ck      
           |              |                    |                 |            
           V              V                    V                 V            
    "NC_REFLECTION"   "NC_AXIS"       "NC_REFLECTION_IDEAL"  "NC_AXIS_IDEAL"  
    -------+-------   ----+----       ---------+-----------  ----+----------
           |              |                    |                 |
           | <--fixed     | <--fixed           | <--fixed        | <--fixed
           |              |                    |                 |  
           |              V                    V                 V
           |          "NC_MIRROR"       "NC_IMAGE_IDEAL"   "NC_MIRROR_IDEAL"
           |          -----------       ----------------   -----------------
           |                                   |
           |                                   | <--ck
           |                                   |  
           V                                   V
       "NC_IMAGE"                       "NC_IMAGE_OPNAV"
       ----------                       ----------------

   (*) BFR -- body-fixed rotating frame


Spacecraft Bus Frame
-------------------------------------------------------------------------------

   The spacecraft bus frame is defined by the spacecraft design as follows:
   
      *  +X axis is along longer side of the spacecraft bus and points from 
         aerogel capsule side towards dust shield side;
         
      *  +Z is perpendicular to the spacecraft bus surface parallel to the
         deployed solar arrays surface and points in the HGA pointing 
         direction;
         
      *  +Y completes the right hand frame;
      
      *  the origin of this frame is at the launch vehicle interface point;

   This diagram illustrates the spacecraft frame (spacecraft is show in the 
   encounter configuration):

                                                   || Dust Collector 
                         Main                      ||     Array
        Solar Array     Shield                     ||
          Shield          .-.         o HGA        ||
            .-.       +Z ^| |   ._____|_____.      o
            | |==========|====o==\=========/==o=============== 
            `-'          || |-------------------. .        Solar 
                         || |                   |/|        Array
                         || | .-----.  CIDA     | |
                 <-------o| | |      '          | |  Return 
               +X      +Y | | .   __/           | | Capsule
                          | |  `. `.            |\|
                          | |--- `. `.---- -----' o---------
                          | |      `. `.           \_______/
                          `-'        `.'`. 
                                        .'

   The following frame definition is for the basic spacecraft bus frame.
   Spacecraft bus attitude with respect to an inertial frame is  provided
   by a C kernel (see [7] for more information).

   \begindata

      FRAME_SDU_SPACECRAFT       = -29000
      FRAME_-29000_NAME          = 'SDU_SPACECRAFT'
      FRAME_-29000_CLASS         = 3
      FRAME_-29000_CLASS_ID      = -29000
      FRAME_-29000_CENTER        = -29
      CK_-29000_SCLK             = -29
      CK_-29000_SPK              = -29

   \begintext


NC Frames
-------------------------------------------------------------------------------

   Given that periscope is perfectly aligned, there are two "chains" of frames 
   required to compute orientation of the NC images relative to the 
   Stardust spacecraft. The first chain:
   
      SPACECRAFT ---> CAMERA BASE ---> OPTICS ---> REFLECTION ---> IMAGE
      
   actually "connects" the spacecraft frame and the image frame. The second 
   chain:
   
      OPTICS ---> CAMERA BASE ---> AXIS_STOWED ---> AXIS ---> MIRROR
      
   is needed to compute transformation between two of the links in the 
   first chain -- OPTICS and REFLECTION  -- which is by the mirror normal 
   direction in the OPTICS frame.
   
   The explanation for the first chain is as follows:
   
      1) orientation of the camera base relative to the spacecraft frame can 
         be determined by a set of measurements of the orientation of the 
         NC alignment mirror relative to the s/c alignment cube; a frame 
         which is defined by alignment cube can be defined as a fixed offset 
         frame with orientation relative to the spacecraft frame;
                  
      2) because the camera is a solid structure, orientation of the 200 mm
         optics boresight axis can be measured relative to the NAVCAM 
         alignment mirror; so, a frame based on the camera boresight direction 
         and horizontal (row) and vertical (column) directions of the CCD can 
         be defined as a fixed offset frame with orientation relative to the 
         camera base frame;
         
      3) if the mirror normal direction is known in the 200 mm optics frame, a 
         180 degrees rotation about this direction can be applied to bring 
         optics frame to its right-hand reflection; since the mirror normal 
         direction in the optics frame is not fixed, a CK file for this 
         rotation should be made and, therefore, a CK frame should be defined 
         the reflection frame;
         
      4) to convert right-hand reflection into the actual left-hand 
         reflection (which is seen in the image) an additional minus-identity 
         fixed transformation has to be applied to the right-hand reflection
         frame; this transformation can defined in the fixed offset frame 
         to be applied to the right-hand reflection.
         
   As mentioned above, the second chain is needed to compute mirror normal
   direction in the optics frame which is required on the step 3 of the 
   first chain. This direction can be computed from mechanical alignments 
   and mirror rotation angle value as follows:
   
      1) orientation of the camera base frame relative to the optics frame 
         is known and fixed; it's a transpose of the transformation needed on
         the step two of the first chain and this transformation is already 
         defined in the optics fixed frame;
         
      2) direction of the mirror rotational axis and of the plane containing 
         this axis and mirror normal for the mirror's stowed position is 
         known and fixed; a frame based on this direction and plane can be 
         defined as a fixed offset frame with orientation relative to the 
         camera base frame;
         
      3) when mirror rotates, the plane containing mirror normal (and 
         corresponding axis of the "stowed" plane explained in the previous 
         item) rotates about mirror rotation axis by mirror rotation angle; 
         a CK file should be made for this rotation and, therefore, a CK frame
         should be defined for the rotating axis-based frame;
         
      4) because the mirror is tilted by 45 degrees (nominally)
         relative to its rotational axis, this tilt and any misalignment 
         accompanying it can be taken into account by an additional fixed 
         transformation from the rotation axis / mirror normal plane based 
         frame into the actual mirror normal direction based frame.

   Unfortunately, the mounting alignment calibrations performed on the ground 
   before launch could not provide accuracy required for on-board OPNAV 
   algorithms. Therefore, the Stardust OPNAV group (Shyam Bhaskaran et al) 
   had to implement a different schema which assumed that all transformations 
   described above are ideal (as they would be if the camera and its
   components would be assembled without any misalignment), and to introduce 
   an additional correction rotation to be applied to this ideal transformation
   to correct for all misalignments at once. This additional correction 
   was be calibrated during flight for various mirror angle value and 
   stored as three independent generic rotation angles for every 10 degree
   position in the mirror rotation range. For mirror angles values between 
   10 degree points, generic rotation angles were be linearly interpolated to
   get continuous function.
   
   This approach changes NAVCAM frames chains as follows: the first chain, 
   connecting SPACECRAFT to IMAGE frames, becomes:
   
      SC --> CAM BASE(I) --> OPTICS(I) --> REFL(I) --> IMAGE(I) --> IMAGE_OPNAV
      
   the second chain needed to computes mirror normal direction becomes:
   
      OPTICS(I) --> CAM BASE(I) --> AXIS_STOWED(I) --> AXIS(I) --> MIRROR(I)
      
   where (I) designates "ideal" (nominal) transformations.

   Set of the frame definitions below implement both of these approaches.

      
NC Base Frame
-----------------

   The NAVCAM base frame is defined by the NAVCAM design as follows:
   
      *  +Z is nominally along the NAVCAM 200 mm optics optical axis and 
         scan mirror rotation axis and point from the camera base towards
         the scan mirror;
         
      *  +Y is nominally along actual camera CCD assembly vertical direction 
         (columns) and points from the electronic box at the bottom of the 
         camera assembly towards the top of the camera assembly;
         
      *  +X complements to a right hand frame (and is nominally along 
         actual camera CCD assembly horizontal direction (rows));
         
      *  the origin of this frame is in the middle of the camera mounting 
         base surface.

   Nominally the NAVCAM base frame is rotated from the spacecraft frame by 90 
   degrees about X axis. The SDU_NC_BASE_IDEAL frame definition below 
   contains the nominal orientation.
   
   Actual orientation of the NAVCAM frame with respect to the spacecraft 
   frame can be determined by combining two independent measurements obtained
   on the ground before launch -- the first measurement of the orientation of 
   the NAVCAM mounting mirror (nominally the normal of this mirror is pointing 
   along the s/c -Y axis and along the NAVCAM base +Z axis) with respect to 
   the NAVCAM base obtained when camera was not mounted on the spacecraft and 
   the second measurement of the orientation of the NAVCAM mounting mirror 
   with respect to the spacecraft alignment cube when camera was attached 
   to the spacecraft.
   
   The NAVCAM mounting mirror normal orientation with respect to the
   +Z axis of NAVCAM mounting plate [see 9] had an offset of 0.208 
   degrees in X-Y plane and an offset of -0.190 degrees in Y-Z plane from
   its nominal orientation.
   
   The NAVCAM mounting mirror normal orientation with respect to the
   -Y side normal of the spacecraft mounting cube [see 10] had an offset 
   of 0.199 degrees in X-Y plane and an offset of -0.2808 degrees in 
   Y-Z plane from its nominal orientation.
   
   Combining these two measurements together, the offsets between the
   -Y side of the spacecraft alignment cube and the +Z axis of camera
   base are:
   
      -0.0090 in the s/c XY plane (0.199-0.208) and 
      -0.0908 in the s/c YZ plane (-0.2808-(-0.190)).
   
   Given that the magnitude of the angles is very small, they can be
   considered as a rotational angles (... well this is a little stretch,
   but it will do for now :) and can be combined with nominal rotation
   from the s/c frame to the camera base frame. This will give us
   "actual" orientation from the s/c frame, ``SDU_SPACECRAFT'', with respect 
   to the NAVCAM base frame, ``SDU_NC_BASE'', achieved by two rotations --
   first by 89.9092 degrees (90-0.0908) about +X axis and second by
   -0.0090 degrees about new positions of +Y axis. The SDU_NC_BASE frame 
   definition below  contains the "actual" orientation.

   \begindata

      FRAME_SDU_NC_BASE          = -29011
      FRAME_-29011_NAME          = 'SDU_NC_BASE'
      FRAME_-29011_CLASS         = 4
      FRAME_-29011_CLASS_ID      = -29011
      FRAME_-29011_CENTER        = -29
      TKFRAME_-29011_SPEC        = 'ANGLES'
      TKFRAME_-29011_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29011_ANGLES      = ( -89.9092, 0.0090, 0.0 )
      TKFRAME_-29011_AXES        = (        1,      2,   3 )
      TKFRAME_-29011_UNITS       = 'DEGREES'
      
      FRAME_SDU_NC_BASE_IDEAL    = -29091
      FRAME_-29091_NAME          = 'SDU_NC_BASE_IDEAL'
      FRAME_-29091_CLASS         = 4
      FRAME_-29091_CLASS_ID      = -29091
      FRAME_-29091_CENTER        = -29
      TKFRAME_-29091_SPEC        = 'ANGLES'
      TKFRAME_-29091_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29091_ANGLES      = ( -90.0, 0.0, 0.0 )
      TKFRAME_-29091_AXES        = (     1,   2,   3 )
      TKFRAME_-29091_UNITS       = 'DEGREES'
      
   \begintext

      
NC Optics Frame
-------------------
   
   The NAVCAM optics frame is defined by the NAVCAM optics design as follows:
   
      *  +Z is along the NAVCAM 200 mm optics optical axis and points from 
         the CCD towards the camera lenses;
         
      *  +Y is along actual camera CCD assembly vertical direction (columns) 
         and points from the CCD assembly bottom row towards the CCD top row;
         
      *  +X complements to a right hand frame (and is along 
         actual camera CCD assembly horizontal direction (rows));
         
      *  the origin of this frame is in the camera optics focal point.

   Nominally NAVCAM optics frame is co-aligned with the NAVCAM base 
   frame. The SDU_NC_OPTICS_IDEAL frame definition below contains the 
   nominal orientation.
   
   Actual NAVCAM 200 mm optics orientation with respect to the spacecraft 
   frame axes as measured on the ground before launch [from 9] had 
   an offset of -0.102 degrees from -Y axis in Y-Z plane (or -0.102 from +Z 
   axis in the camera base frame) from the nominal orientation. The 
   SDU_NC_OPTICS frame definition below contains the actual orientation.
   
   \begindata

      FRAME_SDU_NC_OPTICS        = -29012
      FRAME_-29012_NAME          = 'SDU_NC_OPTICS'
      FRAME_-29012_CLASS         = 4
      FRAME_-29012_CLASS_ID      = -29012
      FRAME_-29012_CENTER        = -29
      TKFRAME_-29012_SPEC        = 'ANGLES'
      TKFRAME_-29012_RELATIVE    = 'SDU_NC_BASE'
      TKFRAME_-29012_ANGLES      = ( 0.102,  0.000, 0.0 )
      TKFRAME_-29012_AXES        = (     1,      2,   3 )
      TKFRAME_-29012_UNITS       = 'DEGREES'

      FRAME_SDU_NC_OPTICS_IDEAL  = -29092
      FRAME_-29092_NAME          = 'SDU_NC_OPTICS_IDEAL'
      FRAME_-29092_CLASS         = 4
      FRAME_-29092_CLASS_ID      = -29092
      FRAME_-29092_CENTER        = -29
      TKFRAME_-29092_SPEC        = 'ANGLES'
      TKFRAME_-29092_RELATIVE    = 'SDU_NC_BASE_IDEAL'
      TKFRAME_-29092_ANGLES      = (   0.0, 0.0, 0.0 )
      TKFRAME_-29092_AXES        = (   1,   2,   3   )
      TKFRAME_-29092_UNITS       = 'DEGREES'

   \begintext

      
NC Reflection Frame
-----------------------

   The NAVCAM reflection frame is the first of two frames needed to implement 
   reflection and it is defined as follows:
   
      *  direction of each of three axes of this frame is obtained by 
         180 degrees rotation from the corresponding axis of the camera 
         optics frame about mirror normal direction specified in the 
         camera optics frame;
         
      *  the origin of this frame is at the intersection of the camera
         optical axis with surface of the scan mirror.

   This frame is a CK based frame. It is rotated with respect to the 
   NAVCAM optics frame by 180 degrees about scan mirror normal direction
   specified in the NAVCAM optics frame.
   
   \begindata

      FRAME_SDU_NC_REFLECTION       = -29013
      FRAME_-29013_NAME             = 'SDU_NC_REFLECTION'
      FRAME_-29013_CLASS            = 3
      FRAME_-29013_CLASS_ID         = -29013
      FRAME_-29013_CENTER           = -29
      CK_-29013_SCLK                = -29
      CK_-29013_SPK                 = -29

      FRAME_SDU_NC_REFLECTION_IDEAL = -29093
      FRAME_-29093_NAME             = 'SDU_NC_REFLECTION_IDEAL'
      FRAME_-29093_CLASS            = 3
      FRAME_-29093_CLASS_ID         = -29093
      FRAME_-29093_CENTER           = -29
      CK_-29093_SCLK                = -29
      CK_-29093_SPK                 = -29

   \begintext

      
NC Stowed Axis Based Frame
------------------------------
   
   The NAVCAM stowed axis based frame is defined by the NAVCAM scan mirror 
   design as follows:
   
      *  +Z is along the NAVCAM scan mirror rotation axis and points from 
         the camera base;
         
      *  +X is in the plane defined by the mirror normal and mirror rotation
         axis in the stowed position and points from the mirror reflecting 
         surface;
         
      *  +Y complements to a right hand frame;
         
      *  the origin of this frame at the intersection of the scan mirror 
         rotation axis and mirror reflecting surface.

   Nominally NAVCAM stowed mirror axis based frame is co-aligned with 
   the NAVCAM base frame. The SDU_NC_AXIS_STOWED_IDEAL frame definition 
   below contains the nominal orientation.
   
   Measurements on the ground before launch [from 9] showed that scan mirror 
   rotation axis is well aligned with the spacecraft Y axis in both X-Y and 
   Z-Y planes of the spacecraft frame. Therefore actual stowed mirror axis 
   based frame orientation is assumed to be the same as the nominal one. The 
   SDU_NC_AXIS_STOWED frame definition below reflects this.
   
   \begindata

      FRAME_SDU_NC_AXIS_STOWED         = -29015
      FRAME_-29015_NAME                = 'SDU_NC_AXIS_STOWED'
      FRAME_-29015_CLASS               = 4
      FRAME_-29015_CLASS_ID            = -29015
      FRAME_-29015_CENTER              = -29
      TKFRAME_-29015_SPEC              = 'ANGLES'
      TKFRAME_-29015_RELATIVE          = 'SDU_NC_BASE'
      TKFRAME_-29015_ANGLES            = ( 0.000,  0.000, 0.0 )
      TKFRAME_-29015_AXES              = (     1,      2,   3 )
      TKFRAME_-29015_UNITS             = 'DEGREES'

      FRAME_SDU_NC_AXIS_STOWED_IDEAL   = -29095
      FRAME_-29095_NAME                = 'SDU_NC_AXIS_STOWED_IDEAL'
      FRAME_-29095_CLASS               = 4
      FRAME_-29095_CLASS_ID            = -29095
      FRAME_-29095_CENTER              = -29
      TKFRAME_-29095_SPEC              = 'ANGLES'
      TKFRAME_-29095_RELATIVE          = 'SDU_NC_BASE_IDEAL'
      TKFRAME_-29095_ANGLES            = (   0.0, 0.0, 0.0 )
      TKFRAME_-29095_AXES              = (   1,   2,   3   )
      TKFRAME_-29095_UNITS             = 'DEGREES'

   \begintext

      
NC Rotating Axis Based Frame
--------------------------------

   The NAVCAM rotating axis based frame is defined by the NAVCAM scan mirror 
   design as follows:
   
      *  +Z is along the NAVCAM scan mirror rotation axis and points from 
         the camera base;
         
      *  +X is in the plane defined by the mirror normal and mirror rotation
         axis in the any position and points from the mirror reflecting 
         surface;
         
      *  +Y complements to a right hand frame;
         
      *  the origin of this frame at the intersection of the scan mirror 
         rotation axis and mirror reflecting surface.

   This frame is a CK based frame. It is rotated with respect to the 
   NAVCAM stowed mirror axis based frame by negative of the mirror rotation 
   angle that comes in telemetry data about Z axis of that frame.
   
   \begindata

      FRAME_SDU_NC_AXIS          = -29016
      FRAME_-29016_NAME          = 'SDU_NC_AXIS'
      FRAME_-29016_CLASS         = 3
      FRAME_-29016_CLASS_ID      = -29016
      FRAME_-29016_CENTER        = -29
      CK_-29016_SCLK             = -29
      CK_-29016_SPK              = -29

      FRAME_SDU_NC_AXIS_IDEAL    = -29096
      FRAME_-29096_NAME          = 'SDU_NC_AXIS_IDEAL'
      FRAME_-29096_CLASS         = 3
      FRAME_-29096_CLASS_ID      = -29096
      FRAME_-29096_CENTER        = -29
      CK_-29096_SCLK             = -29
      CK_-29096_SPK              = -29

   \begintext

      
NC Rotating Mirror Normal Based Frame
-----------------------------------------
   
   The NAVCAM rotating mirror normal based frame is defined by the NAVCAM 
   scan mirror design as follows:
   
      *  +Z is along the NAVCAM scan mirror normal and points from the mirror 
         reflecting surface;
         
      *  +X is in the plane defined by the mirror normal and mirror rotation
         axis in the any position and points from the mirror center toward 
         the mirror edge that closer to the camera optics;
         
      *  +Y complements to a right hand frame;
         
      *  the origin of this frame at the intersection of the scan mirror 
         rotation axis and mirror reflecting surface.

   Nominally NAVCAM rotating mirror normal based frame is rotated by 
   135 degrees with respect to the camera rotating axis based frame about 
   Y axis of that frame (to bring Z axis to the direction of the mirror 
   normal). The SDU_NC_MIRROR_IDEAL frame definition below contains the 
   nominal orientation.
   
   Actual NAVCAM mirror tilt with respect to the mirror rotation axis as 
   measured on the ground before launch [from 9] was 45.216 degrees. 
   Therefore actual NAVCAM rotating mirror normal based frame is rotated by 
   135.216 degrees with respect to the camera rotating axis based frame. 
   The SDU_NC_MIRROR frame definition below contains the actual orientation.
   
   \begindata
   
      FRAME_SDU_NC_MIRROR        = -29017
      FRAME_-29017_NAME          = 'SDU_NC_MIRROR'
      FRAME_-29017_CLASS         = 4
      FRAME_-29017_CLASS_ID      = -29017
      FRAME_-29017_CENTER        = -29
      TKFRAME_-29017_SPEC        = 'ANGLES'
      TKFRAME_-29017_RELATIVE    = 'SDU_NC_AXIS'
      TKFRAME_-29017_ANGLES      = (   0.0, -135.216,  0.0 )
      TKFRAME_-29017_AXES        = (   1,          2,    3 )
      TKFRAME_-29017_UNITS       = 'DEGREES'
   
      FRAME_SDU_NC_MIRROR_IDEAL  = -29097
      FRAME_-29097_NAME          = 'SDU_NC_MIRROR_IDEAL'
      FRAME_-29097_CLASS         = 4
      FRAME_-29097_CLASS_ID      = -29097
      FRAME_-29097_CENTER        = -29
      TKFRAME_-29097_SPEC        = 'ANGLES'
      TKFRAME_-29097_RELATIVE    = 'SDU_NC_AXIS_IDEAL'
      TKFRAME_-29097_ANGLES      = (   0.0, -135.0, 0.0 )
      TKFRAME_-29097_AXES        = (   1,      2,   3   )
      TKFRAME_-29097_UNITS       = 'DEGREES'
   
   \begintext


NC Image Frame
-----------------------
   
   The NAVCAM image frame is defined by NAVCAM virtual image geometry as 
   follows:
   
      *  +Z is along reflected camera boresight and point from the mirror 
         surface;
         
      *  +Y is along image vertical direction (columns) and points from 
         the image bottom row towards the image top row;
         
      *  +X complements to a right hand frame (and is along 
         image horizontal direction (rows));
         
      *  the origin of this frame is at the camera focal point.
      
   This frame is the second of two frames needed to implement reflection.

   The two frames below are NAVCAM image left hand frames for real and 
   ideal camera models. Both frames are defined as minus identity 
   transformation with respect to the corresponding reflection frames 
   defined above.
      
   \begindata

      FRAME_SDU_NC_IMAGE         = -29010
      FRAME_-29010_NAME          = 'SDU_NC_IMAGE'
      FRAME_-29010_CLASS         = 4
      FRAME_-29010_CLASS_ID      = -29010
      FRAME_-29010_CENTER        = -29
      TKFRAME_-29010_SPEC        = 'MATRIX'
      TKFRAME_-29010_RELATIVE    = 'SDU_NC_REFLECTION'
      TKFRAME_-29010_MATRIX       = ( -1.0,  0.0,  0.0, 
                                      0.0, -1.0,  0.0, 
                                      0.0,  0.0, -1.0 ) 
                                    
      FRAME_SDU_NC_IMAGE_IDEAL   = -29094
      FRAME_-29094_NAME          = 'SDU_NC_IMAGE_IDEAL'
      FRAME_-29094_CLASS         = 4
      FRAME_-29094_CLASS_ID      = -29094
      FRAME_-29094_CENTER        = -29
      TKFRAME_-29094_SPEC        = 'MATRIX'
      TKFRAME_-29094_RELATIVE    = 'SDU_NC_REFLECTION_IDEAL'
      TKFRAME_-29094_MATRIX      = ( -1.0,  0.0,  0.0, 
                                      0.0, -1.0,  0.0, 
                                      0.0,  0.0, -1.0 )

   \begintext

   This frame is a CK based frame. It is rotated with respect to the 
   NAVCAM ideal image frame by set of rotation correction angles 
   derived by OPNAV software from in-flight calibration images.

   \begindata
                                      
      FRAME_SDU_NC_IMAGE_OPNAV   = -29090
      FRAME_-29090_NAME          = 'SDU_NC_IMAGE_OPNAV'
      FRAME_-29090_CLASS         = 3
      FRAME_-29090_CLASS_ID      = -29090
      FRAME_-29090_CENTER        = -29
      CK_-29090_SCLK             = -29
      CK_-29090_SPK              = -29

   \begintext

      
CIDA Frame
-------------------------------------------------------------------------------

   The CIDA frame is defined by the CIDA instrument design and mounting
   alignment as follows:
   
      *  +Z is along +X axis of the spacecraft (direction from which the 
         dust will be coming onto the collector);
         
      *  +Y is along the spacecraft +Y axis and point in the same
         direction;
         
      *  +X completes to the right hand frame (and is along and points
         in the same direction and the spacecraft -Z axis);
         
      *  the origin on this frame is at the center of the CIDA target 
         plate.

   As follows from this definition, the CIDA nominal frame is rotated 90 
   degrees about Y axis from the spacecraft frame and, therefore, if defined 
   as as fixed offset frame with respect to the s/c frame. This diagram 
   illustrates the CIDA frame:

                                                   || Dust Collector 
                         Main                      ||     Array
        Solar Array     Shield                     ||
          Shield          .-.         o HGA        ||
            .-.     +Zsc ^| |   ._____|_____.      o
            | |==========|====o==\=========/==o=============== 
            `-'          || |-------------------. .        Solar 
                         || |                   |/|        Array
                         || | .-----.  CIDA     | |
                 <-------o| | |      '          | |  Return 
               +Xsc   +Ysc| | .   __/           | | Capsule
                          | |  `. `.            |\|
                          | |--- `. `.---- -----' o---------
                          | |      `. `.   CIDA    \_______/
                          `-'        `.'`. Target  
         --->   --->             <-------o 
             Nominal            +Zc      | +Yc
         Incoming Particle               |
         direction during                |
            Encounter                    |           +Ysc and +Ycida are 
                                         v             out of the page
                                      +Xc

      
   These keywords comprise the CIDA frame definition.
   
   \begindata

      FRAME_SDU_CIDA             = -29020
      FRAME_-29020_NAME          = 'SDU_CIDA'
      FRAME_-29020_CLASS         = 4
      FRAME_-29020_CLASS_ID      = -29020
      FRAME_-29020_CENTER        = -29
      TKFRAME_-29020_SPEC        = 'ANGLES'
      TKFRAME_-29020_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29020_ANGLES      = ( 0.0, -90.0,   0.0 )
      TKFRAME_-29020_AXES        = ( 1,     2,     3   )
      TKFRAME_-29020_UNITS       = 'DEGREES'

   \begintext

   
CIDA Target Frame
-------------------------------------------------------------------------------

   The CIDA target frame is defined by the CIDA instrument design:
   
      *  +Z is normal to the CIDA target plate and points onto the
         drift tube;
         
      *  +Y is normal to the CIDA mounting side and points from it 
         towards the opposite side (nominally along the s/c +Y
         axis);
         
      *  +X completes the right hand frame;
         
      *  the origin on this frame is at the center of the target plate.

   This diagram illustrates the CIDA target frame:


                                                   || Dust Collector 
                         Main                      ||     Array
        Solar Array     Shield                     ||
          Shield          .-.         o HGA        ||
            .-.     +Zsc ^| |   ._____|_____.      o
            | |==========|====o==\=========/==o=============== 
            `-'          || |-------------------. .        Solar 
                         || |                   |/|        Array
                         || | .-----.  CIDA     | |
                 <-------o| | |      '          | |  Return 
               +Xsc   +Ysc| | .   __/           | | Capsule
                          | |  `. `             |\|
                          | |--- `.<. +Zct -----' o---------
                          | |      `.`.            \_______/
                          `-'        `.`.  Target  
         --->   --->             <-------o  --------
             Nominal            +Zc     /| .    '
         Incoming Particle             / |  `. ' 40 deg 
         direction during             /  |    `. 
            Encounter           +Xct V   |      `. Normal to  
                                         v    CIDA Target Plane
                                        +Xc

      
   As seen on the diagram, the CIDA target frame is rotated by -40
   degrees about Y axis from the CIDA frame. Therefore, it is defined
   as a fixed offset frame with respect to the CIDA frame.
   
   \begindata

      FRAME_SDU_CIDA_TARGET      = -29021
      FRAME_-29021_NAME          = 'SDU_CIDA_TARGET'
      FRAME_-29021_CLASS         = 4
      FRAME_-29021_CLASS_ID      = -29021
      FRAME_-29021_CENTER        = -29
      TKFRAME_-29021_SPEC        = 'ANGLES'
      TKFRAME_-29021_RELATIVE    = 'SDU_CIDA'
      TKFRAME_-29021_ANGLES      = ( 0.0,  40.0,   0.0 )
      TKFRAME_-29021_AXES        = ( 1,     2,     3   )
      TKFRAME_-29021_UNITS       = 'DEGREES'

   \begintext
   

DFMI Frames
-------------------------------------------------------------------------------

   The DFMI nominal frame is defined by the DFMI instrument design as 
   follows:
   
      *  +Z is along instrument sensor surface normal vector and 
         point from the spacecraft;
         
      *  +Y is nominally along the spacecraft Y axis and point in the 
         same direction;
         
      *  +X complements to the right hand frame (and nominally is along and 
         points in the same direction and the spacecraft -Z frame);
         
      *  the origin on this frame is at the intersection of the outer
         surface of the Whipple shield and the spacecraft +X axis.
      
   As follows from this definition, the DFMI nominal frame is rotated 90 
   degrees about Y axis from the spacecraft frame.
         
   The DFMI sensor frames are defined relative to the DFMI nominal frame and 
   their orientation is determined by the surface normal vector direction of
   each sensor. Since pointing requirements of the instrument are very low
   the sensor frame can be considered to be co-aligned with the nominal DFMI
   instrument frame.

   \begindata

      FRAME_SDU_DFMI             = -29030
      FRAME_-29030_NAME          = 'SDU_DFMI'
      FRAME_-29030_CLASS         = 4
      FRAME_-29030_CLASS_ID      = -29030
      FRAME_-29030_CENTER        = -29
      TKFRAME_-29030_SPEC        = 'ANGLES'
      TKFRAME_-29030_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29030_ANGLES      = ( 0.0, -90.0,   0.0 )
      TKFRAME_-29030_AXES        = (   1,     2,     3 )
      TKFRAME_-29030_UNITS       = 'DEGREES'

      FRAME_SDU_DFMI_SU          = -29031
      FRAME_-29031_NAME          = 'SDU_DFMI_SU'
      FRAME_-29031_CLASS         = 4
      FRAME_-29031_CLASS_ID      = -29031
      FRAME_-29031_CENTER        = -29
      TKFRAME_-29031_SPEC        = 'ANGLES'
      TKFRAME_-29031_RELATIVE    = 'SDU_DFMI'
      TKFRAME_-29031_ANGLES      = ( 0.0, 0.0, 0.0 )
      TKFRAME_-29031_AXES        = ( 1,   2,   3   )
      TKFRAME_-29031_UNITS       = 'DEGREES'

      FRAME_SDU_DFMI_A1          = -29032
      FRAME_-29032_NAME          = 'SDU_DFMI_A1'
      FRAME_-29032_CLASS         = 4
      FRAME_-29032_CLASS_ID      = -29032
      FRAME_-29032_CENTER        = -29
      TKFRAME_-29032_SPEC        = 'ANGLES'
      TKFRAME_-29032_RELATIVE    = 'SDU_DFMI'
      TKFRAME_-29032_ANGLES      = ( 0.0, 0.0, 0.0 )
      TKFRAME_-29032_AXES        = ( 1,   2,   3   )
      TKFRAME_-29032_UNITS       = 'DEGREES'

      FRAME_SDU_DFMI_A2          = -29033
      FRAME_-29033_NAME          = 'SDU_DFMI_A2'
      FRAME_-29033_CLASS         = 4
      FRAME_-29033_CLASS_ID      = -29033
      FRAME_-29033_CENTER        = -29
      TKFRAME_-29033_SPEC        = 'ANGLES'
      TKFRAME_-29033_RELATIVE    = 'SDU_DFMI'
      TKFRAME_-29033_ANGLES      = ( 0.0, 0.0, 0.0 )
      TKFRAME_-29033_AXES        = ( 1,   2,   3   )
      TKFRAME_-29033_UNITS       = 'DEGREES'

   \begintext


Dust Collector Frame
-------------------------------------------------------------------------------

   The dust collector frame is defined by the collector design:
   
      *  +Z is normal to the collector surface on the comet dust side;
         
      *  +X is from the collector center towards the spacecraft;
         
      *  +Y completes the right hand frame;
         
      *  the origin on this frame is at the center of the collector
         comet dust side.

   This diagram illustrates the collector frame when collector is 
   fully deployed (encounter configuration):
      
                                                   
                                                    
                                                    
                                                   || Dust Collector 
                         Main            +Zcol     ||     Array
        Solar Array     Shield             <-------o|
          Shield          .-.    HGA  o            |+Ycol
            .-.     +Zsc ^| |   ._____|_____.      |o
            | |==========|====o==\=========/==o====|========== 
            `-'          || |-------------------. .|       Solar 
                         || |                   |/|V Xcol  Array
                         || | .-----.  CIDA     | |
                 <-------o| | |      '          | |  Return 
               +Xsc   +Ysc| | .   __/           | | Capsule
                          | |  `. `             |\|
                          | |--- `.`.----- -----' o---------
                          | |      `.`.            \_______/
                          `-'        `.`. 
         --->   --->                   ` /
             Nominal
         Incoming Particle
         direction during
            Encounter

   As seen on the diagram the collector frame is rotated from the
   spacecraft frame by +90 degrees about Y axis when collector is fully
   deployed.

   Since collector orientation is not constant -- as collector can be
   stowed or deployed at a different angles -- the collector frame is
   defined as a fixed offset frame.

   \begindata

      FRAME_SDU_DUST_COLLECTOR   = -29040
      FRAME_-29040_NAME          = 'SDU_DUST_COLLECTOR'
      FRAME_-29040_CLASS         = 3
      FRAME_-29040_CLASS_ID      = -29040
      FRAME_-29040_CENTER        = -29
      CK_-29040_SCLK             = -29
      CK_-29040_SPK              = -29
      
   \begintext


Star Camera Frames
-------------------------------------------------------------------------------

   Both Star Camera frames are fixed offset from the spacecraft frame. For 
   both star camera frames, +Z axis of the frame is the camera "boresight"
   direction.


Star Camera "A"
---------------

   The SDU Star Camera A points in the SC X-Z plane between +X and -Z axis. 
   I.e. nominally +135 degrees rotation about SC Y axis is needed to co-align 
   SC and STARCAM A frames. 

   \begindata

      FRAME_SDU_STARCAM_A        = -29110
      FRAME_-29110_NAME          = 'SDU_STARCAM_A'
      FRAME_-29110_CLASS         = 4
      FRAME_-29110_CLASS_ID      = -29110
      FRAME_-29110_CENTER        = -29
      TKFRAME_-29110_SPEC        = 'ANGLES'
      TKFRAME_-29110_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29110_ANGLES      = ( 0.0, -135.0, 0.0 )
      TKFRAME_-29110_AXES        = ( 3,      2,   1   )
      TKFRAME_-29110_UNITS       = 'DEGREES'

   \begintext


Star Camera "B"
---------------

   The SDU Star Camera B points in the SC X-Z plane between -X and -Z axis. 
   I.e. nominally -135 degrees rotation about SC Y axis is needed to co-align 
   SC and STARCAM B frames. 

   \begindata

      FRAME_SDU_STARCAM_A        = -29120
      FRAME_-29120_NAME          = 'SDU_STARCAM_A'
      FRAME_-29120_CLASS         = 4
      FRAME_-29120_CLASS_ID      = -29120
      FRAME_-29120_CENTER        = -29
      TKFRAME_-29120_SPEC        = 'ANGLES'
      TKFRAME_-29120_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29120_ANGLES      = ( 0.0, 135.0, 0.0 )
      TKFRAME_-29120_AXES        = ( 3,     2,   1   )
      TKFRAME_-29120_UNITS       = 'DEGREES'

   \begintext


SDU Antenna Frames
-------------------------------------------------------------------------------

   All SDU antenna frames are fixed offset from the spacecraft frame. For any 
   SDU antenna frame, +Z axis of the frame points in the antenna "boresight"
   direction.


High Gain Antenna
-----------------

   The SDU High Gain Antenna (HGA) points approximately along S/C +Z axis.
   I.e. nominally zero rotation is needed to co-align SC and HGA frames.

   \begindata

      FRAME_SDU_HGA              = -29210
      FRAME_-29210_NAME          = 'SDU_HGA'
      FRAME_-29210_CLASS         = 4
      FRAME_-29210_CLASS_ID      = -29210
      FRAME_-29210_CENTER        = -29
      TKFRAME_-29210_SPEC        = 'ANGLES'
      TKFRAME_-29210_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29210_ANGLES      = ( 0.0, 0.0, 0.0 )
      TKFRAME_-29210_AXES        = (   3,   2,   1 )
      TKFRAME_-29210_UNITS       = 'DEGREES'

   \begintext


Medium Gain Antenna
-------------------

   The SDU Medium Gain Antenna (MGA) is canted by 7 degrees from the SC 
   +Z in direction of the SC +X (from [13]). So, nominally a single 
   rotation of +7 degrees about the SC +Y axis is needed to co-align 
   SC and HGA frames.

   \begindata

      FRAME_SDU_MGA              = -29211
      FRAME_-29211_NAME          = 'SDU_MGA'
      FRAME_-29211_CLASS         = 4
      FRAME_-29211_CLASS_ID      = -29211
      FRAME_-29211_CENTER        = -29
      TKFRAME_-29211_SPEC        = 'ANGLES'
      TKFRAME_-29211_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29211_ANGLES      = ( 0.0, -7.0, 0.0 )
      TKFRAME_-29211_AXES        = (   3,    2,   1 )
      TKFRAME_-29211_UNITS       = 'DEGREES'

   \begintext


Low Gain Antennas
-----------------

   The LGA1 (transmitter) and LGA3 (receiver) point in the SC X-Z plane
   between -X and -Z axis. Thus, nominally -135 degrees rotation about SC
   Y axis is needed to co-align SC and LGA1 and LGA3 frames.

   The LGA2 is aligned with the HGA (i.e. points along the s/c
   +Z). Nominally, no rotations are needed to co-align SC and LGA2
   frames.

   \begindata

      FRAME_SDU_LGA1             = -29212
      FRAME_-29212_NAME          = 'SDU_LGA1'
      FRAME_-29212_CLASS         = 4
      FRAME_-29212_CLASS_ID      = -29212
      FRAME_-29212_CENTER        = -29
      TKFRAME_-29212_SPEC        = 'ANGLES'
      TKFRAME_-29212_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29212_ANGLES      = ( 0.0, 135.0, 0.0 )
      TKFRAME_-29212_AXES        = ( 3,     2,   1   )
      TKFRAME_-29212_UNITS       = 'DEGREES'

      FRAME_SDU_LGA2             = -29214
      FRAME_-29214_NAME          = 'SDU_LGA2'
      FRAME_-29214_CLASS         = 4
      FRAME_-29214_CLASS_ID      = -29214
      FRAME_-29214_CENTER        = -29
      TKFRAME_-29214_SPEC        = 'ANGLES'
      TKFRAME_-29214_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29214_ANGLES      = ( 0.0, 0.0, 0.0 )
      TKFRAME_-29214_AXES        = ( 3,   2,   1   )
      TKFRAME_-29214_UNITS       = 'DEGREES'

      FRAME_SDU_LGA3             = -29213
      FRAME_-29213_NAME          = 'SDU_LGA3'
      FRAME_-29213_CLASS         = 4
      FRAME_-29213_CLASS_ID      = -29213
      FRAME_-29213_CENTER        = -29
      TKFRAME_-29213_SPEC        = 'ANGLES'
      TKFRAME_-29213_RELATIVE    = 'SDU_SPACECRAFT'
      TKFRAME_-29213_ANGLES      = ( 0.0, 135.0, 0.0 )
      TKFRAME_-29213_AXES        = ( 3,     2,   1   )
      TKFRAME_-29213_UNITS       = 'DEGREES'

   \begintext
   

SDU Targets
-------------------------------------------------------------------------------

   This section contains definitions of body-fixed frames for Stardust
   targets -- comet Wild 2 and asteroid Annefrank, -- and definition of
   a special frame tied to the direction of the InterStellar Particle
   stream (ISP).


Comet Wild 2 Body-fixed Frame
--------------------------------------------------------

   The Wild 2 body-fixed frame is defined in the same as any other PCK
   frame:

      *  +Z along comet's North pole;

      *  +X along comet's prime meridian;

      *  +Y completes the right hand frame;

      *  the origin of this frame is at the center of the comet
         ellipsoid.

   As for any PCK frame orientation of this frame is computed by
   evaluating corresponding rotation constants provided in a PCK file.

   \begindata

      FRAME_WILD2_FIXED          =  -29901
      FRAME_-29901_NAME          = 'WILD2_FIXED'
      FRAME_-29901_CLASS         =  2
      FRAME_-29901_CLASS_ID      =  1000107
      FRAME_-29901_CENTER        =  1000107

      OBJECT_1000107_FRAME       = 'WILD2_FIXED'

   \begintext


Asteroid Annefrank Body-fixed Frame
--------------------------------------------------------

   The Annefrank body-fixed frame is defined in the same as any other
   PCK frame:
 
      *  +Z along asteroid's North pole;

      *  +X along asteroid's prime meridian;

      *  +Y completes the right hand frame;

      *  the origin of this frame is at the center of the asteroid
         triaxial ellipsoid.

   As for any PCK frame orientation of this frame is computed by
   evaluating corresponding rotation constants provided in a PCK file.

   \begindata

      FRAME_ANNEFRANK_FIXED      =  -29902
      FRAME_-29902_NAME          = 'ANNEFRANK_FIXED'
      FRAME_-29902_CLASS         =  2
      FRAME_-29902_CLASS_ID      =  2005535
      FRAME_-29902_CENTER        =  2005535

      OBJECT_2005535_FRAME       = 'ANNEFRANK_FIXED'

   \begintext


InterStellar Particle Stream
----------------------------

   The interstellar dust stream was detected by the Ulysses spacecraft
   during the Jupiter flyby in February, 1992 [see 12.]  These findings
   were confirmed by the Galileo experiment on its outbound orbit from
   Earth to Jupiter. The mean mass of the interstellar particles is
   3x10^-13 grams. The flux arrives from a direction which is
   compatible with the influx direction of the interstellar neutral
   Helium with uncertainty of 10 or 20 degrees.

      ISP Magnitude                                =  26.0 km/s
      ISP Ecliptic Latitude  = ISP Declination     =   7.7 degrees
      ISP Ecliptic Longitude = ISP Right Ascension = 259.0 degrees

   Although these values are explicitly specified here, the ISP RA value
   is known to within +/- 20 degrees and the ISP Dec is known to within
   +/- 10 degrees.

   We define the axes of the InterStellar Particle Stream reference frame 
   in the following way:

      *  The +Z axis to be in the direction of the velocity of
         the ISP stream.

      *  The +Y axis is a vector which is perpendicular to +Z and lies
         in the XY plane of the ECLIPJ2000 reference frame.

      *  The +X axis completes the coordinate system, being perpendicular
         to both +Y and +Z, following the right-hand rule.

   Two rotations are needed to rotate ECLIPJ2000 frame into ISP stream
   frame: first is by +79 degrees about Z, and second is by +97.7
   degrees about new position of Y.

   \begindata

      FRAME_SDU_ISP_STREAM       = -29300
      FRAME_-29300_NAME          = 'SDU_ISP_STREAM'
      FRAME_-29300_CLASS         = 4
      FRAME_-29300_CLASS_ID      = -29300
      FRAME_-29300_CENTER        = -29
      TKFRAME_-29300_SPEC        = 'ANGLES'
      TKFRAME_-29300_RELATIVE    = 'ECLIPJ2000'
      TKFRAME_-29300_ANGLES      = ( -79.0, -97.7, 0.0 )
      TKFRAME_-29300_AXES        = (   3,     2,   3   )
      TKFRAME_-29300_UNITS       = 'DEGREES'
      
   \begintext


SDU NAIF ID Codes - Definition Section
-------------------------------------------------------------------------------

   This section contains name to NAIF ID mappings for Stardust.

SDU Spacecraft:
---------------

   \begindata

     NAIF_BODY_NAME  += ( 'STARDUST'                 )
     NAIF_BODY_CODE  += ( -29                        )

     NAIF_BODY_NAME  += ( 'SDU'                      )
     NAIF_BODY_CODE  += ( -29                        )

     NAIF_BODY_NAME  += ( 'STARDUST_SRC'             )
     NAIF_BODY_CODE  += ( -29900                     )

     NAIF_BODY_NAME  += ( 'SDU_SRC'                  )
     NAIF_BODY_CODE  += ( -29900                     )

     NAIF_BODY_NAME  += ( 'SDU_SPACECRAFT_BUS'       )
     NAIF_BODY_CODE  += ( -29000                     )

   \begintext


SDU Science Instruments:
------------------------

   \begindata

     NAIF_BODY_NAME  += ( 'SDU_NC'                   )
     NAIF_BODY_CODE  += ( -29010                     )

     NAIF_BODY_NAME  += ( 'SDU_NAVCAM'               )
     NAIF_BODY_CODE  += ( -29010                     )

     NAIF_BODY_NAME  += ( 'SDU_CIDA'                 )
     NAIF_BODY_CODE  += ( -29020                     )

     NAIF_BODY_NAME  += ( 'SDU_DFMI'                 )
     NAIF_BODY_CODE  += ( -29030                     )

     NAIF_BODY_NAME  += ( 'SDU_COLLECTOR'            )
     NAIF_BODY_CODE  += ( -29040                     )

     NAIF_BODY_NAME  += ( 'SDU_DUST_COLLECTOR'       )
     NAIF_BODY_CODE  += ( -29040                     )

   \begintext


SDU Structures:
---------------

   \begindata

     NAIF_BODY_NAME  += ( 'SDU_STARCAM_A'            )
     NAIF_BODY_CODE  += ( -29110                     )

     NAIF_BODY_NAME  += ( 'SDU_STARCAM_B'            )
     NAIF_BODY_CODE  += ( -29120                     )

     NAIF_BODY_NAME  += ( 'SDU_HGA'                  )
     NAIF_BODY_CODE  += ( -29210                     )

     NAIF_BODY_NAME  += ( 'SDU_MGA'                  )
     NAIF_BODY_CODE  += ( -29211                     )

     NAIF_BODY_NAME  += ( 'SDU_LGA1'                 )
     NAIF_BODY_CODE  += ( -29212                     )

     NAIF_BODY_NAME  += ( 'SDU_LGA2'                 )
     NAIF_BODY_CODE  += ( -29214                     )

     NAIF_BODY_NAME  += ( 'SDU_LGA3'                 )
     NAIF_BODY_CODE  += ( -29213                     )

   \begintext


Target Bodies:
--------------

   \begindata

     NAIF_BODY_NAME  += ( 'WILD 2'                   )
     NAIF_BODY_CODE  += ( 1000107                    )

     NAIF_BODY_NAME  += ( 'WILD-2'                   )
     NAIF_BODY_CODE  += ( 1000107                    )

     NAIF_BODY_NAME  += ( 'WILD2'                    )
     NAIF_BODY_CODE  += ( 1000107                    )

     NAIF_BODY_NAME  += ( '81P/WILD 2 (1978 A2)'     )
     NAIF_BODY_CODE  += ( 1000107                    )

     NAIF_BODY_NAME  += ( 'ANNEFRANK'                )
     NAIF_BODY_CODE  += ( 2005535                    )

     NAIF_BODY_NAME  += ( '5535 ANNEFRANK'           )
     NAIF_BODY_CODE  += ( 2005535                    )

   \begintext

