C$Procedure      ZZDYNCHK ( Dynamic transformation check )
 
      SUBROUTINE ZZDYNCHK ( FROM, TO, OK, RELTO, INVERT )
 
C$ Abstract
C
C     SPICE Private routine intended solely for the support of SPICE
C     routines.  Users should not call this routine directly due
C     to the volatile nature of this routine.
C
C     Determine whether the FROM and TO frames of a dynamic frame
C     transformatio specification are compatible.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
      CHARACTER*(*)         FROM
      CHARACTER*(*)         TO
      LOGICAL               OK
      CHARACTER*(*)         RELTO
      LOGICAL               INVERT
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     FROM       I   Frame to transform from
C     TO         I   Frame to transform to
C     OK         O   TRUE if FROM and TO are compatible
C     RELTO      O   Name of the non-dynamic frame
C     INVERT     O   TRUE if TO is 'DYNAMIC', otherwise FALSE.
C
C$ Detailed_Input
C
C     FROM       is the name a frame to transform from
C
C     TO         is the name of the frame to transform to
C
C                 One of the two frames must be 'DYNAMIC' which
C                 specifies the frame defined by calls to DYNMPR and
C                 DYNMSC.  The other frame must be of the form 'FRAME
C                 <frame_name>' where <frame_name> is the name of some
C                 frame recognized by FRAMEX (if necessary, after
C                 appropriate frame definitions have been loaded).  The
C                 error 'SPICE(BADXFORMREQUEST)' will be signalled if
C                 the two frames do not satisfy the requirements
C                 spelled out above.
C
C
C$ Detailed_Output
C
C     OK          Is true if FROM and TO are compatible.
C
C     RELTO       Is the name of the frame that is not the DYNAMIC
C                 frame. If OK is FALSE.  RELTO will have no meaning.
C
C     INVERT      is TRUE if the frame to transform TO is 'DYNAMIC'.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     1) If FROM and TO do not satisfy the requirement layed out above
C        the error 'SPICE(BADXFORMREQUEST)' will be signalled.
C
C     2) If the frame specified by the 'FRAME <frame_name>' string
C        is not recognized, the error 'SPICE(UNRECOGNIZEDFRAME)' will
C        be signalled.
C
C$ Particulars
C
C     This is a utility routine that encapsulates the error checking
C     required by the entry points DYNMXF and DYNMRT of DYNMFR.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 17-MAR-2000 (WLT)
C
C
C-&
C
C     SPICELIB Functions
C
      LOGICAL               EQSTR
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 32 )
 
      CHARACTER*(WDSIZE)    WORD
      CHARACTER*(WDSIZE)    REST
      INTEGER               ID
 
      OK = .FALSE.
C
C     Make sure we have a legitimate request
C
      IF ( EQSTR( FROM, 'DYNAMIC' ) ) THEN
 
         INVERT = .FALSE.
 
         CALL NEXTWD ( TO, WORD, REST )
 
         IF ( WORD .NE. 'FRAME' ) THEN
            CALL SETMSG ( 'The frames specified are ''#'' and '
     .      //            '''#''.  These do not satisfy the '
     .      //            'requirement that one must be '
     .      //            '''DYNAMIC'' and the other must be of '
     .      //            'the form ''FRAME <frame_name>''  See '
     .      //            'the header of the entry point DYNMXF '
     .      //            'in the routine DYNMFR for more '
     .      //            'details on this requirement. ' )
            CALL ERRCH  ( '#', FROM )
            CALL ERRCH  ( '#', TO   )
            CALL SIGERR ( 'SPICE(BADXFORMREQUEST)' )
            RETURN
         ELSE
            CALL NAMFRM ( REST, ID )
 
            IF ( ID .EQ. 0 ) THEN
               CALL SETMSG ( 'The frame ''#'' specified by ''#'' '
     .         //            'is not a recognized reference '
     .         //            'frame.  You may need to load a '
     .         //            'frame kernel before attempting to '
     .         //            'continue. ' )
               CALL ERRCH  ( '#', REST )
               CALL ERRCH  ( '#', TO   )
               CALL SIGERR ( 'SPICE(UNRECOGNIZEDFRAME)' )
               RETURN
            END IF
 
            RELTO = REST
 
         END IF
 
      ELSE IF( EQSTR( TO, 'DYNAMIC' ) ) THEN
 
         INVERT = .TRUE.
 
         CALL NEXTWD ( FROM, WORD, REST )
 
         IF ( WORD .NE. 'FRAME' ) THEN
            CALL SETMSG ( 'The frames specified are ''#'' and '
     .      //            '''#''.  These do not satisfy the '
     .      //            'requirement that one must be '
     .      //            '''DYNAMIC'' and the other must be of '
     .      //            'the form ''FRAME <frame_name>''  See '
     .      //            'the header of the entry point DYNMXF '
     .      //            'in the routine DYNMFR for more '
     .      //            'details on this requirement. ' )
            CALL ERRCH  ( '#', FROM )
            CALL ERRCH  ( '#', TO   )
            CALL SIGERR ( 'SPICE(BADXFORMREQUEST)' )
            RETURN
         ELSE
            CALL NAMFRM ( REST, ID )
 
            IF ( ID .EQ. 0 ) THEN
               CALL SETMSG ( 'The frame ''#'' specified by ''#'' '
     .         //            'is not a recognized reference '
     .         //            'frame.  You may need to load a '
     .         //            'frame kernel before attempting to '
     .         //            'continue. ' )
               CALL ERRCH  ( '#', REST )
               CALL ERRCH  ( '#', TO   )
               CALL SIGERR ( 'SPICE(UNRECOGNIZEDFRAME)' )
               RETURN
            END IF
 
            RELTO = REST
 
         END IF
 
      ELSE
 
         CALL SETMSG ( 'The frames specified are ''#'' and '
     .   //            '''#''.  These do not satisfy the '
     .   //            'requirement that one must be '
     .   //            '''DYNAMIC'' and the other must be of '
     .   //            'the form ''FRAME <frame_name>''  See '
     .   //            'the header of the entry point DYNMXF '
     .   //            'in the routine DYNMFR for more '
     .   //            'details on this requirement. ' )
         CALL ERRCH  ( '#', FROM )
         CALL ERRCH  ( '#', TO   )
         CALL SIGERR ( 'SPICE(BADXFORMREQUEST)' )
         RETURN
 
      END IF
 
      OK = .TRUE.
 
      RETURN
      END
