C$Procedure      MAKCLK ( Make an SCLK kernel )
 
      SUBROUTINE MAKCLK ( SCFILE, SCLKID, SCLKBG, SCID, CKID  )
 
C$ Abstract
C
C     This routine creates a simple SCLK kernel for those times
C     when you don't have a real clock available or you
C     just need something quick and dirty.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C      None.
C
C$ Keywords
C
C      UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
 
      CHARACTER*(*)         SCFILE
      INTEGER               SCLKID
      DOUBLE PRECISION      SCLKBG
      INTEGER               SCID
      INTEGER               CKID
 
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     SCFILE     I   Name of the SCLK File to create
C     SCLKID     I   Id-code for the clock
C     SCLKBG     I   Beginning of the clock (ET seconds past J2000).
C     SCID       I   Id-code of the spacecraft of the clock
C     CKID       I   Id-code of structure for which this clock pertains
C
C$ Detailed_Input
C
C     SCFILE     Name of the SCLK File to create.
C
C     SCLKID     Id-code for the clock.  This is the actual clock ID
C                not the value used by SCE2T.
C
C     SCLKBG     The beginning of the clock in TDB seconds past the
C                epoch of the J2000 frame.
C
C     SCID       is the id-code of the spacecraft for which this SCLK
C                file should be used.
C
C     CKID       is the d-code of structure for which this clock
C                is to be used in the construction and interpretation
C                of C-kernels.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     This routine creates an SCLK kernel that simply models
C     TDB seconds past the input epoch SCLKBG.  The granularity
C     of this clock is 0.1 milliseconds.
C
C     This clock ticks once every 0.1 milliseconds of ET for all
C     time.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine allows anyone creating C-kernels to have a
C     readily available SCLK kernel for the construction of that
C     C-kernel that simply follows ET.
C
C$ Examples
C
C     None.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.1.0, 02-NOV-2006 (BVS)
C
C        Replaced LDPOOL with FURNSH in the comments of the output SCLK
C        file.
C
C-    SPICELIB Version 1.0.0, 11-NOV-1996 (WLT)
C
C
C-&
 
C$ Index_Entries
C
C     Create an SCLK kernel that follows ET precisely
C
C-&
C
C
C     SPICELIB Functions
C
      INTEGER               RTRIM

      CHARACTER*(12)        BEGDAT
C
C     Local Variables
C
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      CHARACTER*(LNSIZE)    SCLK  ( 100 )
      CHARACTER*(LNSIZE)    START
 
 
      INTEGER               WDSIZE
      PARAMETER           ( WDSIZE = 32 )
 
 
      INTEGER               I
      INTEGER               R
      INTEGER               UNIT
 
 
      INTEGER               STDOUT
      PARAMETER           ( STDOUT = 6 )
 
 
      SCLK(  1 ) = ' '
      SCLK(  2 ) = 'TEST SPICE SCLK Kernel'
      SCLK(  3 ) = '-----------------------------------------'
     .//           '---------------'
      SCLK(  4 ) = ' '
      SCLK(  5 ) = 'This file contains the data necessary for'
     .//           ' converting from ET to'
      SCLK(  6 ) = 'ticks for the fictional spacecraft clock '
     .//           'having id code #.  It is'
      SCLK(  7 ) = 'produced by the utility program makeck2.'
      SCLK(  8 ) = ' '
      SCLK(  9 ) = 'This SCLK kernel is intended to be used w'
     .//           'ith the test CK file with'
      SCLK( 10 ) = 'structure id & on board the spacecraft %'
     .//           '.'
      SCLK( 11 ) = ' '
      SCLK( 12 ) = 'This fictional clock begins at ! ET and c'
     .//           'ontinues'
      SCLK( 13 ) = 'for 1 billion seconds.  The clock has a g'
     .//           'ranularity of 0.1'
      SCLK( 14 ) = 'milliseconds.'
      SCLK( 15 ) = ' '
      SCLK( 16 ) = 'This is intended for study purposes or fo'
     .//           'r those situations in'
      SCLK( 17 ) = 'which a clock is not available for the st'
     .//           'ructure whose orientation'
      SCLK( 18 ) = 'will be modelled by a C-kernel.'
      SCLK( 19 ) = ' '
      SCLK( 20 ) = 'If you have any questions about this file'
     .//           ' that these comments don''t'
      SCLK( 21 ) = 'answer, contact Bill Taber at NAIF.'
      SCLK( 22 ) = ' '
      SCLK( 23 ) = '(818) 354-4279'
      SCLK( 24 ) = 'btaber@spice.jpl.nasa.gov'
      SCLK( 25 ) = ' '
      SCLK( 26 ) = ' '
      SCLK( 27 ) = ' '
      SCLK( 28 ) = 'Implementation notes'
      SCLK( 29 ) = '-----------------------------------------'
     .//           '---------------'
      SCLK( 30 ) = ' '
      SCLK( 31 ) = 'This SCLK file is constructed so that the'
     .//           ' valid SCLK strings'
      SCLK( 32 ) = 'are simply the number of TDB seconds that'
     .//           ' have passed'
      SCLK( 33 ) = 'since the Ephemeris epoch !.'
      SCLK( 34 ) = 'Thus 1/ 288929292.8201  simply repres'
     .//           'ents the epoch that occurs'
      SCLK( 35 ) = '288929292.8201 TDB seconds past the ET e'
     .//           'poch !.'
      SCLK( 36 ) = ' '
      SCLK( 37 ) = ' '
      SCLK( 38 ) = 'For all time, the clock runs at the same '
     .//           'rate as TDB. There is only'
      SCLK( 39 ) = 'one partition for this clock.'
      SCLK( 40 ) = ' '
      SCLK( 41 ) = 'You must load this file into the kernel p'
     .//           'ool before using any of the'
      SCLK( 42 ) = 'SPICELIB SCLK routines. The code fragment'
      SCLK( 43 ) = ' '
      SCLK( 44 ) = 'CALL FURNSH ( < name of this file > )'
      SCLK( 45 ) = ' '
      SCLK( 46 ) = 'performs this task. To convert between ET'
     .//           ' and UTC, you will also need'
      SCLK( 47 ) = 'to load a leapseconds kernel. The additio'
     .//           'nal call to FURNSH,'
      SCLK( 48 ) = ' '
      SCLK( 49 ) = 'CALL FURNSH ( < name of your leapsecond f'
     .//           'ile > )'
      SCLK( 50 ) = ' '
      SCLK( 51 ) = 'will accomplish this. Note that you must '
     .//           'supply the actual names of'
      SCLK( 52 ) = 'the files used on your system as argument'
     .//           's to FURNSH. Because the file'
      SCLK( 53 ) = 'names are system dependent, we do not lis'
     .//           't them here.'
      SCLK( 54 ) = ' '
      SCLK( 55 ) = 'For more information, consult your SPICEL'
     .//           'IB required reading files.'
      SCLK( 56 ) = 'The following areas are covered:'
      SCLK( 57 ) = ' '
      SCLK( 58 ) = 'SCLK system                     SCLK requ'
     .//           'ired reading'
      SCLK( 59 ) = 'Time systems and conversion     TIME requ'
     .//           'ired reading'
      SCLK( 60 ) = 'Kernel pool                     KERNEL re'
     .//           'quired reading'
      SCLK( 61 ) = ' '
      SCLK( 62 ) = ' '
      SCLK( 63 ) = 'Kernel data'
      SCLK( 64 ) = '-----------------------------------------'
     .//           '---------------'
      SCLK( 65 ) = ' '
      SCLK( 66 ) = ' '
      SCLK( 67 ) = BEGDAT()
      SCLK( 68 ) = ' '
      SCLK( 69 ) = ' '
      SCLK( 70 ) = 'SCLK_KERNEL_ID             = ( @28-OCT-19'
     .//           '94        )'
      SCLK( 71 ) = ' '
      SCLK( 72 ) = 'SCLK_DATA_TYPE_#           = ( 1 )'
      SCLK( 73 ) = ' '
      SCLK( 74 ) = 'SCLK01_TIME_SYSTEM_#       = ( 1 )'
      SCLK( 75 ) = 'SCLK01_N_FIELDS_#          = ( 2 )'
      SCLK( 76 ) = 'SCLK01_MODULI_#            = ( 1000000000'
     .//           '     10000 )'
      SCLK( 77 ) = 'SCLK01_OFFSETS_#           = ( 0         '
     .//           '0 )'
      SCLK( 78 ) = 'SCLK01_OUTPUT_DELIM_#      = ( 1 )'
      SCLK( 79 ) = ' '
      SCLK( 80 ) = 'SCLK_PARTITION_START_#     = ( 0.00000000'
     .//           '00000E+00 )'
      SCLK( 81 ) = 'SCLK_PARTITION_END_#       = ( 1.00000000'
     .//           'E+14      )'
      SCLK( 82 ) = 'SCLK01_COEFFICIENTS_#      = ( 0.00000000'
     .//           'E+00'
      SCLK( 83 ) = '                               @!'
      SCLK( 84 ) = '                               1  )'
      SCLK( 85 ) = ' '
      SCLK( 86 ) = ' '
      SCLK( 87 ) = 'DELTET/DELTA_T_A    =   32.184'
      SCLK( 88 ) = 'DELTET/K            =    1.657D-3'
      SCLK( 89 ) = 'DELTET/EB           =    1.671D-2'
      SCLK( 90 ) = 'DELTET/M            = (  6.239996D0 1.990'
     .//           '96871D-7 )'
      SCLK( 91 ) = ' '
      SCLK( 92 ) = 'CK_&_SCLK       =   ^'
      SCLK( 93 ) = 'CK_&_SPK        =   %'
 
 
 
 
      CALL ETCAL  ( SCLKBG,        START )
      CALL CMPRSS ( ' ', 1, START, START )
      R = RTRIM   ( START )
      CALL REPLCH ( START(1:R), ' ', '-', START(1:R) )
 
 
      DO I = 1, 93
 
         CALL REPMI ( SCLK(I), '#',  SCLKID, SCLK(I) )
         CALL REPMI ( SCLK(I), '^', -SCLKID, SCLK(I) )
         CALL REPMI ( SCLK(I), '&',  CKID,   SCLK(I) )
         CALL REPMI ( SCLK(I), '%',  SCID,   SCLK(I) )
         CALL REPMC ( SCLK(I), '!',  START,  SCLK(I) )
 
      END DO
 
 
      CALL TXTOPN ( SCFILE, UNIT )
 
      DO I = 1, 93
         CALL WRITLN ( SCLK(I), UNIT )
      END DO
 
      CLOSE ( UNIT )
 
      END
