C$Procedure      EZRPRT ( Easy Report)
 
      SUBROUTINE EZRPRT ( START, FINISH, BTWEEN, COUNT )
 
C$ Abstract
C
C    This is a simple in-progress report generator.  It simply reports
C    the percentage of task completed every time the task finishes
C    5% more of the work.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
 
      IMPLICIT NONE
      DOUBLE PRECISION      START
      DOUBLE PRECISION      FINISH
      DOUBLE PRECISION      BTWEEN
      INTEGER               COUNT
 
C$ Brief_I/O
C
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     START      I   First epoch for which work will be done
C     FINISH     I   Last epoch for which work will be done
C     BTWEEN     I   A particular point in the work
C
C$ Detailed_Input
C
C     START      is the first epoch for which some work will be done.
C     .
C     FINISH     is the last epoch for which some work will be done.
C
C     BTWEEN     is any point between START and FINISH at which work
C                has been completed.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This is an umbrella routine for the pair of entry points
C
C        1) RSETUP  which sets up a report.
C
C        2) RUPDAT  which updates the current amount of work that's
C           been completed.
C
C$ Examples
C
C     Suppose you plan to process some data starting at time
C     START and ending with time FINISH.  Initialize the
C     reporting utility by the call
C
C        CALL RSETUP ( START, FINISH )
C
C     Now do some work until everything is done.
C
C     AT = START
C
C     DO WHILE ( AT .LE. FINISH )
C
C        Do some processing for the time AT.
C
C
C        Report that we've done the work
C
C        CALL RUPDAT ( AT )
C
C        Increment AT,
C
C        CALL INCR ( AT )
C
C     END DO
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 08-AUG-1997 (WLT)
C
C
C-&
 
      INTEGER               LNSIZE
      PARAMETER           ( LNSIZE = 80 )
 
      CHARACTER*(LNSIZE)    LINE
      CHARACTER*(6)         STR
 
      DOUBLE PRECISION      CURRNT
      DOUBLE PRECISION      TARGET
      DOUBLE PRECISION      MYBEG
      DOUBLE PRECISION      MYEND
      DOUBLE PRECISION      Q
      DOUBLE PRECISION      R
 
      SAVE                  MYBEG
      SAVE                  MYEND
      SAVE                  TARGET
 
      RETURN
 
 
C$Procedure      RSETUP ( Report Setup )
 
      ENTRY RSETUP ( START, FINISH )
 
C$ Abstract
C
C    Setup the reporter for generating progress reports
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
C
 
C     IMPLICIT NONE
C     DOUBLE PRECISION      START
C     DOUBLE PRECISION      FINISH
 
C
C$ Brief_I/O
C     VARIABLE  I/O  DESCRIPTION
C     --------  ---  --------------------------------------------------
C     START      I   The starting point for work (often an epoch)
C     FINISH     I   The ending point for work (often an epoch)
C
C$ Detailed_Input
C
C     START      is the beginning value of some set of items that
C                will be processed.  This is often the starting
C                epoch for some search or data generation process.
C
C     FINISH     is the last value of some set of items that will
C                be processed.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine stores START and FINISH and prints a message
C     indicating that 0% of the anticpated work has been done.
C
C$ Examples
C
C     See the Umbrella rouine header
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 5-AUG-1997 (WLT)
C
C
C-&
 
 
      MYBEG = START
      MYEND = FINISH
 
      CALL TOSTDO ( 'Constructing Segment ' )
 
      CALL ETCAL  ( START, LINE )
      CALL PREFIX ( 'From:', 1,  LINE )
      CALL TOSTDO ( LINE )
 
      CALL ETCAL  ( FINISH, LINE )
      CALL PREFIX ( 'To  :', 1,  LINE )
      CALL TOSTDO ( LINE )
 
 
      LINE = '   Percentage finished:   0.0%'
 
      CALL TOSTDO ( LINE )
 
      TARGET = 5.0D0
      RETURN
 
 
 
C$Procedure      RUPDAT ( Report Update )
 
      ENTRY RUPDAT ( BTWEEN, COUNT )
 
C$ Abstract
C
C    This routine updates the progress reporter, letting it
C    know where things are in the work that is being performed.
C
C$ Disclaimer
C
C     THIS SOFTWARE AND ANY RELATED MATERIALS WERE CREATED BY THE
C     CALIFORNIA INSTITUTE OF TECHNOLOGY (CALTECH) UNDER A U.S.
C     GOVERNMENT CONTRACT WITH THE NATIONAL AERONAUTICS AND SPACE
C     ADMINISTRATION (NASA). THE SOFTWARE IS TECHNOLOGY AND SOFTWARE
C     PUBLICLY AVAILABLE UNDER U.S. EXPORT LAWS AND IS PROVIDED "AS-IS"
C     TO THE RECIPIENT WITHOUT WARRANTY OF ANY KIND, INCLUDING ANY
C     WARRANTIES OF PERFORMANCE OR MERCHANTABILITY OR FITNESS FOR A
C     PARTICULAR USE OR PURPOSE (AS SET FORTH IN UNITED STATES UCC
C     SECTIONS 2312-2313) OR FOR ANY PURPOSE WHATSOEVER, FOR THE
C     SOFTWARE AND RELATED MATERIALS, HOWEVER USED.
C
C     IN NO EVENT SHALL CALTECH, ITS JET PROPULSION LABORATORY, OR NASA
C     BE LIABLE FOR ANY DAMAGES AND/OR COSTS, INCLUDING, BUT NOT
C     LIMITED TO, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND,
C     INCLUDING ECONOMIC DAMAGE OR INJURY TO PROPERTY AND LOST PROFITS,
C     REGARDLESS OF WHETHER CALTECH, JPL, OR NASA BE ADVISED, HAVE
C     REASON TO KNOW, OR, IN FACT, SHALL KNOW OF THE POSSIBILITY.
C
C     RECIPIENT BEARS ALL RISK RELATING TO QUALITY AND PERFORMANCE OF
C     THE SOFTWARE AND ANY RELATED MATERIALS, AND AGREES TO INDEMNIFY
C     CALTECH AND NASA FOR ALL THIRD-PARTY CLAIMS RESULTING FROM THE
C     ACTIONS OF RECIPIENT IN THE USE OF THE SOFTWARE.
C
C$ Required_Reading
C
C     None.
C
C$ Keywords
C
C     UTILITY
C
C$ Declarations
C
 
C     IMPLICIT NONE
C     DOUBLE PRECISION      BTWEEN
 
C
C$ Brief_I/O
C     VARIABLE  I/O  DESCRIPTION
C
C     --------  ---  --------------------------------------------------
C     BTWEEN     I   number corresponding to current progress.
C     COUNT      I   number of items collected so far.
C
C     The function returns
C
C$ Detailed_Input
C
C     BTWEEN     is a double precision number that corresponds to the
C                last complete portion of some task that is being
C                carried out.
C
C$ Detailed_Output
C
C     None.
C
C$ Parameters
C
C     None.
C
C$ Files
C
C     None.
C
C$ Exceptions
C
C     Error free.
C
C$ Particulars
C
C     This routine prints a message each time another 5% of some
C     task is completed.  You must call RSETUP before calling
C     this routine to establish the bound of the process being
C     performed.
C
C$ Examples
C
C     See Umbrella routine.
C
C$ Restrictions
C
C     None.
C
C$ Author_and_Institution
C
C     W.L. Taber      (JPL)
C
C$ Literature_References
C
C     None.
C
C$ Version
C
C-    SPICELIB Version 1.0.0, 9-AUG-1997 (WLT)
C
C
C-&
 
 
 
      CURRNT = 100.0D0 * ( BTWEEN - MYBEG ) / ( MYEND - MYBEG )
 
      IF ( CURRNT .GE. TARGET ) THEN
 
C         CALL TOSTDO ( ' ' )
C         CALL ETCAL  ( BTWEEN, LINE )
C         CALL TOSTDO ( LINE )
 
 
         CALL DPFMT ( CURRNT, 'xxx.x', STR )
         LINE = '   Percentage finished: '
     .   //     STR
     .   // '%    (# quaternions)'
         CALL REPMI ( LINE, '#', COUNT, LINE )
 
         CALL TOSTDO( LINE )
 
         CALL RMAIND ( CURRNT, 5.0D0, Q, R )
         TARGET = 5.0D0 * ( Q + 1.0D0 )
 
       END IF
 
      RETURN
      END
