import os
import subprocess
import datetime

import numpy as np
# import gnuplotlib as gp

def mkgap(main_sc_name, object_frame, exe_dir, version,
          target_frame='J2000', minimum_duration='',
          lsk='', sclk='', fk='', ck='', histogram=True ):


    kernels = f"{lsk} {sclk} {fk} {ck}"

    if minimum_duration:
        minimum_duration = "| grep -v ' 0:0[0123]:'"


    command = f"{exe_dir}/frmdiff -k {kernels} -t dumpg -f1 {target_frame} -t1 {object_frame} -f YYYY-MM-DDTHR:MN:SC ::UTC  {minimum_duration}"
    command_line_process = subprocess.Popen(command, shell=True,
                                            stdout=subprocess.PIPE,
                                            stderr=subprocess.STDOUT)
    process_output, _ = command_line_process.communicate()
    command_line_process.wait()
    frmdiff_output = process_output.decode("utf-8")
    frmdiff_output = frmdiff_output.split('\n')
    gap_durations = []
    for line in frmdiff_output:
        if "#    from" in line and 'TDB seconds' in line:
            start_time = float(line.split("(")[1].split()[0])
        if "#    to" in line and 'TDB seconds'in line:
            stop_time = float(line.split("(")[1].split()[0])
        if '#' not in line:
            try:
                gap_durations.append(float(line.split()[2]))

            except:
                pass

    gap_durations = np.array(gap_durations)
    gap_duration = np.sum(gap_durations)
    #
    # If there is no stop or start time, we might get valuable information
    # from a problem in the CK file, we get it.
    #
    try:
        total_duration = stop_time - start_time
    except:
        raise NameError(frmdiff_output)

    gap_percentage = gap_duration / total_duration * 100


    cmd = [exe_dir + os.sep + 'tdb2utc ' + str(start_time) + ' ' + lsk]
    command_line_process = subprocess.Popen(cmd, shell=True,
                                            stdout=subprocess.PIPE,
                                            stderr=subprocess.STDOUT)
    command_line_process.wait()
    process_output = command_line_process.communicate()[0]
    start_utc = str(process_output.decode('utf-8')).split('\n')[0].strip()



    cmd = [exe_dir + os.sep + 'tdb2utc ' + str(stop_time) + ' ' + lsk]
    command_line_process = subprocess.Popen(cmd, shell=True,
                                            stdout=subprocess.PIPE,
                                            stderr=subprocess.STDOUT)
    command_line_process.wait()
    process_output = command_line_process.communicate()[0]
    stop_utc = str(process_output.decode('utf-8')).split('\n')[0].strip()


    header = f"# {main_sc_name} Measured Attitude Gap Report\n" \
             f"# Generated with ADCSng v{version} at {datetime.datetime.now().strftime('%Y-%m-%dT%H:%M:%S')} by the ESA SPICE Service" \
             f"\n#\n# Gap Report for: {ck.split(os.sep)[-1]}\n#\n" \
             f"#   Coverage Start:  '{start_utc}' UTC\n" \
             f"#   Coverage Stop:   '{stop_utc}' UTC\n#\n" \
             f"# Gaps: {np.size(gap_durations)}\n#\n" \
             f"#    Gaps duration: {gap_duration:.2f}s\n" \
             f"#    Data duration: {total_duration:.2f}s\n" \
             f"#    Gaps/Data:     {gap_percentage:3.2f}%\n" \

    if histogram:
        try:
            bins = 12
            binwidth = np.max(gap_durations) / (bins - 1)
            dur_hist, bins = np.histogram(gap_durations, bins=bins)

            gp.plot((gap_durations, dict(histogram='freq', binwidth=binwidth)),
                        terminal='dumb 75,17', output='temp.txt',
                        unset='grid')

            header += f"#\n" \
                      f"# Gaps Histogram (Bins in hours):\n" \
                      f"#   "+" "*len(f"{bins[0]/60/60:02.2f}")

            index = 0
            for gap_count in dur_hist:
                num_char = len(f"{bins[index] / 60 / 60:02.2f}") - 1
                header += f"{gap_count:02}" + " " * num_char
                index += 1
            header += '\n#   '
            for bin in bins:
                header += f"{bin / 60 / 60:02.2f} "

            header += "\n#\n# Number of Gaps\n"

            with open('temp.txt', 'r') as p:
                for line in p:
                    if line.strip():
                        header += f'# {line}'

            header += "#" + " " * 25 + "Gap Bin Duration in seconds\n"


        except:
            pass

    header += "#\n# gap_start         gap_stop              gap_duration_sec   gap_duration_string\n"
    header += "# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n"
    output = header

    for line in frmdiff_output:
        if '#' not in line:
            output += line + '\n'


    return output
