import numpy as np
from numpy import cos, sin, pi

from datetime import datetime, timedelta

def sepm_to_cog(source):

    #
    # We need to negate the positions and convert it to KM (it is in M)
    #
    cog_list = []
    with open(source, 'r') as t:
        for line in t.readlines():
            if 'INITIAL TIME' in line:
                ITDB = line.split('TDB:')[1].split('(')[0].replace('/', '-')
                #
                # this section only appends and state from the second thruster firing on for propagating the last step
                #
                if cog_list:
                    ITDBp = (datetime.strptime(ITDB[1:-1], "%Y-%m-%d %H:%M:%S.%f") - timedelta(seconds=1)).strftime(" %Y-%m-%d %H:%M:%S.%f ")
                    line = ITDBp + FCOM + ' 0.0 0.0 0.0'
                    line = line.split()
                    line[2] = str(-float(line[2]) / 1000)
                    line[3] = str(-float(line[3]) / 1000)
                    line[4] = str(-float(line[4]) / 1000)
                    line = ' '.join(line).replace(' ', 'T', 1)
                    cog_list.append(line)

            #
            # append the initial and final COM states
            #
            if 'FINAL TIME' in line: FTDB = line.split('TDB:')[1].split('(')[0].replace('/', '-')
            if 'INITIAL S/C COM' in line: ICOM = line.split('[m]:')[1].split('\n')[0]
            if 'FINAL S/C COM' in line:
                FCOM = line.split('[m]:')[1].split('\n')[0]

                line = ITDB + ICOM + ' 0.0 0.0 0.0'
                line = line.split()
                line[2] = str(-float(line[2]) / 1000)
                line[3] = str(-float(line[3]) / 1000)
                line[4] = str(-float(line[4]) / 1000)
                line = ' '.join(line).replace(' ', 'T', 1)
                cog_list.append(line)

                line = FTDB + FCOM + ' 0.0 0.0 0.0'
                line = line.split()
                line[2] = str(-float(line[2]) / 1000)
                line[3] = str(-float(line[3]) / 1000)
                line[4] = str(-float(line[4]) / 1000)
                line = ' '.join(line).replace(' ', 'T', 1)
                cog_list.append(line)
    return cog_list


def events_to_sep(source):
    sep_list = []
    with open(source, 'r') as t:
        flag = False
        for line in t.readlines():
            if 'EMAS' in line and flag == False:
                flag = True
                utcdateS = datetime.strptime(line.split('time="')[1].split('Z')[0], '%Y-%jT%H:%M:%S.%f').strftime("%Y-%m-%dT%H:%M:%S.%f ")
                if sep_list and utcdateE != utcdateS:
                    sep_list.append(utcdateE + utcdateS + ' 0 0 0 0 0 0')
            if 'EMAE' in line and flag == True:
                flag = False
                utcdateE = datetime.strptime(line.split('time="')[1].split('Z')[0], '%Y-%jT%H:%M:%S.%f').strftime("%Y-%m-%dT%H:%M:%S.%f ")
                if utcdateE != utcdateS:
                    sep_list.append(utcdateS + utcdateE + ' 180 0 0 0 0 0')
    return sep_list


def phebus_fov_reader(s):

    d = 100

    d = np.radians(d)
    s = np.radians(s)

    z_fov = np.array([sin(d) * cos(s - pi / 4.),
                      cos(d),
                      -1 * sin(d) * sin(s - pi / 4.)])

    y_fov = np.array([sin(d / 2) * sin(d / 2) * cos(2 * s),
                      -1 * sin(d) * sin(s - pi / 4.),
                      -1 * sin(d / 2) * sin(d / 2) * sin(
                      2 * s) - 1 * cos(d / 2) * cos(d / 2)])

    x_fov = np.cross(y_fov, z_fov)

    rotation = np.array([x_fov, y_fov, z_fov])

    return rotationMatrixToEulerAngles(rotation)


# Checks if a matrix is a valid rotation matrix.
def isRotationMatrix(R):
    Rt = np.transpose(R)
    shouldBeIdentity = np.dot(Rt, R)
    I = np.identity(3, dtype=R.dtype)
    n = np.linalg.norm(I - shouldBeIdentity)
    return n < 1e-6


# Calculates rotation matrix to euler angles
# The result is the same as MATLAB except the order
# of the euler angles ( x and z are swapped ).
def rotationMatrixToEulerAngles(R):
    assert (isRotationMatrix(R))

    sy = np.sqrt(R[2, 2] * R[2, 2] + R[1, 2] * R[1, 2])

    singular = sy < 1e-6

    if not singular:
        x = np.degrees(np.arctan2(R[0, 1], R[0, 0]))
        y = np.degrees(np.arctan2(-R[0, 2], sy))
        z = np.degrees(np.arctan2(R[1, 2], R[2, 2]))
    else:
        x = np.degrees(np.arctan2(-R[1, 0], R[1, 1]))
        y = np.degrees(np.arctan2(-R[0, 2], sy))
        z = 0

    return np.array([x, y, z])