#!/bin/csh
#
# This script checks whether combined list file contains any duplicates.
# It requires one input on the command line: the name of the combined "list" 
# file.
#
# Follow the script code and inline comments for particulars.
#
# Version 1.0 --- January 24, 2005 --- BVS/NAIF.
#
set SCRIPTNAME    = "check_list_for_dups.csh"
set SCRIPTVERSION = "Version 1.0 --- January 24, 2005 --- BVS/NAIF"

#
# Get list file name from the command line. Display usage if it is not
# there or if command line does not look as expected.
#
if ( $#argv != 1 ) then
    echo " "
    echo "Usage: % $SCRIPTNAME [list_file_name]"
    echo " "
    exit
else 
    set LISTFILE = "$1"
    if ( ! -e $LISTFILE ) then
        echo " "
        echo "ERROR ($SCRIPTNAME): $LISTFILE does not exist."
        echo " "
        exit
    endif
endif

#
# Grep out file names, sort and sort/uniq them,
# count lines in each set and compare the counts.
#
set SCOUNT = `grep '^ *FILE *= *' $LISTFILE | sed 's/^ *FILE *= *//g' | sort | wc`
set UCOUNT = `grep '^ *FILE *= *' $LISTFILE | sed 's/^ *FILE *= *//g' | sort | uniq | wc`

if ( "$SCOUNT" == "$UCOUNT" ) then
    echo " "
    echo "$LISTFILE contains no duplicates."
    echo " "
else
    echo " "
    echo "$LISTFILE contains the following duplicates:"
    echo " "
    grep '^ *FILE *= *' $LISTFILE | sed 's/^ *FILE *= *//g' | sort | uniq -d
    echo " "
endif


#
# All done.
#
exit
