import os

from arcgen.utils.files import safe_make_directory
from arcgen.utils.files import copy
from arcgen.classes.product import ReadmeProduct

class Bundle(object):

    def __init__(self, mission):

        self.collections = []

        if mission.pds == '3':

            if mission.increment:
                copy(mission.increment + os.sep,
                     mission.bundle_directory + os.sep)

            safe_make_directory(mission.bundle_directory)
            safe_make_directory(mission.bundle_directory + os.sep + 'CATALOG')
            safe_make_directory(mission.bundle_directory + os.sep + 'DATA')
            safe_make_directory(mission.bundle_directory + os.sep + 'DOCUMENT')
            safe_make_directory(mission.bundle_directory + os.sep + 'EXTRAS')
            safe_make_directory(mission.bundle_directory + os.sep + 'INDEX')

        elif mission.pds == '4':

            self.name = f'bundle_{mission.accronym}_spice_v{mission.version}.xml'

            safe_make_directory(mission.bundle_directory)
            safe_make_directory(mission.bundle_directory + os.sep + 'spice_kernels')
            safe_make_directory(mission.bundle_directory + os.sep + 'document')

        self.mission = mission
        self.vid = self.bundle_vid()
        self.lid = self.bundle_lid()

        return

    def add(self, element):
        self.collections.append(element)

    def write_readme(self):
        ReadmeProduct(self.mission, self)

    def bundle_vid(self):

        return '{}.0'.format(int(self.mission.version))

    def bundle_lid(self):

        product_lid = \
            'urn:esa:psa:{}_spice'.format(
                    self.mission.accronym)

        return product_lid

    def increment(self):



        return
