'''
Created on Jan 17, 2020
@author: Marc Costa Sitja
'''
import os
import unittest

from adcsng.utils.files import get_exe_dir

class TestsFunctional(unittest.TestCase):

    def setUp(self):
        from adcsng.core.input import hk_sort_duplicate_filter
        self.hk_sort_duplicate_filter = hk_sort_duplicate_filter

        from adcsng.core.mkgap import mkgap
        self.mkgap = mkgap


    def test_input__1_hk_sort_duplicate_filter___(self):
        source_config = ['',{'time_format':'SCLK'}]
        tm_list = ['1/88396074:16695 0.923412442207336400',
                   '1/100060095:36668 0.107196062803268430',
                   '1/90607637:14609 0.327837884426116940']

        res = self.hk_sort_duplicate_filter(tm_list, source_config)

        self.assertEqual(res, [tm_list[0], tm_list[2], tm_list[1]])


    def test_core___1_mkgap______________________(self):
        main_sc_name = 'ExoMars2016'
        object_frame = 'TGO_SPACECRAFT'
        version      = '1.1.0'
        exe_dir      = f'..{get_exe_dir()}'
        lsk          = f'em16/ker_dir/lsk/naif0012.tls'
        sclk         = f'em16/ker_val/sclk/em16_tgo_step_20180321.tsc'
        fk           = f'em16/ker_dir/fk/em16_tgo_v18.tf'
        ck           = f'em16/ker_val/ck/em16_tgo_sc_ssm_20160520_20181003_s20180321_v01.bc'
        gap_file     = ''

        output = self.mkgap(main_sc_name, object_frame, exe_dir, version,
                            lsk=lsk, sclk=sclk, fk=fk, ck=ck, histogram=False,
                            target_frame='J2000', minimum_duration='')

        with open('em16/misc/reports/em16_tgo_sc_ssm_20160520_20181003_s20180321_v01.gap', 'r') as f:
            for line in f:
                gap_file += line

        self.assertEqual(output.split('\n')[3:],gap_file.split('\n')[3:])


