KPL/MK

Meta-kernel for Solar Orbiter Dataset v100 -- As Flown 20200318_001
==========================================================================

   This meta-kernel lists the Solar_Orbiter As Flown SPICE kernels
   that provide information for the As Flown scenario.

   The kernels listed in this meta-kernel and the order in which
   they are listed are picked to provide the best data available and
   the most complete coverage for the Solar_Orbiter As Flown scenario.

   This meta-kernel was generated with the Auxiliary Data Conversion
   System version: ADCSng v1.0.8dev.


Usage of the Meta-kernel
-------------------------------------------------------------------------

   This file is used by the SPICE system as follows: programs that make use
   of this kernel must "load" the kernel normally during program
   initialization. Loading the kernel associates the data items with
   their names in a data structure called the "kernel pool". The SPICELIB
   routine FURNSH loads a kernel into the pool.

   The kernels listed below can be obtained from the ESA SPICE FTP server:

      ftp://spiftp.esac.esa.int/data/SPICE/SOLAR-ORBITER/kernels/


Implementation Notes
-------------------------------------------------------------------------

   It is recommended that users make a local copy of this file and
   modify the value of the PATH_VALUES keyword to point to the actual
   location of the Solar_Orbiter SPICE data set's ``data'' directory on
   their system. Replacing ``/'' with ``\'' and converting line
   terminators to the format native to the user's system may also be
   required if this meta-kernel is to be used on a non-UNIX workstation.


-------------------

   This file was created on March 18, 2020 by Marc Costa Sitja ESA/ESAC.
   The original name of this file was solo_ANC_soc-flown-mk_V100_20200318_001.tm.


   \begindata

     PATH_VALUES       = ( '../..' )

     PATH_SYMBOLS      = ( 'KERNELS' )

     KERNELS_TO_LOAD   = (

                           '$KERNELS/ck/former_versions/solo_ANC_soc-flown-att_20200208-20200210_V01.bc'
                           '$KERNELS/ck/former_versions/solo_ANC_soc-flown-att_20200209-20200210_V01.bc'
                           '$KERNELS/ck/former_versions/solo_ANC_soc-flown-att_20200210-20200211_V02.bc'
                           '$KERNELS/ck/former_versions/solo_ANC_soc-flown-att_20200212-20200213_V01.bc'

                           '$KERNELS/fk/solo_ANC_soc-sc-fk_V04.tf'

                           '$KERNELS/lsk/naif0012.tls'

                           '$KERNELS/sclk/solo_ANC_soc-sclk_20000101_V01.tsc'

                           '$KERNELS/spk/former_versions/solo_ANC_soc-orbit_20200210-20200210_L000_V0_00000_V01.bsp'
                           '$KERNELS/spk/former_versions/solo_ANC_soc-orbit-stp_20201201-20201226_014_V1_12345_V01.bsp'

                         )

   \begintext


SPICE Kernel Dataset Version
------------------------------------------------------------------------

   The SPICE Kernel Dataset version of the kernels present in this
   meta-kernel is provided by the following keyword (please note that
   this might not be the last version of the SPICE Kernel Dataset):

   \begindata

      SKD_VERSION = 'v100_20200318_001'

   \begintext


Contact Information
------------------------------------------------------------------------

   If you have any questions regarding this file contact the
   ESA SPICE Service (ESS) at ESAC:

           Marc Costa Sitja
           (+34) 91-8131-457
           esa_spice@sciops.esa.int, marc.costa@esa.int,


End of MK file.